/*
 * Decompiled with CFR 0.152.
 */
package org.teatrove.trove.util;

import java.net.URL;

public class DelegateClassLoader
extends ClassLoader {
    private ClassLoader[] mScouts;

    public DelegateClassLoader(ClassLoader parent, ClassLoader[] scouts) {
        super(parent);
        this.mScouts = (ClassLoader[])scouts.clone();
    }

    protected synchronized Class findClass(String name) throws ClassNotFoundException {
        for (int i = 0; i < this.mScouts.length; ++i) {
            try {
                return this.mScouts[i].loadClass(name);
            }
            catch (ClassNotFoundException classNotFoundException) {
                continue;
            }
        }
        throw new ClassNotFoundException(name);
    }

    @Override
    protected URL findResource(String name) {
        URL resource = null;
        try {
            for (int i = 0; i < this.mScouts.length; ++i) {
                resource = this.mScouts[i].getResource(name);
                if (resource == null) continue;
                return resource;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return resource;
    }
}

