/*
 * Decompiled with CFR 0.152.
 */
package org.teatrove.trove.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.teatrove.trove.util.Deflater;

public class DeflaterPool {
    private static final int LIMIT = Integer.getInteger("org.teatrove.trove.util.DeflaterPool.LIMIT", 8);
    private static List cPool;
    private static List cNoWrapPool;

    public static synchronized void clear() {
        Iterator it;
        if (cPool != null) {
            it = cPool.iterator();
            while (it.hasNext()) {
                ((Deflater)it.next()).end();
            }
            cPool = null;
        }
        if (cNoWrapPool != null) {
            it = cNoWrapPool.iterator();
            while (it.hasNext()) {
                ((Deflater)it.next()).end();
            }
            cNoWrapPool = null;
        }
    }

    public static synchronized Deflater get(int level, boolean nowrap) {
        List pool;
        if (nowrap) {
            pool = cNoWrapPool;
            if (pool == null) {
                return new Deflater(level, true);
            }
        } else {
            pool = cPool;
            if (pool == null) {
                return new Deflater(level, false);
            }
        }
        if (pool.isEmpty()) {
            return new Deflater(level, nowrap);
        }
        Deflater d = (Deflater)pool.remove(pool.size() - 1);
        d.setLevel(level);
        d.setStrategy(0);
        return d;
    }

    public static Deflater get(int level) {
        return DeflaterPool.get(level, false);
    }

    public static Deflater get() {
        return DeflaterPool.get(-1, false);
    }

    public static synchronized void put(Deflater d) {
        List<Deflater> pool;
        d.reset();
        if (d.isNoWrap()) {
            pool = cNoWrapPool;
            if (pool == null) {
                pool = cNoWrapPool = new ArrayList<Deflater>(LIMIT);
            }
        } else {
            pool = cPool;
            if (pool == null) {
                cPool = new ArrayList(LIMIT);
                pool = cPool;
            }
        }
        if (pool.size() < LIMIT) {
            pool.add(d);
        } else {
            d.end();
        }
    }
}

