/*
 * Decompiled with CFR 0.152.
 */
package org.teatrove.trove.util;

import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.teatrove.trove.util.DecimalConvertor;
import org.teatrove.trove.util.Pair;
import org.teatrove.trove.util.StringReplacer;

public class DecimalFormat
implements Cloneable {
    private static final String[] INT_VALUES = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23", "24", "25", "26", "27", "28", "29", "30", "31", "32", "33", "34", "35", "36", "37", "38", "39", "40", "41", "42", "43", "44", "45", "46", "47", "48", "49", "50", "51", "52", "53", "54", "55", "56", "57", "58", "59", "60", "61", "62", "63", "64", "65", "66", "67", "68", "69", "70", "71", "72", "73", "74", "75", "76", "77", "78", "79", "80", "81", "82", "83", "84", "85", "86", "87", "88", "89", "90", "91", "92", "93", "94", "95", "96", "97", "98", "99"};
    private static Map cInstanceCache = new HashMap(7);
    private String mPattern;
    private boolean mFormatInteger;
    private String mPrefix;
    private String mSuffix;
    private String mMinusPrefix = "";
    private String mMinusSuffix = "";
    private int mMaxDigits = 20;
    private int mMaxFractDigits;
    private int mRoundMode = 1;
    private int mMinWholeDigits;
    private int mMinFractDigits;
    private int mDecimalScale;
    private int mGroupingWidth;
    private int mExponentDigits;
    private int mExponentMultiple;
    private char mMinusSymbol = (char)45;
    private char mPlusSymbol = (char)65535;
    private char mDecimalSeparator = (char)46;
    private char mGroupingSeparator = (char)44;
    private String mInfinity = "\u221e";
    private String mNaN = "\ufffd";
    private char mZeroDigit = (char)48;
    private char mDigit = (char)35;
    private char mPatternSeparator = (char)59;
    private char mPercent = (char)37;
    private char mPerMill = (char)8240;
    private String mExponentPrefix = "E";

    public static DecimalFormat getInstance() {
        return DecimalFormat.getInstance(null, null, null);
    }

    public static DecimalFormat getInstance(String pattern) throws IllegalArgumentException {
        return DecimalFormat.getInstance(pattern, null, null);
    }

    public static DecimalFormat getInstance(Locale locale) throws IllegalArgumentException {
        return DecimalFormat.getInstance(null, locale, null);
    }

    public static DecimalFormat getInstance(String pattern, Locale locale) throws IllegalArgumentException {
        return DecimalFormat.getInstance(pattern, locale, null);
    }

    public static DecimalFormat getInstance(String pattern, DecimalFormatSymbols symbols) throws IllegalArgumentException {
        return DecimalFormat.getInstance(pattern, null, symbols);
    }

    public static synchronized DecimalFormat getInstance(String pattern, Locale locale, DecimalFormatSymbols symbols) throws IllegalArgumentException {
        DecimalFormat format;
        Object key = pattern;
        if (locale != null) {
            key = new Pair(key, locale);
        }
        if (symbols != null) {
            key = new Pair(key, symbols);
        }
        if ((format = (DecimalFormat)cInstanceCache.get(key)) == null) {
            if (symbols == null) {
                if (locale == null) {
                    locale = Locale.getDefault();
                }
                symbols = new DecimalFormatSymbols(locale);
            }
            if (pattern == null) {
                NumberFormat nf;
                if (locale == null) {
                    locale = Locale.getDefault();
                }
                if ((nf = NumberFormat.getNumberInstance(locale)) instanceof java.text.DecimalFormat) {
                    pattern = ((java.text.DecimalFormat)nf).toPattern();
                } else {
                    pattern = new java.text.DecimalFormat().toPattern();
                    symbols = null;
                }
            }
            format = new DecimalFormat(pattern, symbols);
            cInstanceCache.put(key, format);
        }
        return format;
    }

    private DecimalFormat(String pattern, DecimalFormatSymbols symbols) {
        boolean monetary;
        this.mPattern = pattern;
        boolean bl = monetary = pattern.indexOf(164) >= 0;
        if (symbols != null) {
            this.mMinusSymbol = symbols.getMinusSign();
            this.mDecimalSeparator = monetary ? symbols.getMonetaryDecimalSeparator() : symbols.getDecimalSeparator();
            this.mGroupingSeparator = symbols.getGroupingSeparator();
            this.mInfinity = symbols.getInfinity();
            this.mNaN = symbols.getNaN();
            this.mZeroDigit = symbols.getZeroDigit();
            this.mDigit = symbols.getDigit();
            this.mPatternSeparator = symbols.getPatternSeparator();
            this.mPercent = symbols.getPercent();
            this.mPerMill = symbols.getPerMill();
        }
        this.parsePattern();
        if (monetary) {
            String sym = symbols.getInternationalCurrencySymbol();
            this.mPrefix = StringReplacer.replace(this.mPrefix, "\u00a4\u00a4", sym);
            this.mSuffix = StringReplacer.replace(this.mSuffix, "\u00a4\u00a4", sym);
            this.mMinusPrefix = StringReplacer.replace(this.mMinusPrefix, "\u00a4\u00a4", sym);
            this.mMinusSuffix = StringReplacer.replace(this.mMinusSuffix, "\u00a4\u00a4", sym);
            sym = symbols.getCurrencySymbol();
            this.mPrefix = StringReplacer.replace(this.mPrefix, "\u00a4", sym);
            this.mSuffix = StringReplacer.replace(this.mSuffix, "\u00a4", sym);
            this.mMinusPrefix = StringReplacer.replace(this.mMinusPrefix, "\u00a4", sym);
            this.mMinusSuffix = StringReplacer.replace(this.mMinusSuffix, "\u00a4", sym);
        }
        boolean bl2 = this.mFormatInteger = this.mMinWholeDigits > 1 || this.mMinFractDigits > 0 || this.mDecimalScale != 0 || this.mGroupingWidth > 0 || this.mExponentMultiple > 0 || this.mMinusSymbol != '-' || this.mPlusSymbol != '\uffff' || this.mDecimalSeparator != '.' || this.mZeroDigit != '0';
        if (this.mMinusPrefix.length() == 0) {
            this.mMinusPrefix = null;
        }
        if (this.mMinusSuffix.length() == 0) {
            this.mMinusSuffix = null;
        }
    }

    public String format(float v) {
        return this.format(v, new StringBuffer()).toString();
    }

    public String format(double v) {
        return this.format(v, new StringBuffer()).toString();
    }

    public String format(int v) {
        if (this.mFormatInteger) {
            return this.format(v, new StringBuffer()).toString();
        }
        if (v >= 0 && v < 100) {
            return INT_VALUES[v];
        }
        return Integer.toString(v);
    }

    public String format(long v) {
        if (this.mFormatInteger) {
            return this.format(v, new StringBuffer()).toString();
        }
        if (v >= 0L && v < 100L) {
            return INT_VALUES[(int)v];
        }
        return Long.toString(v);
    }

    public StringBuffer format(float v, StringBuffer buf) {
        char minus;
        char plus;
        String suffix;
        String prefix;
        if (Float.isNaN(v)) {
            return buf.append(this.mNaN);
        }
        if (this.mMinusPrefix != null && DecimalConvertor.isNegative(v)) {
            prefix = this.mMinusPrefix;
            suffix = this.mMinusSuffix;
            plus = '\uffff';
            minus = '\uffff';
        } else {
            prefix = this.mPrefix;
            suffix = this.mSuffix;
            plus = this.mPlusSymbol;
            minus = this.mMinusSymbol;
        }
        buf.append(prefix);
        if (this.mExponentMultiple == 0) {
            DecimalConvertor.format(v, buf, this.mMaxDigits, this.mMaxFractDigits, this.mRoundMode, this.mMinWholeDigits, this.mMinFractDigits, minus, plus, this.mDecimalSeparator, this.mDecimalScale, this.mGroupingSeparator, this.mGroupingWidth, this.mInfinity, this.mNaN);
        } else {
            int exp = DecimalConvertor.formatScientific(v, buf, this.mMaxDigits, this.mExponentMultiple, this.mRoundMode, this.mMinWholeDigits, this.mMinFractDigits, minus, plus, this.mDecimalSeparator, this.mDecimalScale, this.mGroupingSeparator, this.mGroupingWidth, this.mInfinity, this.mNaN);
            if (!Float.isInfinite(v)) {
                this.appendExponent(buf, exp);
            }
        }
        if (this.mZeroDigit != '0') {
            this.replace(buf, prefix.length(), '0', this.mZeroDigit);
        }
        return buf.append(suffix);
    }

    public StringBuffer format(double v, StringBuffer buf) {
        char minus;
        char plus;
        String suffix;
        String prefix;
        if (Double.isNaN(v)) {
            return buf.append(this.mNaN);
        }
        if (this.mMinusPrefix != null && DecimalConvertor.isNegative(v)) {
            prefix = this.mMinusPrefix;
            suffix = this.mMinusSuffix;
            plus = '\uffff';
            minus = '\uffff';
        } else {
            prefix = this.mPrefix;
            suffix = this.mSuffix;
            plus = this.mPlusSymbol;
            minus = this.mMinusSymbol;
        }
        buf.append(prefix);
        if (this.mExponentMultiple == 0) {
            DecimalConvertor.format(v, buf, this.mMaxDigits, this.mMaxFractDigits, this.mRoundMode, this.mMinWholeDigits, this.mMinFractDigits, minus, plus, this.mDecimalSeparator, this.mDecimalScale, this.mGroupingSeparator, this.mGroupingWidth, this.mInfinity, this.mNaN);
        } else {
            int exp = DecimalConvertor.formatScientific(v, buf, this.mMaxDigits, this.mExponentMultiple, this.mRoundMode, this.mMinWholeDigits, this.mMinFractDigits, minus, plus, this.mDecimalSeparator, this.mDecimalScale, this.mGroupingSeparator, this.mGroupingWidth, this.mInfinity, this.mNaN);
            if (!Double.isInfinite(v)) {
                this.appendExponent(buf, exp);
            }
        }
        if (this.mZeroDigit != '0') {
            this.replace(buf, prefix.length(), '0', this.mZeroDigit);
        }
        return buf.append(suffix);
    }

    public StringBuffer format(int v, StringBuffer buf) {
        char minus;
        char plus;
        String suffix;
        String prefix;
        if (!this.mFormatInteger) {
            if (v < 100) {
                if (v >= 0) {
                    return buf.append(INT_VALUES[v]);
                }
                if (v > -100) {
                    return buf.append('-').append(INT_VALUES[-v]);
                }
            }
            return buf.append(v);
        }
        if (this.mMinusPrefix != null && v < 0) {
            prefix = this.mMinusPrefix;
            suffix = this.mMinusSuffix;
            plus = '\uffff';
            minus = '\uffff';
        } else {
            prefix = this.mPrefix;
            suffix = this.mSuffix;
            plus = this.mPlusSymbol;
            minus = this.mMinusSymbol;
        }
        buf.append(prefix);
        if (this.mExponentMultiple == 0) {
            DecimalConvertor.format(v, buf, this.mMaxDigits, this.mMaxFractDigits, this.mRoundMode, this.mMinWholeDigits, this.mMinFractDigits, minus, plus, this.mDecimalSeparator, this.mDecimalScale, this.mGroupingSeparator, this.mGroupingWidth);
        } else {
            int exp = DecimalConvertor.formatScientific(v, buf, this.mMaxDigits, this.mExponentMultiple, this.mRoundMode, this.mMinWholeDigits, this.mMinFractDigits, minus, plus, this.mDecimalSeparator, this.mDecimalScale, this.mGroupingSeparator, this.mGroupingWidth);
            this.appendExponent(buf, exp);
        }
        if (this.mZeroDigit != '0') {
            this.replace(buf, prefix.length(), '0', this.mZeroDigit);
        }
        return buf.append(suffix);
    }

    public StringBuffer format(long v, StringBuffer buf) {
        char minus;
        char plus;
        String suffix;
        String prefix;
        if (!this.mFormatInteger) {
            if (v < 100L) {
                if (v >= 0L) {
                    return buf.append(INT_VALUES[(int)v]);
                }
                if (v > -100L) {
                    return buf.append('-').append(INT_VALUES[-((int)v)]);
                }
            }
            return buf.append(v);
        }
        if (this.mMinusPrefix != null && v < 0L) {
            prefix = this.mMinusPrefix;
            suffix = this.mMinusSuffix;
            plus = '\uffff';
            minus = '\uffff';
        } else {
            prefix = this.mPrefix;
            suffix = this.mSuffix;
            plus = this.mPlusSymbol;
            minus = this.mMinusSymbol;
        }
        buf.append(prefix);
        if (this.mExponentMultiple == 0) {
            DecimalConvertor.format(v, buf, this.mMaxDigits, this.mMaxFractDigits, this.mRoundMode, this.mMinWholeDigits, this.mMinFractDigits, minus, plus, this.mDecimalSeparator, this.mDecimalScale, this.mGroupingSeparator, this.mGroupingWidth);
        } else {
            int exp = DecimalConvertor.formatScientific(v, buf, this.mMaxDigits, this.mExponentMultiple, this.mRoundMode, this.mMinWholeDigits, this.mMinFractDigits, minus, plus, this.mDecimalSeparator, this.mDecimalScale, this.mGroupingSeparator, this.mGroupingWidth);
            this.appendExponent(buf, exp);
        }
        if (this.mZeroDigit != '0') {
            this.replace(buf, prefix.length(), '0', this.mZeroDigit);
        }
        return buf.append(suffix);
    }

    public String getPattern() {
        return this.mPattern;
    }

    public int getMaxDigits() {
        return this.mMaxDigits;
    }

    public int getMaxFractDigits() {
        return this.mMaxFractDigits;
    }

    public int getRoundMode() {
        return this.mRoundMode;
    }

    public int getMinWholeDigits() {
        return this.mMinWholeDigits;
    }

    public int getMinFractDigits() {
        return this.mMinWholeDigits;
    }

    public int getDecimalScale() {
        return this.mDecimalScale;
    }

    public int getGroupingWidth() {
        return this.mGroupingWidth;
    }

    public int getExponentDigits() {
        return this.mExponentDigits;
    }

    public int getExponentMultiple() {
        return this.mExponentMultiple;
    }

    public char getMinusSymbol() {
        return this.mMinusSymbol;
    }

    public char getPlusSymbol() {
        return this.mPlusSymbol;
    }

    public char getDecimalSeparator() {
        return this.mDecimalSeparator;
    }

    public char getGroupingSeparator() {
        return this.mGroupingSeparator;
    }

    public String getInfinity() {
        return this.mInfinity;
    }

    public String getNaN() {
        return this.mNaN;
    }

    public char getZeroDigit() {
        return '0';
    }

    public String getExponentPrefix() {
        return this.mExponentPrefix;
    }

    public DecimalFormat setDecimalSeparator(char c) {
        try {
            DecimalFormat df = (DecimalFormat)this.clone();
            df.mDecimalSeparator = c;
            return df;
        }
        catch (CloneNotSupportedException e) {
            return this;
        }
    }

    public DecimalFormat setGroupingSeparator(char c) {
        try {
            DecimalFormat df = (DecimalFormat)this.clone();
            df.mGroupingSeparator = c;
            return df;
        }
        catch (CloneNotSupportedException e) {
            return this;
        }
    }

    public DecimalFormat setInfinity(String str) {
        try {
            DecimalFormat df = (DecimalFormat)this.clone();
            df.mInfinity = str;
            return df;
        }
        catch (CloneNotSupportedException e) {
            return this;
        }
    }

    public DecimalFormat setNaN(String str) {
        try {
            DecimalFormat df = (DecimalFormat)this.clone();
            df.mNaN = str;
            return df;
        }
        catch (CloneNotSupportedException e) {
            return this;
        }
    }

    public DecimalFormat setExponentPrefix(String str) {
        try {
            DecimalFormat df = (DecimalFormat)this.clone();
            df.mExponentPrefix = str;
            return df;
        }
        catch (CloneNotSupportedException e) {
            return this;
        }
    }

    private void appendExponent(StringBuffer buf, int exp) {
        String str;
        buf.append(this.mExponentPrefix);
        if (exp < 0) {
            buf.append(this.mMinusSymbol);
            exp = -exp;
        }
        String string = str = exp < 100 ? INT_VALUES[exp] : Integer.toString(exp);
        if (this.mExponentDigits > 1) {
            for (int i = str.length(); i < this.mExponentDigits; ++i) {
                buf.append(this.mZeroDigit);
            }
        }
        buf.append(str);
    }

    private void replace(StringBuffer buf, int start, char oldChar, char newChar) {
        int i = buf.length();
        while (--i >= start) {
            if (buf.charAt(i) != oldChar) continue;
            buf.setCharAt(i, newChar);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void parsePattern() {
        int count;
        String pattern = this.mPattern;
        int length = pattern.length();
        int i = 0;
        StringBuffer buf = new StringBuffer();
        i = this.parsePrefixOrSuffix(pattern, i, buf);
        this.mPrefix = new String(buf.toString()).intern();
        buf.setLength(0);
        boolean fract = false;
        boolean groupSeparatorAllowed = false;
        int groupIndex = 0;
        int maxWholeDigits = 0;
        char c = '\u0000';
        while (i < length) {
            if ((c = pattern.charAt(i++)) == '0') {
                if (!fract) {
                    ++this.mMinWholeDigits;
                    ++maxWholeDigits;
                    groupSeparatorAllowed = true;
                    continue;
                }
                if (this.mMaxFractDigits != 0) {
                    this.error();
                }
                ++this.mMinFractDigits;
                continue;
            }
            if (c == '#') {
                if (!fract) {
                    if (this.mMinWholeDigits > 0) {
                        this.error();
                    }
                    ++maxWholeDigits;
                    groupSeparatorAllowed = true;
                    continue;
                }
                if (this.mMaxFractDigits == 0) {
                    this.mMaxFractDigits = this.mMinFractDigits;
                }
                ++this.mMaxFractDigits;
                continue;
            }
            if (c == '.') {
                if (!fract) {
                    fract = true;
                    groupSeparatorAllowed = false;
                } else {
                    this.error("Multiple decimal separators in pattern");
                }
                if (groupIndex == 0) continue;
                this.mGroupingWidth = i - groupIndex - 1;
                if (this.mGroupingWidth == 0) {
                    this.error();
                }
                groupIndex = 0;
                continue;
            }
            if (c == ',') {
                if (!groupSeparatorAllowed) {
                    this.error();
                    continue;
                }
                groupIndex = i;
                continue;
            }
            if (c == 'E') {
                count = this.scanRun(pattern, i, this.mZeroDigit);
                if (count == 0) {
                    --i;
                    break;
                }
                this.mExponentDigits = count;
                if ((i += count) < length) {
                    if ((c = pattern.charAt(i++)) == ';') break;
                    --i;
                    break;
                }
                c = '\u0000';
                break;
            }
            if (c == ';') break;
            --i;
            break;
        }
        if (groupIndex != 0) {
            this.mGroupingWidth = i - groupIndex;
            if (this.mGroupingWidth == 0) {
                this.error();
            }
        }
        if (this.mMaxFractDigits < this.mMinFractDigits) {
            this.mMaxFractDigits = this.mMinFractDigits;
        }
        if (this.mExponentDigits > 0) {
            this.mMaxDigits = this.mMinWholeDigits + this.mMaxFractDigits;
            if (maxWholeDigits > this.mMinWholeDigits && maxWholeDigits > 1) {
                this.mExponentMultiple = maxWholeDigits;
                this.mMinWholeDigits = 1;
            } else {
                this.mExponentMultiple = 1;
            }
        }
        if (c != this.mPatternSeparator) {
            i = this.parsePrefixOrSuffix(pattern, i, buf);
            this.mSuffix = new String(buf.toString()).intern();
            buf.setLength(0);
            if (i >= length) return;
            if (pattern.charAt(i) != ';') {
                this.error();
            } else {
                ++i;
            }
        } else {
            this.mSuffix = "";
        }
        i = this.parsePrefixOrSuffix(pattern, i, buf);
        this.mMinusPrefix = new String(buf.toString()).intern();
        buf.setLength(0);
        while (i < length) {
            if ((c = pattern.charAt(i++)) == this.mZeroDigit || c == this.mDigit || c == this.mDecimalSeparator || c == this.mGroupingSeparator) continue;
            if (c == 'E') {
                count = this.scanRun(pattern, i, this.mZeroDigit);
                if (count == 0) {
                    --i;
                    break;
                }
                i += count;
                break;
            }
            --i;
            break;
        }
        i = this.parsePrefixOrSuffix(pattern, i, buf);
        this.mMinusSuffix = new String(buf.toString()).intern();
        if (i >= length) return;
        this.error();
    }

    private int parsePrefixOrSuffix(String pattern, int i, StringBuffer buf) {
        int length = pattern.length();
        int inQuote = 0;
        while (i < length) {
            char c = pattern.charAt(i++);
            if (inQuote != 0) {
                if (c == '\'') {
                    if (inQuote == 1) {
                        buf.append('\'');
                    }
                    inQuote = 0;
                    continue;
                }
                buf.append(c);
                ++inQuote;
                continue;
            }
            if (c == '\'') {
                inQuote = 1;
                continue;
            }
            if (c == this.mZeroDigit || c == this.mDigit || c == this.mDecimalSeparator || c == this.mGroupingSeparator || c == this.mPatternSeparator || c == '\ufffe' || c == '\uffff') {
                --i;
                break;
            }
            if (c == this.mPercent) {
                if (this.mDecimalScale == 3) {
                    this.error("Cannot combine percent and permill characters in pattern");
                }
                this.mDecimalScale = 2;
                buf.append(c);
                continue;
            }
            if (c == this.mPerMill) {
                if (this.mDecimalScale == 2) {
                    this.error("Cannot combine percent and permill characters in pattern");
                }
                this.mDecimalScale = 3;
                buf.append(c);
                continue;
            }
            buf.append(c);
        }
        if (inQuote != 0) {
            this.error();
        }
        return i;
    }

    private int scanRun(String pattern, int i, char c) {
        int count = 0;
        int length = pattern.length();
        while (i < length && pattern.charAt(i) == c) {
            ++count;
            ++i;
        }
        return count;
    }

    private void error() {
        this.error("Malformed pattern");
    }

    private void error(String message) {
        throw new IllegalArgumentException(message + " \"" + this.mPattern + '\"');
    }
}

