/*
 * Decompiled with CFR 0.152.
 */
package org.teatrove.trove.util;

public class DecimalConvertor {
    public static final int ROUND_HALF_UP = 0;
    public static final int ROUND_HALF_UP_DECIMAL = 1;
    static final int[] I_TENTH_POWERS = new int[10];
    static final long[] L_TENTH_POWERS;

    public static void format(float v, StringBuffer buf) {
        DecimalConvertor.format(v, buf, 10, 100, 0, 1, 1, '-', '\uffff', '.', 0, ',', 0, "Infinity", "NaN");
    }

    public static void format(double v, StringBuffer buf) {
        DecimalConvertor.format(v, buf, 20, 100, 0, 1, 1, '-', '\uffff', '.', 0, ',', 0, "Infinity", "NaN");
    }

    public static void format(float v, StringBuffer buf, int maxDigits, int maxFractDigits, int roundMode, int minWholeDigits, int minFractDigits, char minusSymbol, char plusSymbol, char decimalSeparator, int decimalScale, char groupingSeparator, int groupingWidth, String infinity, String nan) {
        if (DecimalConvertor.formatSpecials(v, buf, minWholeDigits, minFractDigits, minusSymbol, plusSymbol, decimalSeparator, infinity, nan)) {
            return;
        }
        char[] digits = new char[Math.min(10, maxDigits) + 1];
        int result = DecimalConvertor.toDecimalDigits(v, digits, 0, maxDigits, maxFractDigits += decimalScale, roundMode);
        if ((result & 0xFFFF) == 0) {
            DecimalConvertor.formatSpecials(0, buf, minWholeDigits, minFractDigits, minusSymbol, plusSymbol, decimalSeparator);
            return;
        }
        DecimalConvertor.formatResult(digits, result, buf, maxFractDigits, minWholeDigits, minFractDigits, decimalSeparator, decimalScale, groupingSeparator, groupingWidth);
    }

    public static void format(double v, StringBuffer buf, int maxDigits, int maxFractDigits, int roundMode, int minWholeDigits, int minFractDigits, char minusSymbol, char plusSymbol, char decimalSeparator, int decimalScale, char groupingSeparator, int groupingWidth, String infinity, String nan) {
        if (DecimalConvertor.formatSpecials(v, buf, minWholeDigits, minFractDigits, minusSymbol, plusSymbol, decimalSeparator, infinity, nan)) {
            return;
        }
        char[] digits = new char[Math.min(20, maxDigits) + 1];
        int result = DecimalConvertor.toDecimalDigits(v, digits, 0, maxDigits, maxFractDigits += decimalScale, roundMode);
        if ((result & 0xFFFF) == 0) {
            DecimalConvertor.formatSpecials(0, buf, minWholeDigits, minFractDigits, minusSymbol, plusSymbol, decimalSeparator);
            return;
        }
        DecimalConvertor.formatResult(digits, result, buf, maxFractDigits, minWholeDigits, minFractDigits, decimalSeparator, decimalScale, groupingSeparator, groupingWidth);
    }

    public static void format(int v, StringBuffer buf, int maxDigits, int maxFractDigits, int roundMode, int minWholeDigits, int minFractDigits, char minusSymbol, char plusSymbol, char decimalSeparator, int decimalScale, char groupingSeparator, int groupingWidth) {
        char[] digits;
        int result;
        if (DecimalConvertor.formatSpecials(v, buf, minWholeDigits, minFractDigits, minusSymbol, plusSymbol, decimalSeparator)) {
            return;
        }
        if (v < 0) {
            v = -v;
        }
        if (((result = DecimalConvertor.toDecimalDigits((long)v & 0xFFFFFFFFL, 32, 32, digits = new char[Math.min(10, maxDigits) + 1], 0, maxDigits, maxFractDigits += decimalScale, roundMode)) & 0xFFFF) == 0) {
            DecimalConvertor.formatSpecials(0, buf, minWholeDigits, minFractDigits, minusSymbol, plusSymbol, decimalSeparator);
            return;
        }
        DecimalConvertor.formatResult(digits, result, buf, maxFractDigits, minWholeDigits, minFractDigits, decimalSeparator, decimalScale, groupingSeparator, groupingWidth);
    }

    public static void format(long v, StringBuffer buf, int maxDigits, int maxFractDigits, int roundMode, int minWholeDigits, int minFractDigits, char minusSymbol, char plusSymbol, char decimalSeparator, int decimalScale, char groupingSeparator, int groupingWidth) {
        if (v == (long)((int)v)) {
            DecimalConvertor.format((int)v, buf, maxDigits, maxFractDigits, roundMode, minWholeDigits, minFractDigits, minusSymbol, plusSymbol, decimalSeparator, decimalScale, groupingSeparator, groupingWidth);
            return;
        }
        if (DecimalConvertor.formatSpecials(v, buf, minWholeDigits, minFractDigits, minusSymbol, plusSymbol, decimalSeparator)) {
            return;
        }
        if (v < 0L) {
            v = -v;
        }
        char[] digits = new char[Math.min(20, maxDigits) + 1];
        LargeUInt largev = new LargeUInt();
        largev.setValue(v);
        int result = DecimalConvertor.toDecimalDigits(largev, 64, 64, digits, 0, maxDigits, maxFractDigits += decimalScale, roundMode);
        if ((result & 0xFFFF) == 0) {
            DecimalConvertor.formatSpecials(0, buf, minWholeDigits, minFractDigits, minusSymbol, plusSymbol, decimalSeparator);
            return;
        }
        DecimalConvertor.formatResult(digits, result, buf, maxFractDigits, minWholeDigits, minFractDigits, decimalSeparator, decimalScale, groupingSeparator, groupingWidth);
    }

    public static int formatScientific(float v, StringBuffer buf, int maxDigits, int exponentMultiple, int roundMode, int minWholeDigits, int minFractDigits, char minusSymbol, char plusSymbol, char decimalSeparator, int decimalScale, char groupingSeparator, int groupingWidth, String infinity, String nan) {
        if (DecimalConvertor.formatSpecials(v, buf, minWholeDigits, minFractDigits, minusSymbol, plusSymbol, decimalSeparator, infinity, nan)) {
            return 0;
        }
        char[] digits = new char[Math.min(10, maxDigits) + 1];
        int result = DecimalConvertor.toDecimalDigits(v, digits, 0, maxDigits, 100, roundMode);
        return DecimalConvertor.formatScientificResult(digits, result, buf, exponentMultiple, minWholeDigits, minFractDigits, decimalSeparator, decimalScale, groupingSeparator, groupingWidth);
    }

    public static int formatScientific(double v, StringBuffer buf, int maxDigits, int exponentMultiple, int roundMode, int minWholeDigits, int minFractDigits, char minusSymbol, char plusSymbol, char decimalSeparator, int decimalScale, char groupingSeparator, int groupingWidth, String infinity, String nan) {
        if (DecimalConvertor.formatSpecials(v, buf, minWholeDigits, minFractDigits, minusSymbol, plusSymbol, decimalSeparator, infinity, nan)) {
            return 0;
        }
        char[] digits = new char[Math.min(20, maxDigits) + 1];
        int result = DecimalConvertor.toDecimalDigits(v, digits, 0, maxDigits, 100, roundMode);
        return DecimalConvertor.formatScientificResult(digits, result, buf, exponentMultiple, minWholeDigits, minFractDigits, decimalSeparator, decimalScale, groupingSeparator, groupingWidth);
    }

    public static int formatScientific(int v, StringBuffer buf, int maxDigits, int exponentMultiple, int roundMode, int minWholeDigits, int minFractDigits, char minusSymbol, char plusSymbol, char decimalSeparator, int decimalScale, char groupingSeparator, int groupingWidth) {
        if (DecimalConvertor.formatSpecials(v, buf, minWholeDigits, minFractDigits, minusSymbol, plusSymbol, decimalSeparator)) {
            return 0;
        }
        if (v < 0) {
            v = -v;
        }
        char[] digits = new char[Math.min(10, maxDigits) + 1];
        int result = DecimalConvertor.toDecimalDigits((long)v & 0xFFFFFFFFL, 32, 32, digits, 0, maxDigits, 100, roundMode);
        return DecimalConvertor.formatScientificResult(digits, result, buf, exponentMultiple, minWholeDigits, minFractDigits, decimalSeparator, decimalScale, groupingSeparator, groupingWidth);
    }

    public static int formatScientific(long v, StringBuffer buf, int maxDigits, int exponentMultiple, int roundMode, int minWholeDigits, int minFractDigits, char minusSymbol, char plusSymbol, char decimalSeparator, int decimalScale, char groupingSeparator, int groupingWidth) {
        if (v == (long)((int)v)) {
            return DecimalConvertor.formatScientific((int)v, buf, maxDigits, exponentMultiple, roundMode, minWholeDigits, minFractDigits, minusSymbol, plusSymbol, decimalSeparator, decimalScale, groupingSeparator, groupingWidth);
        }
        if (DecimalConvertor.formatSpecials(v, buf, minWholeDigits, minFractDigits, minusSymbol, plusSymbol, decimalSeparator)) {
            return 0;
        }
        if (v < 0L) {
            v = -v;
        }
        char[] digits = new char[Math.min(20, maxDigits) + 1];
        LargeUInt largev = new LargeUInt();
        largev.setValue(v);
        int result = DecimalConvertor.toDecimalDigits(largev, 64, 64, digits, 0, maxDigits, 100, roundMode);
        return DecimalConvertor.formatScientificResult(digits, result, buf, exponentMultiple, minWholeDigits, minFractDigits, decimalSeparator, decimalScale, groupingSeparator, groupingWidth);
    }

    private static boolean formatSpecials(float v, StringBuffer buf, int minWholeDigits, int minFractDigits, char minusSymbol, char plusSymbol, char decimalSeparator, String infinity, String nan) {
        if (Float.isNaN(v)) {
            buf.append(nan);
            return true;
        }
        if (DecimalConvertor.isNegative(v)) {
            if (minusSymbol != '\uffff') {
                buf.append(minusSymbol);
            }
        } else if (plusSymbol != '\uffff') {
            buf.append(plusSymbol);
        }
        if (Float.isInfinite(v)) {
            buf.append(infinity);
            return true;
        }
        if (v == 0.0f) {
            int i;
            if (minWholeDigits <= 0 && minFractDigits <= 0) {
                buf.append('0');
                return true;
            }
            for (i = 0; i < minWholeDigits; ++i) {
                buf.append('0');
            }
            if (minFractDigits > 0) {
                buf.append(decimalSeparator);
                for (i = 0; i < minFractDigits; ++i) {
                    buf.append('0');
                }
            }
            return true;
        }
        return false;
    }

    private static boolean formatSpecials(double v, StringBuffer buf, int minWholeDigits, int minFractDigits, char minusSymbol, char plusSymbol, char decimalSeparator, String infinity, String nan) {
        if (Double.isNaN(v)) {
            buf.append(nan);
            return true;
        }
        if (DecimalConvertor.isNegative(v)) {
            if (minusSymbol != '\uffff') {
                buf.append(minusSymbol);
            }
        } else if (plusSymbol != '\uffff') {
            buf.append(plusSymbol);
        }
        if (Double.isInfinite(v)) {
            buf.append(infinity);
            return true;
        }
        if (v == 0.0) {
            int i;
            if (minWholeDigits <= 0 && minFractDigits <= 0) {
                buf.append('0');
                return true;
            }
            for (i = 0; i < minWholeDigits; ++i) {
                buf.append('0');
            }
            if (minFractDigits > 0) {
                buf.append(decimalSeparator);
                for (i = 0; i < minFractDigits; ++i) {
                    buf.append('0');
                }
            }
            return true;
        }
        return false;
    }

    private static boolean formatSpecials(int v, StringBuffer buf, int minWholeDigits, int minFractDigits, char minusSymbol, char plusSymbol, char decimalSeparator) {
        if (v < 0) {
            if (minusSymbol != '\uffff') {
                buf.append(minusSymbol);
            }
        } else if (plusSymbol != '\uffff') {
            buf.append(plusSymbol);
        }
        if (v == 0) {
            int i;
            if (minWholeDigits <= 0 && minFractDigits <= 0) {
                buf.append('0');
                return true;
            }
            for (i = 0; i < minWholeDigits; ++i) {
                buf.append('0');
            }
            if (minFractDigits > 0) {
                buf.append(decimalSeparator);
                for (i = 0; i < minFractDigits; ++i) {
                    buf.append('0');
                }
            }
            return true;
        }
        return false;
    }

    private static boolean formatSpecials(long v, StringBuffer buf, int minWholeDigits, int minFractDigits, char minusSymbol, char plusSymbol, char decimalSeparator) {
        if (v < 0L) {
            if (minusSymbol != '\uffff') {
                buf.append(minusSymbol);
            }
        } else if (plusSymbol != '\uffff') {
            buf.append(plusSymbol);
        }
        if (v == 0L) {
            int i;
            if (minWholeDigits <= 0 && minFractDigits <= 0) {
                buf.append('0');
                return true;
            }
            for (i = 0; i < minWholeDigits; ++i) {
                buf.append('0');
            }
            if (minFractDigits > 0) {
                buf.append(decimalSeparator);
                for (i = 0; i < minFractDigits; ++i) {
                    buf.append('0');
                }
            }
            return true;
        }
        return false;
    }

    private static void formatResult(char[] digits, int result, StringBuffer buf, int maxFractDigits, int minWholeDigits, int minFractDigits, char decimalSeparator, int decimalScale, char groupingSeparator, int groupingWidth) {
        block19: {
            int fractDigits;
            int i;
            int fractOffset;
            int decimal;
            int ndigits;
            block18: {
                for (ndigits = result & 0xFFFF; ndigits > 0 && digits[ndigits - 1] == '0'; --ndigits) {
                }
                decimal = (result >> 16) + decimalScale;
                int wholeDigits = decimal <= 0 ? 0 : decimal;
                fractOffset = 0;
                int wholeCounter = Math.max(wholeDigits, minWholeDigits);
                int wcs = wholeCounter - 1;
                if (wholeCounter <= 1 || groupingSeparator == '\uffff') {
                    groupingWidth = 0;
                }
                for (int i2 = wholeDigits; i2 < minWholeDigits; ++i2) {
                    if (groupingWidth != 0 && wholeCounter-- % groupingWidth == 0 && wholeCounter != wcs) {
                        buf.append(groupingSeparator);
                    }
                    buf.append('0');
                }
                if (wholeDigits > 0) {
                    int amt = Math.min(wholeDigits, ndigits);
                    fractOffset += amt;
                    if (groupingWidth == 0) {
                        buf.append(digits, 0, amt);
                        for (i = amt; i < wholeDigits; ++i) {
                            buf.append('0');
                        }
                    } else {
                        for (i = 0; i < amt; ++i) {
                            if (wholeCounter-- % groupingWidth == 0 && wholeCounter != wcs) {
                                buf.append(groupingSeparator);
                            }
                            buf.append(digits[i]);
                        }
                        for (i = amt; i < wholeDigits; ++i) {
                            if (wholeCounter-- % groupingWidth == 0) {
                                buf.append(groupingSeparator);
                            }
                            buf.append('0');
                        }
                    }
                }
                if ((fractDigits = ndigits - decimal) < 0) {
                    fractDigits = 0;
                }
                if (fractOffset < ndigits) break block18;
                if (minFractDigits <= 0) break block19;
                buf.append(decimalSeparator);
                for (i = 0; i < minFractDigits; ++i) {
                    buf.append('0');
                }
                break block19;
            }
            if (fractDigits > 0 || minFractDigits > 0) {
                buf.append(decimalSeparator);
                i = decimal;
                while (i++ < 0) {
                    buf.append('0');
                }
                if (fractOffset < ndigits) {
                    buf.append(digits, fractOffset, ndigits - fractOffset);
                }
                for (i = fractDigits; i < minFractDigits; ++i) {
                    buf.append('0');
                }
            }
        }
    }

    private static int formatScientificResult(char[] digits, int result, StringBuffer buf, int exponentMultiple, int minWholeDigits, int minFractDigits, char decimalSeparator, int decimalScale, char groupingSeparator, int groupingWidth) {
        int k = result >> 16;
        if (decimalScale != 0) {
            result = (k += decimalScale) << 16 | result & 0xFFFF;
        }
        int exponent = k - 1;
        decimalScale = -exponent;
        if (exponentMultiple > 1) {
            int rem = exponent % exponentMultiple;
            if (rem < 0) {
                rem += exponentMultiple;
            }
            exponent -= rem;
            decimalScale += rem;
        } else if (minWholeDigits > 1) {
            exponent -= minWholeDigits - 1;
            decimalScale += minWholeDigits - 1;
        }
        DecimalConvertor.formatResult(digits, result, buf, 100, minWholeDigits, minFractDigits, decimalSeparator, decimalScale, groupingSeparator, groupingWidth);
        return exponent;
    }

    public static int toDecimalDigits(float v, char[] digits, int offset, int maxDigits, int maxFractDigits, int roundMode) {
        int bits = Float.floatToIntBits(v);
        int f = bits & 0x7FFFFF;
        int e = bits >> 23 & 0xFF;
        if (e != 0) {
            return DecimalConvertor.toDecimalDigits(f + 0x800000, e - 126, 24, digits, offset, maxDigits, maxFractDigits, roundMode);
        }
        return DecimalConvertor.toDecimalDigits(f, -125, 23, digits, offset, maxDigits, maxFractDigits, roundMode);
    }

    public static int toDecimalDigits(double v, char[] digits, int offset, int maxDigits, int maxFractDigits, int roundMode) {
        long bits = Double.doubleToLongBits(v);
        long f = bits & 0xFFFFFFFFFFFFFL;
        int e = (int)(bits >> 52 & 0x7FFL);
        if (e != 0) {
            return DecimalConvertor.toDecimalDigits(f + 0x10000000000000L, e - 1022, 53, digits, offset, maxDigits, maxFractDigits, roundMode);
        }
        return DecimalConvertor.toDecimalDigits(f, -1023, 52, digits, offset, maxDigits, maxFractDigits, roundMode);
    }

    public static int toDecimalDigits(int f, int e, int p, char[] digits, int offset, int maxDigits, int maxFractDigits, int roundMode) {
        int cursor;
        int limit;
        int k;
        block22: {
            int temp;
            if (f == 0 || maxDigits == 0) {
                return 0;
            }
            if (p > 24 || e > 25 || p - e > 26) {
                if (p > 56 || e > 56 || p - e > 58) {
                    LargeUInt largef = new LargeUInt();
                    largef.setValue(f);
                    return DecimalConvertor.toDecimalDigits(largef, e, p, digits, offset, maxDigits, maxFractDigits, roundMode);
                }
                return DecimalConvertor.toDecimalDigits((long)f, e, p, digits, offset, maxDigits, maxFractDigits, roundMode);
            }
            int S = 1;
            int R = f;
            int mlo = 1;
            if (p > e) {
                S <<= p - e;
            } else {
                R <<= e - p;
                mlo <<= e - p;
            }
            int mhi = mlo;
            if (f == 1 << p - 1) {
                mhi <<= 1;
                R <<= 1;
                S <<= 1;
            }
            k = 0;
            limit = (S + 9) / 10;
            while (R < limit) {
                --k;
                R *= 10;
            }
            if (k < 0) {
                if (mlo == mhi) {
                    mlo = mhi *= I_TENTH_POWERS[-k];
                } else {
                    mlo *= I_TENTH_POWERS[-k];
                    mhi *= I_TENTH_POWERS[-k];
                }
            }
            cursor = offset;
            limit = (R << 1) + mhi;
            int S2 = S << 1;
            while (S2 <= limit) {
                S2 = (S *= 10) << 1;
                ++k;
            }
            limit = k + maxFractDigits;
            limit = limit > maxDigits ? offset + maxDigits : (limit += offset);
            if (limit <= offset) {
                if (limit == offset && R << 1 >= S) {
                    digits[cursor++] = 49;
                    ++k;
                }
                return k << 16 | cursor - offset;
            }
            if (roundMode == 1) {
                ++limit;
            }
            do {
                temp = R * 10;
                digits[cursor++] = (char)(temp / S + 48);
                R = temp % S;
                if (mlo == mhi) {
                    mlo = mhi *= 10;
                } else {
                    mlo *= 10;
                    mhi *= 10;
                }
                temp = R << 1;
                if (temp < mlo) {
                    if (temp > S2 - mhi && temp >= S) {
                        k += DecimalConvertor.increment(digits, offset, cursor);
                    }
                } else {
                    if (temp <= S2 - mhi) continue;
                    k += DecimalConvertor.increment(digits, offset, cursor);
                }
                break block22;
            } while (cursor < limit);
            if (roundMode != 1 && temp >= S) {
                k += DecimalConvertor.increment(digits, offset, cursor);
            }
        }
        if (cursor >= limit && roundMode == 1 && digits[--cursor] >= '5') {
            k += DecimalConvertor.increment(digits, offset, cursor);
        }
        return k << 16 | cursor - offset;
    }

    public static int toDecimalDigits(long f, int e, int p, char[] digits, int offset, int maxDigits, int maxFractDigits, int roundMode) {
        int ilimit;
        int cursor;
        int k;
        block21: {
            long temp;
            if (f == 0L || maxDigits == 0) {
                return 0;
            }
            if (p > 56 || e > 56 || p - e > 58) {
                LargeUInt largef = new LargeUInt();
                largef.setValue(f);
                return DecimalConvertor.toDecimalDigits(largef, e, p, digits, offset, maxDigits, maxFractDigits, roundMode);
            }
            long S = 1L;
            long R = f;
            long mlo = 1L;
            if (p > e) {
                S <<= p - e;
            } else {
                R <<= e - p;
                mlo <<= e - p;
            }
            long mhi = mlo;
            if (f == 1L << p - 1) {
                mhi <<= 1;
                R <<= 1;
                S <<= 1;
            }
            k = 0;
            long limit = (S + 9L) / 10L;
            while (R < limit) {
                --k;
                R *= 10L;
            }
            if (k < 0) {
                if (mlo == mhi) {
                    mlo = mhi *= L_TENTH_POWERS[-k];
                } else {
                    mlo *= L_TENTH_POWERS[-k];
                    mhi *= L_TENTH_POWERS[-k];
                }
            }
            limit = (R << 1) + mhi;
            long S2 = S << 1;
            while (S2 <= limit) {
                S2 = (S *= 10L) << 1;
                ++k;
            }
            cursor = offset;
            ilimit = k + maxFractDigits;
            ilimit = ilimit > maxDigits ? offset + maxDigits : (ilimit += offset);
            if (ilimit <= offset) {
                if (ilimit == offset && R << 1 >= S) {
                    digits[cursor++] = 49;
                    ++k;
                }
                return k << 16 | cursor - offset;
            }
            if (roundMode == 1) {
                ++ilimit;
            }
            do {
                temp = R * 10L;
                digits[cursor++] = (char)(temp / S + 48L);
                R = temp % S;
                if (mlo == mhi) {
                    mlo = mhi *= 10L;
                } else {
                    mlo *= 10L;
                    mhi *= 10L;
                }
                temp = R << 1;
                if (temp < mlo) {
                    if (temp > S2 - mhi && temp >= S) {
                        k += DecimalConvertor.increment(digits, offset, cursor);
                    }
                } else {
                    if (temp <= S2 - mhi) continue;
                    k += DecimalConvertor.increment(digits, offset, cursor);
                }
                break block21;
            } while (cursor < ilimit);
            if (roundMode != 1 && temp >= S) {
                k += DecimalConvertor.increment(digits, offset, cursor);
            }
        }
        if (cursor >= ilimit && roundMode == 1 && digits[--cursor] >= '5') {
            k += DecimalConvertor.increment(digits, offset, cursor);
        }
        return k << 16 | cursor - offset;
    }

    public static int toDecimalDigits(LargeUInt f, int e, int p, char[] digits, int offset, int maxDigits, int maxFractDigits, int roundMode) {
        int limit;
        int cursor;
        int k;
        block21: {
            if (f.isZero() || maxDigits == 0) {
                return 0;
            }
            LargeUInt S = new LargeUInt();
            S.setValue(1);
            LargeUInt R = new LargeUInt(f);
            LargeUInt mlo = new LargeUInt();
            mlo.setValue(1);
            if (p > e) {
                S.shiftLeft(p - e);
            } else {
                R.shiftLeft(e - p);
                mlo.shiftLeft(e - p);
            }
            LargeUInt mhi = mlo;
            LargeUInt temp = new LargeUInt();
            temp.setValue(1);
            temp.shiftLeft(p - 1);
            if (f.compare(temp) == 0) {
                R.shiftLeft(1);
                S.shiftLeft(1);
                mhi = null;
            }
            k = 0;
            temp.setValue(S);
            temp.add(9L);
            temp.divideByTen();
            while (R.compare(temp) < 0) {
                --k;
                R.multiplyByTen();
            }
            if (k < 0) {
                mlo.multiplyByTenthPower(-k);
            }
            if (mhi == null) {
                mhi = new LargeUInt(mlo);
                mhi.shiftLeft(1);
            }
            temp.setValue(R);
            temp.shiftLeft(1);
            temp.add(mhi);
            LargeUInt S2 = new LargeUInt(S);
            S2.shiftLeft(1);
            int oldK = k;
            while (S2.compare(temp) < 0) {
                S2.multiplyByTen();
                ++k;
            }
            if (k > oldK) {
                S.multiplyByTenthPower(k - oldK);
            }
            cursor = offset;
            limit = k + maxFractDigits;
            limit = limit > maxDigits ? offset + maxDigits : (limit += offset);
            if (limit <= offset) {
                if (limit == offset) {
                    temp.setValue(R);
                    temp.shiftLeft(1);
                    if (temp.compare(S) >= 0) {
                        digits[cursor++] = 49;
                        ++k;
                    }
                }
                return k << 16 | cursor - offset;
            }
            if (roundMode == 1) {
                ++limit;
            }
            LargeUInt temp2 = f;
            do {
                R.multiplyByTen();
                digits[cursor++] = (char)(R.divideClose(S) + 48);
                if (mlo == mhi) {
                    mlo.multiplyByTen();
                } else {
                    mlo.multiplyByTen();
                    mhi.multiplyByTen();
                }
                temp.setValue(R);
                temp.shiftLeft(1);
                temp2.setValue(S2);
                temp2.subtract(mhi);
                if (temp.compare(mlo) < 0) {
                    if (temp.compare(temp2) > 0 && temp.compare(S) >= 0) {
                        k += DecimalConvertor.increment(digits, offset, cursor);
                    }
                } else {
                    if (temp.compare(temp2) <= 0) continue;
                    k += DecimalConvertor.increment(digits, offset, cursor);
                }
                break block21;
            } while (cursor < limit);
            if (roundMode != 1 && temp.compare(S) >= 0) {
                k += DecimalConvertor.increment(digits, offset, cursor);
            }
        }
        if (cursor >= limit && roundMode == 1 && digits[--cursor] >= '5') {
            k += DecimalConvertor.increment(digits, offset, cursor);
        }
        return k << 16 | cursor - offset;
    }

    private static int increment(char[] digits, int offset, int cursor) {
        while (true) {
            char c;
            if ((c = digits[--cursor]) != '9') {
                digits[cursor] = (char)(c + '\u0001');
                return 0;
            }
            if (cursor == offset) {
                digits[cursor] = 49;
                return 1;
            }
            digits[cursor] = 48;
        }
    }

    public static boolean isNegative(float v) {
        return v < 0.0f || v == 0.0f && 1.0f / v < 0.0f;
    }

    public static boolean isNegative(double v) {
        return v < 0.0 || v == 0.0 && 1.0 / v < 0.0;
    }

    static {
        int v = 1;
        for (int i = 0; i < 10; ++i) {
            DecimalConvertor.I_TENTH_POWERS[i] = v;
            v *= 10;
        }
        L_TENTH_POWERS = new long[19];
        long v2 = 1L;
        for (int i = 0; i < 19; ++i) {
            DecimalConvertor.L_TENTH_POWERS[i] = v2;
            v2 *= 10L;
        }
    }

    public static final class LargeUInt {
        private int[] mDigits;
        private int mLength;

        public LargeUInt() {
            this.mDigits = new int[8];
            this.mLength = 1;
        }

        public LargeUInt(int initialCapacity) {
            if (initialCapacity < 1) {
                throw new IllegalArgumentException();
            }
            this.mDigits = new int[initialCapacity];
            this.mLength = 1;
        }

        public LargeUInt(LargeUInt v) {
            int[] vdigits = v.mDigits;
            int[] digits = new int[vdigits.length];
            int i = this.mLength = v.mLength;
            while (--i >= 0) {
                digits[i] = vdigits[i];
            }
            this.mDigits = digits;
        }

        public void setZero() {
            int[] digits = this.mDigits;
            int length = this.mLength;
            for (int i = 0; i < length; ++i) {
                digits[i] = 0;
            }
            this.mLength = 1;
        }

        public void setValue(int v) {
            int[] digits = this.mDigits;
            int length = this.mLength;
            digits[0] = v;
            for (int i = 1; i < length; ++i) {
                digits[i] = 0;
            }
            this.mLength = 1;
        }

        public void setValue(long v) {
            if ((v & 0xFFFFFFFF00000000L) == 0L) {
                this.setValue((int)v);
                return;
            }
            int[] digits = this.mDigits;
            int length = this.mLength;
            digits[0] = (int)v;
            if (length < 2) {
                this.expand((int)(2 - length))[1] = (int)(v >> 32);
            } else {
                digits[1] = (int)(v >> 32);
                for (int i = 2; i < length; ++i) {
                    digits[i] = 0;
                }
            }
        }

        public void setValue(LargeUInt v) {
            int vlength = v.mLength;
            int[] digits = this.mDigits;
            if (vlength > digits.length) {
                this.mDigits = (int[])v.mDigits.clone();
            } else {
                System.arraycopy(v.mDigits, 0, digits, 0, vlength);
            }
            this.mLength = vlength;
        }

        public void add(long v) {
            int[] digits = this.mDigits;
            int length = this.mLength;
            for (int i = 0; i < length; ++i) {
                digits[i] = (int)(v += (long)digits[i] & 0xFFFFFFFFL);
                if (v < 0x100000000L) {
                    return;
                }
                v = 1L;
            }
            this.expand((int)1)[i] = 1;
        }

        public void add(LargeUInt v) {
            int[] digits = this.mDigits;
            int[] vdigits = v.mDigits;
            int length = this.mLength;
            int vlength = v.mLength;
            if (length < vlength) {
                digits = this.expand(vlength - length);
                length = vlength;
            }
            long c = 0L;
            int j = 0;
            for (int i = 0; i < length; ++i) {
                c += (long)digits[i] & 0xFFFFFFFFL;
                if (j < vlength) {
                    c += (long)vdigits[j++] & 0xFFFFFFFFL;
                }
                digits[i] = (int)c;
                if (c < 0x100000000L) {
                    if (j >= vlength) {
                        return;
                    }
                    c = 0L;
                    continue;
                }
                c = 1L;
            }
            if (c != 0L) {
                this.expand((int)1)[i] = 1;
            }
        }

        public int subtract(long v) {
            int[] digits = this.mDigits;
            int length = this.mLength;
            for (int i = 0; i < length; ++i) {
                v = ((long)digits[i] & 0xFFFFFFFFL) - v;
                digits[i] = (int)v;
                if (v >= 0L) {
                    this.shrinkLength();
                    return 0;
                }
                v = 1L;
            }
            return 1;
        }

        public int subtract(LargeUInt v) {
            int[] digits = this.mDigits;
            int[] vdigits = v.mDigits;
            int length = this.mLength;
            int vlength = v.mLength;
            if (length < vlength) {
                digits = this.expand(vlength - length);
                length = vlength;
            }
            long c = 0L;
            int j = 0;
            for (int i = 0; i < length; ++i) {
                c = ((long)digits[i] & 0xFFFFFFFFL) - c;
                if (j < vlength) {
                    c -= (long)vdigits[j++] & 0xFFFFFFFFL;
                }
                digits[i] = (int)c;
                if (c >= 0L) {
                    if (j >= vlength) {
                        this.shrinkLength();
                        return 0;
                    }
                    c = 0L;
                    continue;
                }
                c = 1L;
            }
            return (int)c;
        }

        public void shiftLeft(int v) {
            int length;
            int[] digits;
            if (v <= 31) {
                digits = this.mDigits;
                length = this.mLength;
            } else {
                int coarse = v >>> 5;
                digits = this.expand(coarse);
                length = this.mLength;
                int i = length - 1;
                while (i >= 0) {
                    int k = i - coarse;
                    if (k >= 0) {
                        digits[i--] = digits[k];
                        continue;
                    }
                    while (i >= 0) {
                        digits[i--] = 0;
                    }
                    break block0;
                }
                v &= 0x1F;
            }
            if (v == 0) {
                return;
            }
            long p = 0L;
            for (int i = 0; i < length; ++i) {
                digits[i] = (int)(p += ((long)digits[i] & 0xFFFFFFFFL) << v);
                p >>>= 32;
            }
            if (p != 0L) {
                this.expand((int)1)[this.mLength - 1] = (int)p;
            }
        }

        public void multiply(long v) {
            if (v == 0L) {
                this.setZero();
                return;
            }
            if (v == 1L) {
                return;
            }
            int[] digits = this.mDigits;
            int length = this.mLength;
            long p = 0L;
            for (int i = 0; i < length; ++i) {
                digits[i] = (int)(p += ((long)digits[i] & 0xFFFFFFFFL) * v);
                p >>>= 32;
            }
            if (p != 0L) {
                this.expand((int)1)[this.mLength - 1] = (int)p;
            }
        }

        public void multiplyByTen() {
            int[] digits = this.mDigits;
            int length = this.mLength;
            long p = 0L;
            for (int i = 0; i < length; ++i) {
                digits[i] = (int)(p += ((long)digits[i] & 0xFFFFFFFFL) * 10L);
                p >>>= 32;
            }
            if (p != 0L) {
                this.expand((int)1)[this.mLength - 1] = (int)p;
            }
        }

        public void multiplyByTenthPower(int v) {
            while (v > 9) {
                this.multiply(L_TENTH_POWERS[9]);
                v -= 9;
            }
            if (v != 0) {
                this.multiply(L_TENTH_POWERS[v]);
            }
        }

        public void divide(long v) throws ArithmeticException {
            if (v == 0L) {
                throw new ArithmeticException();
            }
            if (v == 1L) {
                return;
            }
            int[] digits = this.mDigits;
            int length = this.mLength;
            long divChunk = 0L;
            int i = length;
            while (--i >= 0) {
                if (v <= (divChunk += (long)digits[i] & 0xFFFFFFFFL)) {
                    long q = divChunk / v;
                    digits[i] = (int)q;
                    divChunk -= q * v;
                } else {
                    digits[i] = 0;
                    if (i == length - 1 && i > 0) {
                        this.mLength = --length;
                    }
                }
                divChunk <<= 32;
            }
        }

        public void divideByTen() {
            int[] digits = this.mDigits;
            int length = this.mLength;
            long divChunk = 0L;
            int i = length;
            while (--i >= 0) {
                if (10L <= (divChunk += (long)digits[i] & 0xFFFFFFFFL)) {
                    long q = divChunk / 10L;
                    digits[i] = (int)q;
                    divChunk -= q * 10L;
                } else {
                    digits[i] = 0;
                    if (i == length - 1 && i > 0) {
                        this.mLength = --length;
                    }
                }
                divChunk <<= 32;
            }
        }

        public int divideClose(LargeUInt v) throws ArithmeticException {
            if (v.isZero()) {
                throw new ArithmeticException("/ by zero");
            }
            int q = 0;
            while (this.compare(v) >= 0) {
                ++q;
                this.subtract(v);
            }
            return q;
        }

        public int compare(LargeUInt v) {
            int[] digits = this.mDigits;
            int[] vdigits = v.mDigits;
            int length = this.mLength;
            int vlength = v.mLength;
            if (length == vlength) {
                int i = length;
                while (--i >= 0) {
                    int a = digits[i];
                    int b = vdigits[i];
                    if (a < b) {
                        return (a ^ b) >= 0 ? -1 : 1;
                    }
                    if (a <= b) continue;
                    return (a ^ b) >= 0 ? 1 : -1;
                }
                return 0;
            }
            return length - vlength;
        }

        public boolean isZero() {
            return this.mLength == 1 && this.mDigits[0] == 0;
        }

        public String toString() {
            int[] digits = this.mDigits;
            int length = this.mLength;
            StringBuffer buf = new StringBuffer(2 + length * 8);
            buf.append('0');
            buf.append('x');
            int i = length;
            while (--i >= 0) {
                int digitsi = digits[i];
                String sub = Long.toHexString((long)digitsi & 0xFFFFFFFFL);
                int len = sub.length();
                if (len < 8 && i != length - 1) {
                    int j = 8 - len;
                    while (--j >= 0) {
                        buf.append('0');
                    }
                }
                buf.append(sub);
            }
            return buf.toString();
        }

        private void shrinkLength() {
            int length;
            int[] digits = this.mDigits;
            int i = length = this.mLength;
            while (--i >= 0 && digits[i] == 0) {
            }
            if (i + 1 < length) {
                this.mLength = i < 0 ? 1 : i + 1;
            }
        }

        private int[] expand(int amt) {
            int length = this.mLength;
            int[] digits = this.mDigits;
            if (length + amt > digits.length) {
                int newLength = length * 2;
                if (newLength < length + amt) {
                    newLength = length + amt;
                }
                int[] newDigits = new int[newLength];
                System.arraycopy(digits, 0, newDigits, 0, length);
                this.mDigits = newDigits;
                digits = newDigits;
            }
            this.mLength = length + amt;
            return digits;
        }
    }
}

