/*
 * Decompiled with CFR 0.152.
 */
package org.teatrove.trove.util;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.teatrove.trove.util.IdentityMap;

public class CompleteIntrospector {
    private static Map cPropertiesCache = new IdentityMap();

    public static void main(String[] args) throws Exception {
        Map map = CompleteIntrospector.getAllProperties(Class.forName(args[0]));
        for (String key : map.keySet()) {
            PropertyDescriptor desc = (PropertyDescriptor)map.get(key);
            System.out.println(key + " = " + desc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map getAllProperties(Class clazz) throws IntrospectionException {
        Map map = cPropertiesCache;
        synchronized (map) {
            Map properties;
            Reference ref = (Reference)cPropertiesCache.get(clazz);
            if (ref != null) {
                properties = (Map)ref.get();
                if (properties != null) {
                    return properties;
                }
                cPropertiesCache.remove(clazz);
            }
            properties = Collections.unmodifiableMap(CompleteIntrospector.createProperties(clazz));
            cPropertiesCache.put(clazz, new SoftReference(properties));
            return properties;
        }
    }

    private static Map createProperties(Class clazz) throws IntrospectionException {
        BeanInfo info;
        HashMap<String, PropertyDescriptor> properties = new HashMap<String, PropertyDescriptor>();
        if (clazz == null || clazz.isPrimitive()) {
            return properties;
        }
        try {
            info = Introspector.getBeanInfo(clazz);
        }
        catch (LinkageError e) {
            throw new IntrospectionException(e.toString());
        }
        if (info != null) {
            PropertyDescriptor[] pdArray = info.getPropertyDescriptors();
            int length = pdArray.length;
            for (int i = 0; i < length; ++i) {
                properties.put(pdArray[i].getName(), pdArray[i]);
            }
        }
        if (clazz.isInterface()) {
            properties.putAll(CompleteIntrospector.getAllProperties(Object.class));
        }
        Class<?>[] interfaces = clazz.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            properties.putAll(CompleteIntrospector.getAllProperties(interfaces[i]));
        }
        Iterator it = properties.keySet().iterator();
        while (it.hasNext()) {
            String propertyName = (String)it.next();
            if (propertyName.indexOf(36) < 0) continue;
            it.remove();
        }
        return properties;
    }

    static {
        Introspector.setBeanInfoSearchPath(new String[0]);
    }
}

