/*
 * Decompiled with CFR 0.152.
 */
package org.teatrove.trove.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.teatrove.trove.util.IdentityMap;
import org.teatrove.trove.util.NullKeyMap;

public class ClassInjector
extends ClassLoader {
    private static Map cShared = new NullKeyMap(new IdentityMap());
    private ClassLoader mSuperLoader;
    private File[] mRootClassDirs;
    private String mRootPackage;
    private Map mDefined;
    private Map mGZippedBytecode;
    private URLStreamHandler mFaker;

    public static ClassInjector getInstance() {
        return ClassInjector.getInstance(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ClassInjector getInstance(ClassLoader loader) {
        ClassInjector injector = null;
        Map map = cShared;
        synchronized (map) {
            Reference ref = (Reference)cShared.get(loader);
            if (ref != null) {
                injector = (ClassInjector)ref.get();
            }
            if (injector == null) {
                injector = new ClassInjector(loader);
                cShared.put(loader, new WeakReference<ClassInjector>(injector));
            }
            return injector;
        }
    }

    public ClassInjector() {
        this(null, (File[])null, null);
    }

    public ClassInjector(ClassLoader parent) {
        this(parent, (File[])null, null);
    }

    public ClassInjector(File rootClassDir, String rootPackage) {
        File[] fileArray;
        if (rootClassDir == null) {
            fileArray = null;
        } else {
            File[] fileArray2 = new File[1];
            fileArray = fileArray2;
            fileArray2[0] = rootClassDir;
        }
        this(null, fileArray, rootPackage);
    }

    public ClassInjector(ClassLoader parent, File rootClassDir, String rootPackage) {
        File[] fileArray;
        if (rootClassDir == null) {
            fileArray = null;
        } else {
            File[] fileArray2 = new File[1];
            fileArray = fileArray2;
            fileArray2[0] = rootClassDir;
        }
        this(parent, fileArray, rootPackage);
    }

    public ClassInjector(File[] rootClassDirs, String rootPackage) {
        this(null, rootClassDirs, rootPackage);
    }

    public ClassInjector(ClassLoader parent, File[] rootClassDirs, String rootPackage) {
        this(parent, rootClassDirs, rootPackage, false);
    }

    public ClassInjector(ClassLoader parent, File[] rootClassDirs, String rootPackage, boolean keepRawBytecode) {
        this.mDefined = Collections.synchronizedMap(new HashMap());
        if (parent == null) {
            parent = this.getClass().getClassLoader();
        }
        this.mSuperLoader = parent;
        if (rootClassDirs != null) {
            this.mRootClassDirs = (File[])rootClassDirs.clone();
        }
        if (rootPackage != null && !rootPackage.endsWith(".")) {
            rootPackage = rootPackage + '.';
        }
        this.mRootPackage = rootPackage;
        if (keepRawBytecode) {
            this.mGZippedBytecode = Collections.synchronizedMap(new HashMap());
        }
    }

    public OutputStream getStream(String name) {
        return new Stream(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetStream(String name) {
        Map map = this.mDefined;
        synchronized (map) {
            this.mDefined.remove(name);
        }
    }

    @Override
    public URL getResource(String name) {
        if (this.mGZippedBytecode != null && this.mGZippedBytecode.containsKey(name)) {
            try {
                return new URL("file", null, -1, name, this.getURLFaker());
            }
            catch (Exception e) {
                e.printStackTrace();
                System.out.println("created URL for " + name);
            }
        }
        return this.mSuperLoader.getResource(name);
    }

    private URLStreamHandler getURLFaker() {
        if (this.mFaker == null) {
            this.mFaker = new URLFaker();
        }
        return this.mFaker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> clazz = this.findLoadedClass(name);
        if (clazz == null) {
            ClassInjector classInjector = this;
            synchronized (classInjector) {
                clazz = this.findLoadedClass(name);
                if (clazz == null && (clazz = this.loadFromFile(name)) == null && (clazz = this.mSuperLoader != null ? this.mSuperLoader.loadClass(name) : this.findSystemClass(name)) == null) {
                    throw new ClassNotFoundException(name);
                }
            }
        }
        if (resolve) {
            this.resolveClass(clazz);
        }
        return clazz;
    }

    protected void define(String name, byte[] data) {
        this.defineClass(name, data, 0, data.length);
        if (this.mGZippedBytecode != null) {
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                GZIPOutputStream gz = new GZIPOutputStream(baos);
                gz.write(data, 0, data.length);
                gz.close();
                this.mGZippedBytecode.put(name.replace('.', '/') + ".class", baos.toByteArray());
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
    }

    private Class loadFromFile(String name) throws ClassNotFoundException {
        if (this.mRootClassDirs == null) {
            return null;
        }
        String fileName = name;
        if (this.mRootPackage != null) {
            if (fileName.startsWith(this.mRootPackage)) {
                fileName = fileName.substring(this.mRootPackage.length());
            } else {
                return null;
            }
        }
        fileName = fileName.replace('.', File.separatorChar);
        ClassNotFoundException error = null;
        for (int i = 0; i < this.mRootClassDirs.length; ++i) {
            File file = new File(this.mRootClassDirs[i], fileName + ".class");
            if (!file.exists()) continue;
            try {
                byte[] buffer = new byte[(int)file.length()];
                int avail = buffer.length;
                int offset = 0;
                FileInputStream in = new FileInputStream(file);
                int len = -1;
                while ((len = ((InputStream)in).read(buffer, offset, avail)) > 0) {
                    offset += len;
                    if ((avail -= len) > 0) continue;
                    avail = buffer.length;
                    byte[] newBuffer = new byte[avail * 2];
                    System.arraycopy(buffer, 0, newBuffer, 0, avail);
                    buffer = newBuffer;
                }
                ((InputStream)in).close();
                try {
                    return this.defineClass(name, buffer, 0, offset);
                }
                catch (Throwable ex) {
                    error = new ClassNotFoundException(ex.getMessage(), ex);
                    throw error;
                }
            }
            catch (IOException e) {
                if (error != null) continue;
                error = new ClassNotFoundException(fileName + ": " + e.toString());
            }
        }
        if (error != null) {
            throw error;
        }
        return null;
    }

    private class ResourceConnection
    extends URLConnection {
        String resourceName;

        public ResourceConnection(URL u) {
            super(u);
            this.resourceName = u.getFile();
        }

        @Override
        public void connect() {
        }

        @Override
        public InputStream getInputStream() throws IOException {
            try {
                if (ClassInjector.this.mGZippedBytecode != null) {
                    if (ClassInjector.this.mGZippedBytecode.get(this.resourceName) != null) {
                        return new GZIPInputStream(new ByteArrayInputStream((byte[])ClassInjector.this.mGZippedBytecode.get(this.resourceName)));
                    }
                    System.out.println(this.resourceName + " not found in bytecode map.");
                } else {
                    System.out.println("no bytecode map configured in " + ClassInjector.this);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return null;
        }
    }

    private class URLFaker
    extends URLStreamHandler {
        private URLFaker() {
        }

        @Override
        protected URLConnection openConnection(URL u) throws IOException {
            return new ResourceConnection(u);
        }
    }

    private class Stream
    extends ByteArrayOutputStream {
        private String mName;

        public Stream(String name) {
            super(1024);
            this.mName = name;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            Map map = ClassInjector.this.mDefined;
            synchronized (map) {
                if (ClassInjector.this.mDefined.get(this.mName) == null) {
                    ClassInjector.this.define(this.mName, this.toByteArray());
                    ClassInjector.this.mDefined.put(this.mName, this.mName);
                }
            }
        }
    }
}

