/*
 * Decompiled with CFR 0.152.
 */
package org.teatrove.trove.util;

import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.teatrove.trove.classfile.ClassFile;
import org.teatrove.trove.classfile.CodeBuilder;
import org.teatrove.trove.classfile.Label;
import org.teatrove.trove.classfile.LocalVariable;
import org.teatrove.trove.classfile.Location;
import org.teatrove.trove.classfile.MethodInfo;
import org.teatrove.trove.classfile.Modifiers;
import org.teatrove.trove.classfile.TypeDesc;
import org.teatrove.trove.util.ClassInjector;
import org.teatrove.trove.util.CompleteIntrospector;
import org.teatrove.trove.util.IdentityMap;
import org.teatrove.trove.util.NoSuchPropertyException;

public abstract class BeanPropertyAccessor {
    private static final boolean DEBUG;
    private static Map<Class<?>, BeanPropertyAccessor> cAccessors;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BeanPropertyAccessor forClass(Class<?> clazz) {
        Map<Class<?>, BeanPropertyAccessor> map = cAccessors;
        synchronized (map) {
            BeanPropertyAccessor bpa = cAccessors.get(clazz);
            if (bpa != null) {
                return bpa;
            }
            bpa = BeanPropertyAccessor.generate(clazz);
            cAccessors.put(clazz, bpa);
            return bpa;
        }
    }

    private static BeanPropertyAccessor generate(Class<?> beanType) {
        String baseName;
        ClassInjector injector = new ClassInjector(Thread.currentThread().getContextClassLoader(), (File)null, null);
        int id = beanType.hashCode();
        String className = baseName = BeanPropertyAccessor.class.getName() + '$';
        try {
            while (true) {
                className = baseName + ((long)id & 0xFFFFFFFFL);
                try {
                    injector.loadClass(className);
                }
                catch (LinkageError e) {
                    // empty catch block
                }
                ++id;
            }
        }
        catch (ClassNotFoundException e) {
            ClassFile cf = BeanPropertyAccessor.generateClassFile(className, beanType);
            if (DEBUG) {
                try {
                    String name = cf.getClassName();
                    name = name.substring(name.lastIndexOf(46) + 1) + ".class";
                    System.out.println(name);
                    FileOutputStream out = new FileOutputStream(name);
                    cf.writeTo(out);
                    out.close();
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
            }
            try {
                OutputStream stream = injector.getStream(cf.getClassName());
                cf.writeTo(stream);
                stream.close();
            }
            catch (IOException e3) {
                throw new InternalError(e3.toString());
            }
            try {
                Class<?> clazz = injector.loadClass(cf.getClassName());
                return (BeanPropertyAccessor)clazz.newInstance();
            }
            catch (ClassNotFoundException e4) {
                throw new InternalError(e4.toString());
            }
            catch (InstantiationException e5) {
                throw new InternalError(e5.toString());
            }
            catch (IllegalAccessException e6) {
                throw new InternalError(e6.toString());
            }
        }
    }

    private static ClassFile generateClassFile(String className, Class<?> beanType) {
        PropertyDescriptor[][] props = BeanPropertyAccessor.getBeanProperties(beanType);
        ClassFile cf = new ClassFile(className, BeanPropertyAccessor.class);
        cf.markSynthetic();
        Modifiers publicAccess = new Modifiers();
        publicAccess.setPublic(true);
        MethodInfo ctor = cf.addConstructor(publicAccess, new TypeDesc[0]);
        ctor.markSynthetic();
        CodeBuilder builder = new CodeBuilder(ctor);
        builder.loadThis();
        builder.invokeSuperConstructor(new TypeDesc[0]);
        builder.returnVoid();
        BeanPropertyAccessor.generateMethod(cf, beanType, props[0], true);
        BeanPropertyAccessor.generateMethod(cf, beanType, props[1], false);
        return cf;
    }

    private static void generateMethod(ClassFile cf, Class<?> beanType, PropertyDescriptor[] properties, boolean forRead) {
        MethodInfo mi;
        TypeDesc[] params;
        Modifiers publicAccess = new Modifiers();
        publicAccess.setPublic(true);
        TypeDesc objectType = TypeDesc.OBJECT;
        TypeDesc stringType = TypeDesc.STRING;
        TypeDesc intType = TypeDesc.INT;
        TypeDesc booleanType = TypeDesc.BOOLEAN;
        TypeDesc exceptionType = TypeDesc.forClass(NoSuchPropertyException.class);
        if (forRead) {
            params = new TypeDesc[]{objectType, stringType};
            mi = cf.addMethod(publicAccess, "getPropertyValue", objectType, params);
        } else {
            params = new TypeDesc[]{objectType, stringType, objectType};
            mi = cf.addMethod(publicAccess, "setPropertyValue", null, params);
        }
        mi.markSynthetic();
        CodeBuilder builder = new CodeBuilder(mi);
        LocalVariable beanVar = builder.getParameters()[0];
        LocalVariable propertyVar = builder.getParameters()[1];
        LocalVariable valueVar = forRead ? null : builder.getParameters()[2];
        builder.loadLocal(beanVar);
        builder.checkCast(TypeDesc.forClass(beanType));
        builder.storeLocal(beanVar);
        if (properties.length > 0) {
            int[] cases = new int[BeanPropertyAccessor.hashCapacity(properties.length)];
            int caseCount = cases.length;
            for (int i = 0; i < caseCount; ++i) {
                cases[i] = i;
            }
            Location[] switchLabels = new Label[caseCount];
            Label noMatch = builder.createLabel();
            List<PropertyDescriptor>[] caseMethods = BeanPropertyAccessor.caseMethods(caseCount, properties);
            for (int i = 0; i < caseCount; ++i) {
                List<PropertyDescriptor> matches = caseMethods[i];
                switchLabels[i] = matches == null || matches.size() == 0 ? noMatch : builder.createLabel();
            }
            if (properties.length > 1) {
                builder.loadLocal(propertyVar);
                builder.invokeVirtual(String.class.getName(), "hashCode", intType, new TypeDesc[0]);
                builder.loadConstant(Integer.MAX_VALUE);
                builder.math((byte)126);
                builder.loadConstant(caseCount);
                builder.math((byte)112);
                builder.switchBranch(cases, switchLabels, noMatch);
            }
            TypeDesc[] params2 = new TypeDesc[]{objectType};
            for (int i = 0; i < caseCount; ++i) {
                List<PropertyDescriptor> matches = caseMethods[i];
                if (matches == null || matches.size() == 0) continue;
                switchLabels[i].setLocation();
                int matchCount = matches.size();
                for (int j = 0; j < matchCount; ++j) {
                    Label notEqual;
                    PropertyDescriptor pd = matches.get(j);
                    builder.loadConstant(pd.getName());
                    builder.loadLocal(propertyVar);
                    builder.invokeVirtual(String.class.getName(), "equals", booleanType, params2);
                    if (j == matchCount - 1) {
                        notEqual = null;
                        builder.ifZeroComparisonBranch(noMatch, "==");
                    } else {
                        notEqual = builder.createLabel();
                        builder.ifZeroComparisonBranch(notEqual, "==");
                    }
                    if (forRead) {
                        BeanPropertyAccessor.loadPropertyAsObject(builder, beanVar, pd.getReadMethod());
                        builder.returnValue(TypeDesc.OBJECT);
                    } else {
                        BeanPropertyAccessor.savePropertyFromObject(builder, beanVar, valueVar, pd.getWriteMethod());
                        builder.returnVoid();
                    }
                    if (notEqual == null) continue;
                    notEqual.setLocation();
                }
            }
            noMatch.setLocation();
        }
        builder.newObject(exceptionType);
        builder.dup();
        builder.loadLocal(propertyVar);
        builder.loadConstant(forRead);
        TypeDesc[] params3 = new TypeDesc[]{stringType, booleanType};
        builder.invokeConstructor(NoSuchPropertyException.class.getName(), params3);
        builder.throwObject();
    }

    private static void loadPropertyAsObject(CodeBuilder builder, LocalVariable beanVar, Method m) {
        Class<?> returnType = m.getReturnType();
        Type genericType = m.getGenericReturnType();
        if (!returnType.isPrimitive()) {
            builder.loadLocal(beanVar);
            builder.invoke(m);
            return;
        }
        if (returnType == Boolean.TYPE) {
            TypeDesc td = TypeDesc.BOOLEAN.toObjectType();
            Label falseLabel = builder.createLabel();
            Label endLabel = builder.createLabel();
            builder.loadLocal(beanVar);
            builder.invoke(m);
            builder.ifZeroComparisonBranch(falseLabel, "==");
            builder.loadStaticField("java.lang.Boolean", "TRUE", td);
            builder.branch(endLabel);
            falseLabel.setLocation();
            builder.loadStaticField("java.lang.Boolean", "FALSE", td);
            endLabel.setLocation();
            return;
        }
        TypeDesc objectType = TypeDesc.forClass(returnType, genericType).toObjectType();
        TypeDesc[] params = new TypeDesc[]{objectType.toPrimitiveType()};
        builder.newObject(objectType);
        builder.dup();
        builder.loadLocal(beanVar);
        builder.invoke(m);
        builder.invokeConstructor(objectType.getRootName(), params);
    }

    private static void savePropertyFromObject(CodeBuilder builder, LocalVariable beanVar, LocalVariable valueVar, Method m) {
        Class<?> valueType = m.getParameterTypes()[0];
        if (!valueType.isPrimitive()) {
            builder.loadLocal(beanVar);
            builder.loadLocal(valueVar);
            builder.checkCast(TypeDesc.forClass(valueType));
            builder.invoke(m);
            return;
        }
        String name = valueType.getName();
        String methodName = name + "Value";
        String objectName = valueType == Integer.TYPE ? Integer.class.getName() : (valueType == Character.TYPE ? Character.class.getName() : "java.lang." + Character.toUpperCase(name.charAt(0)) + name.substring(1));
        builder.loadLocal(beanVar);
        builder.loadLocal(valueVar);
        builder.checkCast(TypeDesc.forClass(objectName));
        builder.invokeVirtual(objectName, methodName, TypeDesc.forClass(valueType), new TypeDesc[0]);
        builder.invoke(m);
    }

    private static int hashCapacity(int min) {
        BigInteger capacity = BigInteger.valueOf(min * 2 + 1);
        while (!capacity.isProbablePrime(100)) {
            capacity = capacity.add(BigInteger.valueOf(2L));
        }
        return capacity.intValue();
    }

    private static List<PropertyDescriptor>[] caseMethods(int caseCount, PropertyDescriptor[] props) {
        List[] cases = new List[caseCount];
        for (int i = 0; i < props.length; ++i) {
            PropertyDescriptor prop = props[i];
            int hashCode = prop.getName().hashCode();
            int caseValue = (hashCode & Integer.MAX_VALUE) % caseCount;
            ArrayList<PropertyDescriptor> matches = cases[caseValue];
            if (matches == null) {
                matches = cases[caseValue] = new ArrayList<PropertyDescriptor>();
            }
            matches.add(prop);
        }
        return cases;
    }

    private static PropertyDescriptor[][] getBeanProperties(Class<?> beanType) {
        ArrayList<PropertyDescriptor> readProperties = new ArrayList<PropertyDescriptor>();
        ArrayList<PropertyDescriptor> writeProperties = new ArrayList<PropertyDescriptor>();
        try {
            Map map = CompleteIntrospector.getAllProperties(beanType);
            for (PropertyDescriptor pd : map.values()) {
                if (pd.getReadMethod() != null) {
                    readProperties.add(pd);
                }
                if (pd.getWriteMethod() == null) continue;
                writeProperties.add(pd);
            }
        }
        catch (IntrospectionException e) {
            throw new RuntimeException(e.toString());
        }
        PropertyDescriptor[][] props = new PropertyDescriptor[2][];
        props[0] = new PropertyDescriptor[readProperties.size()];
        readProperties.toArray(props[0]);
        props[1] = new PropertyDescriptor[writeProperties.size()];
        writeProperties.toArray(props[1]);
        return props;
    }

    protected BeanPropertyAccessor() {
    }

    public abstract Object getPropertyValue(Object var1, String var2) throws NoSuchPropertyException;

    public abstract void setPropertyValue(Object var1, String var2, Object var3) throws NoSuchPropertyException;

    static {
        cAccessors = new IdentityMap();
        DEBUG = Boolean.getBoolean("org.teatrove.trove.util.BeanPropertyAccessor.DEBUG");
    }
}

