/*
 * Decompiled with CFR 0.152.
 */
package org.teatrove.trove.net;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.util.Collections;
import java.util.Map;
import org.teatrove.trove.util.SoftHashMap;
import org.teatrove.trove.util.ThreadPool;

public class SocketConnector {
    private static final int CONNECT_THREAD_MAX = 5;
    private static Map mConnectors = Collections.synchronizedMap(new SoftHashMap());

    public static Socket connect(String host, int port, long timeout) throws SocketException {
        return SocketConnector.connect((Object)host, port, null, 0, timeout);
    }

    public static Socket connect(InetAddress address, int port, long timeout) throws SocketException {
        return SocketConnector.connect((Object)address, port, null, 0, timeout);
    }

    public static Socket connect(String host, int port, InetAddress localAddress, int localPort, long timeout) throws SocketException {
        return SocketConnector.connect((Object)host, port, localAddress, localPort, timeout);
    }

    public static Socket connect(InetAddress address, int port, InetAddress localAddress, int localPort, long timeout) throws SocketException {
        return SocketConnector.connect((Object)address, port, localAddress, localPort, timeout);
    }

    private static Socket connect(Object address, int port, InetAddress localAddress, int localPort, long timeout) throws SocketException {
        Thread thread;
        Key key = new Key(address, port, localAddress, localPort);
        ThreadPool pool = SocketConnector.getThreadPool(key);
        Connector connector = new Connector(key);
        long start = timeout > 0L ? System.currentTimeMillis() : 0L;
        try {
            thread = pool.start((Runnable)connector, timeout);
        }
        catch (InterruptedException e) {
            return null;
        }
        catch (IllegalThreadStateException e) {
            pool = SocketConnector.getNewThreadPool(key, pool);
            try {
                thread = pool.start((Runnable)connector, timeout);
            }
            catch (InterruptedException e2) {
                return null;
            }
        }
        if (timeout > 0L && (timeout -= System.currentTimeMillis() - start) < 0L) {
            timeout = 0L;
        }
        try {
            Socket socket = connector.connect(timeout);
            if (socket != null) {
                return socket;
            }
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        thread.interrupt();
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ThreadPool getNewThreadPool(Object key, ThreadPool old) {
        Map map = mConnectors;
        synchronized (map) {
            if (mConnectors.get(key) == old) {
                mConnectors.remove(key);
            }
            return SocketConnector.getThreadPool(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ThreadPool getThreadPool(Object key) {
        ThreadPool pool;
        Map map = mConnectors;
        synchronized (map) {
            pool = (ThreadPool)mConnectors.get(key);
            if (pool == null) {
                pool = new ThreadPool("SocketConnector[" + key + ']', 5);
                pool.setIdleTimeout(10000L);
                mConnectors.put(key, pool);
            }
        }
        return pool;
    }

    private SocketConnector() {
    }

    private static class Connector
    implements Runnable {
        private final Key mKey;
        private Object mSocketOrException;
        private boolean mDoneWaiting;

        public Connector(Key key) {
            this.mKey = key;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized Socket connect(long timeout) throws SocketException, InterruptedException {
            block8: {
                try {
                    if (this.mSocketOrException != null) break block8;
                    if (timeout < 0L) {
                        this.wait();
                        break block8;
                    }
                    if (timeout > 0L) {
                        this.wait(timeout);
                        break block8;
                    }
                    Socket socket = null;
                    return socket;
                }
                finally {
                    this.mDoneWaiting = true;
                }
            }
            if (this.mSocketOrException instanceof Socket) {
                return (Socket)this.mSocketOrException;
            }
            if (this.mSocketOrException instanceof InterruptedIOException) {
                throw new InterruptedException();
            }
            if (this.mSocketOrException instanceof Exception) {
                throw new SocketException("Unable to connect to " + this.mKey + ", " + ((Exception)this.mSocketOrException).getMessage());
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                Object address = this.mKey.mAddress;
                InetAddress localAddress = this.mKey.mLocalAddress;
                Socket socket = address instanceof InetAddress ? (localAddress == null ? new Socket((InetAddress)address, this.mKey.mPort) : new Socket((InetAddress)address, this.mKey.mPort, localAddress, this.mKey.mLocalPort)) : (localAddress == null ? new Socket(String.valueOf(address), this.mKey.mPort) : new Socket(String.valueOf(address), this.mKey.mPort, localAddress, this.mKey.mLocalPort));
                Connector connector = this;
                synchronized (connector) {
                    if (this.mDoneWaiting) {
                        try {
                            socket.close();
                        }
                        catch (IOException e) {}
                    } else {
                        this.mSocketOrException = socket;
                        this.notify();
                    }
                }
            }
            catch (Exception e) {
                Connector connector = this;
                synchronized (connector) {
                    this.mSocketOrException = e;
                    this.notify();
                }
            }
        }
    }

    private static class Key {
        final Object mAddress;
        final int mPort;
        final InetAddress mLocalAddress;
        final int mLocalPort;

        Key(Object address, int port, InetAddress localAddress, int localPort) {
            this.mAddress = address;
            this.mPort = port;
            this.mLocalAddress = localAddress;
            this.mLocalPort = localPort;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Key) {
                Key key = (Key)obj;
                return key.mAddress.equals(this.mAddress) && key.mPort == this.mPort && (key.mLocalAddress == null ? this.mLocalAddress == null : key.mLocalAddress.equals(this.mLocalAddress)) && key.mLocalPort == this.mLocalPort;
            }
            return false;
        }

        public int hashCode() {
            return this.mAddress.hashCode() + this.mPort;
        }

        public String toString() {
            if (this.mAddress instanceof InetAddress) {
                return ((InetAddress)this.mAddress).getHostAddress() + ':' + this.mPort;
            }
            return String.valueOf(this.mAddress) + ':' + this.mPort;
        }
    }
}

