/*
 * Decompiled with CFR 0.152.
 */
package org.teatrove.trove.net;

import java.io.IOException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import org.teatrove.trove.net.CheckedSocket;
import org.teatrove.trove.net.PlainSocketFactory;
import org.teatrove.trove.net.SocketConnector;

public class SSLSocketFactory
extends PlainSocketFactory {
    private final javax.net.ssl.SSLSocketFactory mSSLFactory = (javax.net.ssl.SSLSocketFactory)javax.net.ssl.SSLSocketFactory.getDefault();

    public SSLSocketFactory(InetAddress addr, int port, long timeout) {
        super(addr, port, timeout);
    }

    public SSLSocketFactory(InetAddress addr, int port, InetAddress localAddr, int localPort, long timeout) {
        super(addr, port, localAddr, localPort, timeout);
    }

    @Override
    public CheckedSocket createSocket(long timeout) throws ConnectException, SocketException {
        Socket socket = SocketConnector.connect(this.mAddr, this.mPort, this.mLocalAddr, this.mLocalPort, timeout);
        if (socket == null) {
            throw new ConnectException("Connect timeout expired: " + timeout);
        }
        try {
            socket = this.mSSLFactory.createSocket(socket, this.mAddr.getHostAddress(), this.mPort, true);
        }
        catch (IOException e) {
            throw new SocketException(e.toString());
        }
        return CheckedSocket.check(socket);
    }
}

