/*
 * Decompiled with CFR 0.152.
 */
package org.teatrove.trove.net;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import org.teatrove.trove.net.DistributedSocketFactory;
import org.teatrove.trove.net.InetAddressListener;
import org.teatrove.trove.net.InetAddressResolver;
import org.teatrove.trove.net.LazySocketFactory;
import org.teatrove.trove.net.PlainSocketFactory;
import org.teatrove.trove.net.PooledSocketFactory;
import org.teatrove.trove.net.SocketFactory;

public class MultiPooledSocketFactory
extends DistributedSocketFactory {
    final InetAddress mLocalAddr;
    final int mLocalPort;
    private Object[] mResolvers;

    public MultiPooledSocketFactory(String[] hosts, int[] ports, long timeout) {
        this(hosts, ports, null, 0, timeout, null);
    }

    public MultiPooledSocketFactory(String[] hosts, int[] ports, long timeout, Random rnd) {
        this(hosts, ports, null, 0, timeout, rnd);
    }

    public MultiPooledSocketFactory(String[] hosts, int[] ports, InetAddress localAddr, int localPort, long timeout) {
        this(hosts, ports, localAddr, localPort, timeout, null);
    }

    public MultiPooledSocketFactory(String[] hosts, int[] ports, InetAddress localAddr, int localPort, long timeout, Random rnd) {
        super(timeout, rnd);
        this.mLocalAddr = localAddr;
        this.mLocalPort = localPort;
        try {
            this.mResolvers = new InetAddressResolver[hosts.length];
            for (int i = 0; i < hosts.length; ++i) {
                Listener listener = new Listener(ports[i], timeout);
                this.mResolvers[i] = InetAddressResolver.listenFor(hosts[i], listener);
            }
        }
        catch (NoClassDefFoundError e) {
            this.mResolvers = null;
            for (int i = 0; i < hosts.length; ++i) {
                Listener listener = new Listener(ports[i], timeout);
                try {
                    listener.resolved(InetAddress.getAllByName(hosts[i]));
                    continue;
                }
                catch (UnknownHostException e2) {
                    listener.unknown(e2);
                }
            }
        }
    }

    protected SocketFactory createSocketFactory(InetAddress address, int port, InetAddress localAddr, int localPort, long timeout) {
        SocketFactory factory = new PlainSocketFactory(address, port, localAddr, localPort, timeout);
        factory = new PooledSocketFactory(factory);
        factory = new LazySocketFactory(factory);
        return factory;
    }

    private class Listener
    implements InetAddressListener {
        private final int mPort;
        private final long mTimeout;
        private Map mAddressedFactories;

        public Listener(int port, long timeout) {
            this.mPort = port;
            this.mTimeout = timeout;
            this.mAddressedFactories = new HashMap();
        }

        @Override
        public void unknown(UnknownHostException e) {
            Thread t = Thread.currentThread();
            t.getThreadGroup().uncaughtException(t, e);
            Iterator it = this.mAddressedFactories.keySet().iterator();
            while (it.hasNext()) {
                SocketFactory factory = (SocketFactory)this.mAddressedFactories.get(it.next());
                MultiPooledSocketFactory.this.removeSocketFactory(factory);
            }
        }

        @Override
        public void resolved(InetAddress[] addresses) {
            for (int i = 0; i < addresses.length; ++i) {
                InetAddress address = addresses[i];
                if (this.mAddressedFactories.containsKey(address)) continue;
                SocketFactory factory = MultiPooledSocketFactory.this.createSocketFactory(address, this.mPort, MultiPooledSocketFactory.this.mLocalAddr, MultiPooledSocketFactory.this.mLocalPort, this.mTimeout);
                this.mAddressedFactories.put(address, factory);
                MultiPooledSocketFactory.this.addSocketFactory(factory);
            }
            block1: for (InetAddress address : this.mAddressedFactories.keySet()) {
                for (int i = 0; i < addresses.length; ++i) {
                    if (addresses[i].equals(address)) continue block1;
                }
                SocketFactory factory = (SocketFactory)this.mAddressedFactories.get(address);
                MultiPooledSocketFactory.this.removeSocketFactory(factory);
            }
        }
    }
}

