/*
 * Decompiled with CFR 0.152.
 */
package org.teatrove.trove.net;

import java.io.IOException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.StringTokenizer;
import org.teatrove.trove.log.Log;
import org.teatrove.trove.log.Syslog;

public class LocalNetResolver {
    public static InetAddress resolveLocalNet(String host, String netInterface) throws IOException {
        return LocalNetResolver.resolveLocalNet(host, netInterface, null);
    }

    public static InetAddress resolveLocalNet(String host, String netInterface, Log log) throws IOException {
        if (netInterface != null) {
            try {
                StringTokenizer st;
                byte[] mask = new byte[]{-1, -1, -1, 0};
                int slashindex = -1;
                slashindex = netInterface.indexOf(47);
                if (slashindex >= 0) {
                    int maskID = Integer.parseInt(netInterface.substring(slashindex + 1));
                    netInterface = netInterface.substring(0, slashindex);
                    slashindex = Integer.MIN_VALUE >> maskID - 1;
                    mask[3] = (byte)(slashindex & 0xFF);
                    mask[2] = (byte)(slashindex >> 8 & 0xFF);
                    mask[1] = (byte)(slashindex >> 16 & 0xFF);
                    mask[0] = (byte)(slashindex >> 24 & 0xFF);
                }
                if ((st = new StringTokenizer(netInterface, " .")).countTokens() == 4) {
                    byte[] maskedNet = new byte[4];
                    for (int k = 0; k < 4; ++k) {
                        String token = st.nextToken();
                        maskedNet[k] = (byte)(Integer.parseInt(token) & mask[k]);
                    }
                    if (log != null) {
                        log.debug("net: " + (maskedNet[0] & 0xFF) + "." + (maskedNet[1] & 0xFF) + "." + (maskedNet[2] & 0xFF) + "." + (maskedNet[3] & 0xFF));
                    }
                    InetAddress[] addresses = host != null ? InetAddress.getAllByName(host) : LocalNetResolver.getAllLocalInetAddresses(log);
                    if (log != null) {
                        log.debug("addresses on this host.");
                        for (int j = 0; j < addresses.length; ++j) {
                            log.debug(addresses[j].getHostAddress());
                        }
                    }
                    for (int j = 0; j < addresses.length; ++j) {
                        byte[] testAddress = addresses[j].getAddress();
                        if (log != null) {
                            log.debug("testing: " + addresses[j].getHostAddress());
                        }
                        if (maskedNet[0] != (testAddress[0] & mask[0]) || maskedNet[1] != (testAddress[1] & mask[1]) || maskedNet[2] != (testAddress[2] & mask[2]) || maskedNet[3] != (testAddress[3] & mask[3])) continue;
                        Syslog.info(addresses[j].getHostAddress() + " matched the specified localNet");
                        return addresses[j];
                    }
                }
            }
            catch (Exception e) {
                Syslog.warn(e);
            }
            throw new IOException("Failed to resolve local network");
        }
        if (host != null) {
            return InetAddress.getByName(host);
        }
        return InetAddress.getLocalHost();
    }

    private static InetAddress[] getAllLocalInetAddresses(Log log) throws SocketException {
        ArrayList<InetAddress> addresses = new ArrayList<InetAddress>();
        Enumeration<NetworkInterface> netInterfaces = NetworkInterface.getNetworkInterfaces();
        while (netInterfaces.hasMoreElements()) {
            NetworkInterface ni = netInterfaces.nextElement();
            if (log != null) {
                log.debug("Found interface: " + ni.getName());
            }
            Enumeration<InetAddress> ips = ni.getInetAddresses();
            while (ips.hasMoreElements()) {
                InetAddress ip = ips.nextElement();
                if (log != null) {
                    log.debug("Found ip: " + ip.getHostName() + "/" + ip.getHostAddress() + " on interface: " + ni.getName());
                }
                if (ip.isLoopbackAddress()) continue;
                if (log != null) {
                    log.debug("Let's add this IP: " + ip.getCanonicalHostName());
                }
                addresses.add(ip);
            }
        }
        return addresses.toArray(new InetAddress[addresses.size()]);
    }
}

