/*
 * Decompiled with CFR 0.152.
 */
package org.teatrove.trove.net;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.constant.Constable;
import java.net.InetAddress;
import java.net.SocketException;
import org.teatrove.trove.net.CheckedSocket;
import org.teatrove.trove.net.InetAddressAndPort;
import org.teatrove.trove.net.SocketFace;
import org.teatrove.trove.net.SocketFactory;

class LazySocket
implements SocketFace {
    private final SocketFactory mFactory;
    private final Object mSession;
    private final long mTimeout;
    private boolean mClosed;
    private CheckedSocket mSocket;
    private InputStream mIn;
    private OutputStream mOut;
    private Object[] mOptions;

    public LazySocket(SocketFactory factory) throws SocketException {
        this(factory, null, factory.getDefaultTimeout());
    }

    public LazySocket(SocketFactory factory, Object session) throws SocketException {
        this(factory, session, factory.getDefaultTimeout());
    }

    public LazySocket(SocketFactory factory, long timeout) throws SocketException {
        this(factory, null, timeout);
    }

    public LazySocket(SocketFactory factory, Object session, long timeout) throws SocketException {
        this.mFactory = factory;
        this.mSession = session;
        this.mTimeout = timeout;
    }

    @Override
    public InetAddress getInetAddress() {
        if (this.mSocket != null) {
            return this.mSocket.getInetAddress();
        }
        return this.mFactory.getInetAddressAndPort(this.mSession).getInetAddress();
    }

    @Override
    public InetAddress getLocalAddress() {
        if (this.mSocket != null) {
            return this.mSocket.getLocalAddress();
        }
        return null;
    }

    @Override
    public int getPort() {
        if (this.mSocket != null) {
            return this.mSocket.getPort();
        }
        return this.mFactory.getInetAddressAndPort(this.mSession).getPort();
    }

    @Override
    public int getLocalPort() {
        if (this.mSocket != null) {
            return this.mSocket.getLocalPort();
        }
        return -1;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        if (this.mIn == null) {
            this.mIn = new In();
        }
        return this.mIn;
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        if (this.mOut == null) {
            this.mOut = new Out();
        }
        return this.mOut;
    }

    @Override
    public void setTcpNoDelay(boolean on) throws SocketException {
        if (this.mSocket != null) {
            this.mSocket.setTcpNoDelay(on);
        } else {
            this.setOption(0, on ? Boolean.TRUE : Boolean.FALSE);
        }
    }

    @Override
    public boolean getTcpNoDelay() throws SocketException {
        return this.createSocket().getTcpNoDelay();
    }

    @Override
    public void setSoLinger(boolean on, int linger) throws SocketException {
        if (this.mSocket != null) {
            this.mSocket.setSoLinger(on, linger);
        } else {
            Comparable<Boolean> value = on ? (Constable)new Integer(linger) : (Constable)Boolean.FALSE;
            this.setOption(1, value);
        }
    }

    @Override
    public int getSoLinger() throws SocketException {
        return this.createSocket().getSoLinger();
    }

    @Override
    public void setSoTimeout(int timeout) throws SocketException {
        if (this.mSocket != null) {
            this.mSocket.setSoTimeout(timeout);
        } else {
            this.setOption(2, new Integer(timeout));
        }
    }

    @Override
    public int getSoTimeout() throws SocketException {
        return this.createSocket().getSoTimeout();
    }

    @Override
    public void setSendBufferSize(int size) throws SocketException {
        if (this.mSocket != null) {
            this.mSocket.setSendBufferSize(size);
        } else {
            this.setOption(3, new Integer(size));
        }
    }

    @Override
    public int getSendBufferSize() throws SocketException {
        return this.createSocket().getSendBufferSize();
    }

    @Override
    public void setReceiveBufferSize(int size) throws SocketException {
        if (this.mSocket != null) {
            this.mSocket.setReceiveBufferSize(size);
        } else {
            this.setOption(4, new Integer(size));
        }
    }

    @Override
    public int getReceiveBufferSize() throws SocketException {
        return this.createSocket().getReceiveBufferSize();
    }

    @Override
    public void setKeepAlive(boolean on) throws SocketException {
        if (this.mSocket != null) {
            this.mSocket.setKeepAlive(on);
        } else {
            this.setOption(5, on ? Boolean.TRUE : Boolean.FALSE);
        }
    }

    @Override
    public boolean getKeepAlive() throws SocketException {
        return this.createSocket().getKeepAlive();
    }

    @Override
    public void shutdownInput() throws IOException {
        this.createSocket().shutdownInput();
    }

    @Override
    public void shutdownOutput() throws IOException {
        this.createSocket().shutdownOutput();
    }

    @Override
    public void close() throws IOException {
        this.mClosed = true;
        if (this.mSocket != null) {
            this.mSocket.close();
        }
    }

    public String toString() {
        if (this.mSocket != null) {
            return this.mSocket.toString();
        }
        InetAddressAndPort ip = this.mFactory.getInetAddressAndPort(this.mSession);
        return "Unconnected socket[addr=" + ip.getInetAddress() + ",port=" + ip.getPort() + ']';
    }

    CheckedSocket recycle() {
        CheckedSocket s;
        if (this.mClosed) {
            s = null;
        } else {
            s = this.mSocket;
            this.mSocket = null;
            this.mClosed = true;
        }
        return s;
    }

    private SocketFace createSocket() throws SocketException {
        if (this.mSocket != null) {
            return this.mSocket;
        }
        if (this.mClosed) {
            throw new SocketException("Socket is closed");
        }
        this.mSocket = this.mFactory.createSocket(this.mSession, this.mTimeout);
        this.applyOptions();
        return this.mSocket;
    }

    private SocketFace getSocket(byte[] data, int off, int len) throws SocketException {
        if (this.mSocket != null) {
            return this.mSocket;
        }
        if (this.mClosed) {
            throw new SocketException("Socket is closed");
        }
        long timeout = this.mTimeout;
        long start = timeout > 0L ? System.currentTimeMillis() : 0L;
        try {
            this.mSocket = this.mFactory.getSocket(this.mSession, timeout);
            this.applyOptions();
            OutputStream out = this.mSocket.getOutputStream();
            out.write(data, off, len);
            out.flush();
        }
        catch (Exception e) {
            if (this.mSocket != null) {
                try {
                    this.mSocket.close();
                }
                catch (Exception e2) {
                    // empty catch block
                }
            }
            if (timeout > 0L && (timeout -= System.currentTimeMillis() - start) < 0L) {
                timeout = 0L;
            }
            this.mSocket = this.mFactory.createSocket(this.mSession, timeout);
            this.applyOptions();
            try {
                OutputStream out = this.mSocket.getOutputStream();
                out.write(data, off, len);
                out.flush();
            }
            catch (IOException e2) {
                throw new SocketException(e2.getMessage());
            }
        }
        return this.mSocket;
    }

    private void setOption(int index, Object value) {
        if (this.mOptions == null) {
            this.mOptions = new Object[6];
        }
        this.mOptions[index] = value;
    }

    private void applyOptions() throws SocketException {
        if (this.mOptions == null || this.mSocket == null) {
            return;
        }
        Object[] options = this.mOptions;
        Object value = options[0];
        if (value != null) {
            this.mSocket.setTcpNoDelay((Boolean)value);
        }
        if ((value = options[1]) != null) {
            if (value instanceof Boolean) {
                this.mSocket.setSoLinger((Boolean)value, 0);
            } else {
                this.mSocket.setSoLinger(true, (Integer)value);
            }
        }
        if ((value = options[2]) != null) {
            this.mSocket.setSoTimeout((Integer)value);
        }
        if ((value = options[3]) != null) {
            this.mSocket.setSendBufferSize((Integer)value);
        }
        if ((value = options[4]) != null) {
            this.mSocket.setReceiveBufferSize((Integer)value);
        }
        if ((value = options[5]) != null) {
            this.mSocket.setKeepAlive((Boolean)value);
        }
    }

    private class Out
    extends OutputStream {
        private OutputStream mStream;

        private Out() {
        }

        @Override
        public void write(int b) throws IOException {
            this.write(new byte[]{(byte)b}, 0, 1);
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.write(b, 0, b.length);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            if (this.mStream == null) {
                this.mStream = LazySocket.this.getSocket(b, off, len).getOutputStream();
            } else {
                this.mStream.write(b, off, len);
            }
        }

        @Override
        public void flush() throws IOException {
            if (this.mStream != null) {
                this.mStream.flush();
            }
        }

        @Override
        public void close() throws IOException {
            if (this.mStream != null) {
                this.mStream.close();
            }
            LazySocket.this.close();
        }
    }

    private class In
    extends InputStream {
        private InputStream mStream;

        private In() {
        }

        @Override
        public int read() throws IOException {
            return this.getStream().read();
        }

        @Override
        public int read(byte[] b) throws IOException {
            return this.getStream().read(b);
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            return this.getStream().read(b, off, len);
        }

        @Override
        public long skip(long n) throws IOException {
            return this.getStream().skip(n);
        }

        @Override
        public int available() throws IOException {
            return this.getStream().available();
        }

        @Override
        public void close() throws IOException {
            if (this.mStream != null) {
                this.mStream.close();
            }
            LazySocket.this.close();
        }

        @Override
        public void mark(int readlimit) {
            try {
                this.getStream().mark(readlimit);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        @Override
        public void reset() throws IOException {
            if (this.mStream == null) {
                throw new IOException("Stream not marked");
            }
            this.mStream.reset();
        }

        @Override
        public boolean markSupported() {
            try {
                return this.getStream().markSupported();
            }
            catch (IOException e) {
                return false;
            }
        }

        private InputStream getStream() throws IOException {
            if (this.mStream == null) {
                this.mStream = LazySocket.this.createSocket().getInputStream();
            }
            return this.mStream;
        }
    }
}

