/*
 * Decompiled with CFR 0.152.
 */
package org.teatrove.trove.net;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.teatrove.trove.net.InetAddressListener;
import org.teatrove.trove.util.SoftHashMap;

public class InetAddressResolver {
    private static final long RESOLVE_PERIOD = 600000L;
    private static Timer cResolveTimer;
    private static Map cResolvers;
    private final String mHost;
    private List mListeners = new ArrayList();
    private Object mResolutionResults;

    private static Timer getResolveTimer() {
        Timer timer = cResolveTimer;
        if (timer == null) {
            timer = new Timer(true);
            timer.schedule(new TimerTask(){

                @Override
                public void run() {
                    Thread.currentThread().setName("InetAddressResolver");
                }
            }, 0L);
            cResolveTimer = timer;
        }
        return timer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InetAddressResolver listenFor(String host, InetAddressListener listener) {
        Map map = cResolvers;
        synchronized (map) {
            InetAddressResolver resolver = (InetAddressResolver)cResolvers.get(host);
            if (resolver == null) {
                resolver = new InetAddressResolver(host);
                cResolvers.put(host, resolver);
            }
            resolver.addListener(listener);
            return resolver;
        }
    }

    private InetAddressResolver(String host) {
        this.mHost = host;
        long delay = (long)(Math.random() * 600000.0);
        InetAddressResolver.getResolveTimer().schedule((TimerTask)new Resolver(this), delay, 600000L);
    }

    private synchronized void addListener(InetAddressListener listener) {
        this.mListeners.add(listener);
        if (!this.resolveAddresses()) {
            this.notifyListener(listener);
        }
    }

    private synchronized void notifyListener(InetAddressListener listener) {
        if (this.mResolutionResults instanceof UnknownHostException) {
            listener.unknown((UnknownHostException)this.mResolutionResults);
        } else {
            InetAddress[] addresses = (InetAddress[])this.mResolutionResults;
            addresses = (InetAddress[])addresses.clone();
            listener.resolved(addresses);
        }
    }

    private synchronized boolean resolveAddresses() {
        boolean changed;
        try {
            Object[] addresses = InetAddress.getAllByName(this.mHost);
            if (this.mResolutionResults instanceof UnknownHostException) {
                changed = true;
            } else {
                Arrays.sort(addresses, new Comparator(){

                    public int compare(Object a, Object b) {
                        return ((InetAddress)a).getHostAddress().compareTo(((InetAddress)b).getHostAddress());
                    }
                });
                changed = !Arrays.equals(addresses, (InetAddress[])this.mResolutionResults);
            }
            this.mResolutionResults = addresses;
        }
        catch (UnknownHostException e) {
            changed = !(this.mResolutionResults instanceof UnknownHostException);
            this.mResolutionResults = e;
        }
        if (changed) {
            int size = this.mListeners.size();
            for (int i = 0; i < size; ++i) {
                this.notifyListener((InetAddressListener)this.mListeners.get(i));
            }
        }
        return changed;
    }

    static {
        cResolvers = new SoftHashMap();
    }

    private class Resolver
    extends TimerTask {
        private final Reference mOwner;

        public Resolver(InetAddressResolver owner) {
            this.mOwner = new WeakReference<InetAddressResolver>(owner);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            InetAddressResolver owner = (InetAddressResolver)this.mOwner.get();
            if (owner == null) {
                this.cancel();
            }
            Thread t = Thread.currentThread();
            String originalName = t.getName();
            t.setName("InetAddressResolver:" + owner.mHost);
            try {
                owner.resolveAddresses();
            }
            finally {
                t.setName(originalName);
            }
        }
    }
}

