/*
 * Decompiled with CFR 0.152.
 */
package org.teatrove.trove.net;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.TreeMap;
import org.teatrove.trove.io.CharToByteBuffer;
import org.teatrove.trove.io.DefaultByteBuffer;
import org.teatrove.trove.io.FastCharToByteBuffer;
import org.teatrove.trove.io.InternedCharToByteBuffer;
import org.teatrove.trove.net.HttpUtils;

public class HttpHeaderMap
implements Map,
Serializable {
    private static final TimeZone GMT_ZONE = TimeZone.getTimeZone("GMT");
    private static final DateFormat DATE_PARSER_1 = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss", Locale.US);
    private static final DateFormat DATE_PARSER_2;
    private static final String[] DAYS;
    private static final String[] MONTHS;
    private static final int MAX_HEADER_LENGTH = 10240;
    private Map mMap = new TreeMap(String.CASE_INSENSITIVE_ORDER);

    private static void appendDate(CharToByteBuffer buffer, Date d) throws IOException {
        GregorianCalendar c = new GregorianCalendar(GMT_ZONE, Locale.US);
        c.setTime(d);
        buffer.append(DAYS[c.get(7)]);
        buffer.append(", ");
        HttpHeaderMap.append2Digit(buffer, c.get(5));
        buffer.append(' ');
        buffer.append(MONTHS[c.get(2)]);
        buffer.append(' ');
        HttpHeaderMap.append4Digit(buffer, c.get(1));
        buffer.append(' ');
        HttpHeaderMap.append2Digit(buffer, c.get(11));
        buffer.append(':');
        HttpHeaderMap.append2Digit(buffer, c.get(12));
        buffer.append(':');
        HttpHeaderMap.append2Digit(buffer, c.get(13));
        buffer.append(" GMT");
    }

    private static void append2Digit(CharToByteBuffer buffer, int val) throws IOException {
        buffer.append((char)(val / 10 + 48));
        buffer.append((char)(val % 10 + 48));
    }

    private static void append4Digit(CharToByteBuffer buffer, int val) throws IOException {
        if (val < 1000 || val > 9999) {
            buffer.append(Integer.toString(val));
        } else {
            buffer.append((char)(val / 1000 + 48));
            buffer.append((char)(val / 100 % 10 + 48));
            buffer.append((char)(val / 10 % 10 + 48));
            buffer.append((char)(val % 10 + 48));
        }
    }

    public void readFrom(InputStream in) throws IOException {
        this.readFrom(in, new byte[80]);
    }

    public void readFrom(InputStream in, byte[] buffer) throws IOException {
        String header;
        while ((header = HttpUtils.readLine(in, buffer, 10240)) != null && header.length() != 0) {
            this.processHeaderLine(header);
        }
    }

    public void readFrom(InputStream in, char[] buffer) throws IOException {
        String header;
        while ((header = HttpUtils.readLine(in, buffer, 10240)) != null && header.length() != 0) {
            this.processHeaderLine(header);
        }
    }

    private void processHeaderLine(String header) {
        String value;
        String name;
        int index;
        block5: {
            index = header.indexOf(58);
            if (index < 0) {
                return;
            }
            name = header.substring(0, index);
            int length = header.length();
            do {
                if (++index < length) continue;
                value = "";
                break block5;
            } while (header.charAt(index) == ' ');
            value = header.substring(index);
        }
        if ("Cookie".equalsIgnoreCase(name) || "Set-Cookie".equalsIgnoreCase(name) || value.indexOf(44) == 3 && (value.startsWith("Mon") || value.startsWith("Tue") || value.startsWith("Wed") || value.startsWith("Thu") || value.startsWith("Fri") || value.startsWith("Sat") || value.startsWith("Sun"))) {
            this.add(name, value.trim());
        } else {
            while ((index = value.indexOf(44)) >= 0) {
                this.add(name, value.substring(0, index).trim());
                value = value.substring(index + 1);
            }
            this.add(name, value.trim());
        }
    }

    public void writeTo(OutputStream out) throws IOException {
        CharToByteBuffer buffer = new FastCharToByteBuffer(new DefaultByteBuffer(), "8859_1");
        buffer = new InternedCharToByteBuffer(buffer);
        this.appendTo(buffer);
        buffer.writeTo(out);
    }

    public void appendTo(CharToByteBuffer buffer) throws IOException {
        for (Map.Entry entry : this.mMap.entrySet()) {
            Object key = entry.getKey();
            Object value = entry.getValue();
            if (key == null || value == null) continue;
            String strKey = key.toString();
            if (value instanceof List) {
                Iterator values = ((List)value).iterator();
                if ("Set-Cookie".equalsIgnoreCase(strKey)) {
                    while (values.hasNext()) {
                        buffer.append(strKey);
                        buffer.append(": ");
                        value = values.next();
                        if (value instanceof Date) {
                            HttpHeaderMap.appendDate(buffer, (Date)value);
                        } else {
                            buffer.append(value.toString());
                        }
                        buffer.append("\r\n");
                    }
                    continue;
                }
                int count = 0;
                while (values.hasNext()) {
                    value = values.next();
                    if (count < 0) {
                        buffer.append("\r\n");
                        count = 0;
                    }
                    if (count++ == 0) {
                        buffer.append(strKey);
                        buffer.append(": ");
                    }
                    if (value instanceof Date) {
                        if (count > 1) {
                            buffer.append("\r\n");
                            buffer.append(strKey);
                            buffer.append(": ");
                        }
                        HttpHeaderMap.appendDate(buffer, (Date)value);
                        count = -1;
                        continue;
                    }
                    String strVal = value.toString();
                    if (strVal.indexOf(44) < 0) {
                        if (count > 1) {
                            buffer.append(',');
                        }
                        buffer.append(strVal);
                        continue;
                    }
                    if (count > 1) {
                        buffer.append("\r\n");
                        buffer.append(strKey);
                        buffer.append(": ");
                    }
                    buffer.append(strVal);
                    count = -1;
                }
                buffer.append("\r\n");
                continue;
            }
            buffer.append(strKey);
            buffer.append(": ");
            if (value instanceof Date) {
                HttpHeaderMap.appendDate(buffer, (Date)value);
            } else {
                buffer.append(value.toString());
            }
            buffer.append("\r\n");
        }
    }

    @Override
    public int size() {
        return this.mMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.mMap.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.mMap.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        for (Object obj : this.mMap.values()) {
            if (obj instanceof List) {
                Iterator it2 = ((List)obj).iterator();
                if (!it2.hasNext()) continue;
                obj = it2.next();
                return value == null ? obj == null : value.equals(obj);
            }
            return value == null ? obj == null : value.equals(obj);
        }
        return false;
    }

    public Object get(Object key) {
        Object value = this.mMap.get(key);
        if (value instanceof List) {
            return ((List)value).get(0);
        }
        return value;
    }

    public String getString(Object key) {
        Object obj = this.get(key);
        if (obj instanceof String) {
            return (String)obj;
        }
        if (obj != null) {
            return obj.toString();
        }
        return null;
    }

    public Integer getInteger(Object key) {
        Object obj = this.get(key);
        if (obj instanceof Integer) {
            return (Integer)obj;
        }
        if (obj != null) {
            try {
                return new Integer(obj.toString());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Date getDate(Object key) {
        Date date;
        Object obj = this.get(key);
        if (obj instanceof Date) {
            return (Date)obj;
        }
        if (obj == null) {
            return null;
        }
        String val = obj.toString();
        int index = val.indexOf(59);
        if (index >= 0) {
            val = val.substring(0, index);
        }
        try {
            DateFormat dateFormat = DATE_PARSER_1;
            synchronized (dateFormat) {
                date = DATE_PARSER_1.parse(val);
            }
        }
        catch (ParseException e) {
            try {
                DateFormat dateFormat = DATE_PARSER_2;
                synchronized (dateFormat) {
                    date = DATE_PARSER_2.parse(val);
                }
            }
            catch (ParseException e2) {
                return null;
            }
        }
        return date;
    }

    public List getAll(Object key) {
        Object value = this.mMap.get(key);
        if (value instanceof List) {
            return (List)value;
        }
        ArrayList list = new ArrayList();
        if (value != null || this.mMap.containsKey(key)) {
            list.add(value);
        }
        this.mMap.put(key, list);
        return list;
    }

    public Object put(Object key, Object value) {
        if (value instanceof List) {
            return this.mMap.put(key, new ArrayList((List)value));
        }
        return this.mMap.put(key, value);
    }

    public void add(Object key, Object value) {
        Object existing = this.mMap.get(key);
        if (existing instanceof List) {
            if (value instanceof List) {
                ((List)existing).addAll((List)value);
            } else {
                ((List)existing).add(value);
            }
        } else if (existing == null && !this.mMap.containsKey(key)) {
            if (value instanceof List) {
                this.mMap.put(key, new ArrayList((List)value));
            } else {
                this.mMap.put(key, value);
            }
        } else {
            ArrayList<Object> list = new ArrayList<Object>();
            list.add(existing);
            if (value instanceof List) {
                list.addAll((List)value);
            } else {
                list.add(value);
            }
            this.mMap.put(key, list);
        }
    }

    public Object remove(Object key) {
        return this.mMap.remove(key);
    }

    public void putAll(Map map) {
        this.mMap.putAll(map);
    }

    @Override
    public void clear() {
        this.mMap.clear();
    }

    public Set keySet() {
        return this.mMap.keySet();
    }

    public Collection values() {
        return this.mMap.values();
    }

    public Set entrySet() {
        return this.mMap.entrySet();
    }

    @Override
    public boolean equals(Object obj) {
        return ((Object)this.mMap).equals(obj);
    }

    @Override
    public int hashCode() {
        return ((Object)this.mMap).hashCode();
    }

    public String toString() {
        return super.toString() + ":" + this.mMap.toString();
    }

    static {
        DATE_PARSER_1.setTimeZone(GMT_ZONE);
        DATE_PARSER_1.setLenient(true);
        DATE_PARSER_2 = new SimpleDateFormat("EEEE, dd-MMM-yy HH:mm:ss", Locale.US);
        DATE_PARSER_2.setTimeZone(GMT_ZONE);
        DATE_PARSER_2.setLenient(true);
        DateFormatSymbols symbols = new DateFormatSymbols(Locale.US);
        DAYS = symbols.getShortWeekdays();
        MONTHS = symbols.getShortMonths();
    }
}

