/*
 * Decompiled with CFR 0.152.
 */
package org.teatrove.trove.net;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.net.SocketException;
import org.teatrove.trove.net.SocketFace;

public class CheckedSocketException
extends SocketException {
    private Exception mCause;
    private String mMessagePrefix;
    private Reference mSource;

    static CheckedSocketException create(Exception cause, SocketFace source) {
        if (cause instanceof CheckedSocketException) {
            return (CheckedSocketException)cause;
        }
        return new CheckedSocketException(cause, source);
    }

    static CheckedSocketException create(Exception cause, SocketFace source, String message) {
        if (cause instanceof CheckedSocketException) {
            return (CheckedSocketException)cause;
        }
        return new CheckedSocketException(cause, source, message);
    }

    static String createMessagePrefix(SocketFace source) {
        String localAddr = source.getLocalAddress() == null ? "null" : source.getLocalAddress().getHostAddress();
        String remoteAddr = source.getInetAddress() == null ? "null" : source.getInetAddress().getHostAddress();
        return "[" + localAddr + ':' + source.getLocalPort() + ',' + remoteAddr + ':' + source.getPort() + ']';
    }

    private CheckedSocketException(Exception cause, SocketFace source) {
        this(cause, source, cause.getMessage());
    }

    private CheckedSocketException(Exception cause, SocketFace source, String message) {
        super(CheckedSocketException.createMessagePrefix(source) + ' ' + message);
        this.mCause = cause;
        this.mMessagePrefix = CheckedSocketException.createMessagePrefix(source);
        this.mSource = new WeakReference<SocketFace>(source);
    }

    @Override
    public Throwable getCause() {
        return this.mCause;
    }

    public SocketFace getSource() {
        return (SocketFace)this.mSource.get();
    }

    @Override
    public void printStackTrace() {
        this.printStackTrace(System.err);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void printStackTrace(PrintStream ps) {
        PrintStream printStream = ps;
        synchronized (printStream) {
            ps.print(this.mMessagePrefix);
            ps.print(": ");
            this.mCause.printStackTrace(ps);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void printStackTrace(PrintWriter pw) {
        PrintWriter printWriter = pw;
        synchronized (printWriter) {
            pw.print(this.mMessagePrefix);
            pw.print(": ");
            this.mCause.printStackTrace(pw);
        }
    }
}

