/*
 * Decompiled with CFR 0.152.
 */
package org.teatrove.trove.net;

import java.io.InterruptedIOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import org.teatrove.trove.net.CheckedSocketException;
import org.teatrove.trove.net.SocketFace;

public class CheckedInterruptedIOException
extends InterruptedIOException {
    private InterruptedIOException mCause;
    private String mMessagePrefix;
    private Reference mSource;

    static CheckedInterruptedIOException create(InterruptedIOException cause, SocketFace source) {
        if (cause instanceof CheckedInterruptedIOException) {
            return (CheckedInterruptedIOException)cause;
        }
        return new CheckedInterruptedIOException(cause, source);
    }

    private CheckedInterruptedIOException(InterruptedIOException cause, SocketFace source) {
        this(cause, source, cause.getMessage());
    }

    private CheckedInterruptedIOException(InterruptedIOException cause, SocketFace source, String message) {
        super(CheckedSocketException.createMessagePrefix(source) + ' ' + message);
        this.mCause = cause;
        this.mMessagePrefix = CheckedSocketException.createMessagePrefix(source);
        this.mSource = new WeakReference<SocketFace>(source);
    }

    @Override
    public Throwable getCause() {
        return this.mCause;
    }

    public SocketFace getSource() {
        return (SocketFace)this.mSource.get();
    }

    @Override
    public void printStackTrace() {
        this.printStackTrace(System.err);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void printStackTrace(PrintStream ps) {
        PrintStream printStream = ps;
        synchronized (printStream) {
            ps.print(this.mMessagePrefix);
            ps.print(": ");
            this.mCause.printStackTrace(ps);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void printStackTrace(PrintWriter pw) {
        PrintWriter printWriter = pw;
        synchronized (printWriter) {
            pw.print(this.mMessagePrefix);
            pw.print(": ");
            this.mCause.printStackTrace(pw);
        }
    }
}

