/*
 * Decompiled with CFR 0.152.
 */
package org.teatrove.trove.log;

import java.io.PrintStream;
import org.teatrove.trove.log.Log;
import org.teatrove.trove.log.LogEvent;
import org.teatrove.trove.log.LogEventParsingOutputStream;
import org.teatrove.trove.log.LogListener;

public class Syslog {
    private static final Log cLog = new Log(null, null);
    private static final LogListener cSystemLogEventPrinter;
    private static LogEventParsingOutputStream cSystemOut;
    private static LogEventParsingOutputStream cSystemErr;
    private static PrintStream cOriginalOut;
    private static PrintStream cOriginalErr;
    private static boolean cInstalled;

    public static Log log() {
        return cLog;
    }

    public static LogListener getSystemLogEventPrinter() {
        return cSystemLogEventPrinter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void install() {
        Log log = Syslog.log();
        synchronized (log) {
            if (!cInstalled) {
                cInstalled = true;
                cOriginalOut = System.out;
                cOriginalErr = System.err;
                cSystemOut = new LogEventParsingOutputStream(Syslog.log(), 2){

                    @Override
                    public boolean isEnabled() {
                        return Syslog.log().isInfoEnabled();
                    }
                };
                cSystemOut.addLogListener(Syslog.log());
                System.setOut(new PrintStream(cSystemOut, true));
                cSystemErr = new LogEventParsingOutputStream(Syslog.log(), 4){

                    @Override
                    public boolean isEnabled() {
                        return Syslog.log().isErrorEnabled();
                    }
                };
                cSystemErr.addLogListener(Syslog.log());
                System.setErr(new PrintStream(cSystemErr, true));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void uninstall() {
        Log log = Syslog.log();
        synchronized (log) {
            if (cInstalled) {
                cInstalled = false;
                System.setOut(cOriginalOut);
                System.setErr(cOriginalErr);
                cOriginalOut = null;
                cOriginalErr = null;
                cSystemOut = null;
                cSystemErr = null;
            }
        }
    }

    public static void debug(String s) {
        Syslog.log().debug(s);
    }

    public static void debug(Throwable t) {
        Syslog.log().debug(t);
    }

    public static void info(String s) {
        Syslog.log().info(s);
    }

    public static void info(Throwable t) {
        Syslog.log().info(t);
    }

    public static void warn(String s) {
        Syslog.log().warn(s);
    }

    public static void warn(Throwable t) {
        Syslog.log().warn(t);
    }

    public static void error(String s) {
        Syslog.log().error(s);
    }

    public static void error(Throwable t) {
        Syslog.log().error(t);
    }

    private Syslog() {
    }

    static {
        cLog.setDescription("System Log");
        cSystemLogEventPrinter = new LogListener(){

            @Override
            public void logMessage(LogEvent e) {
                PrintStream ps = this.getPrintStream(e);
                String message = e.getMessage();
                if (message == null) {
                    ps.println();
                } else {
                    ps.println(message);
                }
            }

            @Override
            public void logException(LogEvent e) {
                Throwable t = e.getException();
                if (t == null) {
                    this.logMessage(e);
                } else {
                    t.printStackTrace(this.getPrintStream(e));
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private PrintStream getPrintStream(LogEvent e) {
                Log log = Syslog.log();
                synchronized (log) {
                    switch (e.getType()) {
                        case 1: 
                        case 2: {
                            return cInstalled ? cOriginalOut : System.out;
                        }
                    }
                    return cInstalled ? cOriginalErr : System.err;
                }
            }
        };
        Syslog.log().addLogListener(cSystemLogEventPrinter);
    }
}

