/*
 * Decompiled with CFR 0.152.
 */
package org.teatrove.trove.log;

import java.io.PrintWriter;
import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.TimeZone;
import org.teatrove.trove.log.Log;
import org.teatrove.trove.log.LogEvent;
import org.teatrove.trove.log.LogListener;
import org.teatrove.trove.util.FastDateFormat;

public class LogScribe
implements LogListener {
    private PrintWriter mWriter;
    private DateFormat mSlowFormat;
    private FastDateFormat mFastFormat;
    private boolean mShowThread = true;
    private boolean mShowSourceName = true;

    public LogScribe(PrintWriter writer) {
        this(writer, (FastDateFormat)null);
    }

    public LogScribe(PrintWriter writer, DateFormat format) {
        this.mWriter = writer;
        this.mSlowFormat = format;
        if (format == null) {
            this.mFastFormat = FastDateFormat.getInstance("yyyy/MM/dd HH:mm:ss.SSS z");
        } else if (format instanceof SimpleDateFormat) {
            SimpleDateFormat simple = (SimpleDateFormat)format;
            String pattern = simple.toPattern();
            TimeZone timeZone = simple.getTimeZone();
            DateFormatSymbols symbols = simple.getDateFormatSymbols();
            this.mFastFormat = FastDateFormat.getInstance(pattern, timeZone, null, symbols);
        }
    }

    public LogScribe(PrintWriter writer, FastDateFormat format) {
        this.mWriter = writer;
        this.mSlowFormat = null;
        if (format == null) {
            format = FastDateFormat.getInstance("yyyy/MM/dd HH:mm:ss.SSS z");
        }
        this.mFastFormat = format;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void logMessage(LogEvent e) {
        String message = e.getMessage();
        if (message != null) {
            PrintWriter printWriter = this.mWriter;
            synchronized (printWriter) {
                this.mWriter.print(this.createPrepend(e));
                this.mWriter.println(message);
                this.mWriter.flush();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void logException(LogEvent e) {
        Throwable t = e.getException();
        if (t == null) {
            this.logMessage(e);
        } else {
            PrintWriter printWriter = this.mWriter;
            synchronized (printWriter) {
                this.mWriter.print(this.createPrepend(e));
                t.printStackTrace(this.mWriter);
                this.mWriter.flush();
            }
        }
    }

    public boolean isShowThreadEnabled() {
        return this.mShowThread;
    }

    public void setShowThreadEnabled(boolean enabled) {
        this.mShowThread = enabled;
    }

    public boolean isShowSourceEnabled() {
        return this.mShowSourceName;
    }

    public void setShowSourceEnabled(boolean enabled) {
        this.mShowSourceName = enabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String createPrepend(LogEvent e) {
        String sourceName;
        Log source;
        StringBuffer pre = new StringBuffer(80);
        String code = "??";
        switch (e.getType()) {
            case 1: {
                code = " D";
                break;
            }
            case 2: {
                code = " I";
                break;
            }
            case 3: {
                code = "*W";
                break;
            }
            case 4: {
                code = "*E";
            }
        }
        pre.append(code);
        pre.append(',');
        if (this.mFastFormat != null) {
            pre.append(this.mFastFormat.format(e.getTimestamp()));
        } else {
            DateFormat dateFormat = this.mSlowFormat;
            synchronized (dateFormat) {
                pre.append(this.mSlowFormat.format(e.getTimestamp()));
            }
        }
        if (this.isShowThreadEnabled()) {
            pre.append(',');
            pre.append(e.getThreadName());
        }
        if (this.isShowSourceEnabled() && (source = e.getLogSource()) != null && (sourceName = source.getName()) != null) {
            pre.append(',');
            pre.append(sourceName);
        }
        pre.append('>');
        pre.append(' ');
        return pre.toString();
    }
}

