/*
 * Decompiled with CFR 0.152.
 */
package org.teatrove.trove.log;

import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;
import org.teatrove.trove.log.Log;
import org.teatrove.trove.log.LogEvent;
import org.teatrove.trove.log.LogListener;

public class LogEventParsingWriter
extends Writer {
    private Vector mListeners = new Vector(2);
    private Log mSource;
    private int mType;
    private CharArrayWriter mMessageBuffer;
    private Thread mMessageThread;
    private Date mTimestamp;
    private boolean mTrackLF;

    public LogEventParsingWriter(Log source, int type) {
        this.mSource = source;
        this.mType = type;
        this.mMessageBuffer = new CharArrayWriter();
    }

    public LogEventParsingWriter(Log source, int type, Object lock) {
        super(lock);
        this.mSource = source;
        this.mType = type;
        this.mMessageBuffer = new CharArrayWriter();
    }

    public void addLogListener(LogListener listener) {
        this.mListeners.addElement(listener);
    }

    public void removeLogListener(LogListener listener) {
        this.mListeners.removeElement(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushLogEvent() {
        Object object = this.lock;
        synchronized (object) {
            LogEvent e;
            if (this.mMessageThread == null) {
                return;
            }
            String message = this.mMessageBuffer.toString();
            if (this.mMessageBuffer.size() > 10000) {
                this.mMessageBuffer = new CharArrayWriter();
            } else {
                this.mMessageBuffer.reset();
            }
            if (this.mTimestamp == null) {
                e = new LogEvent(this.mSource, this.mType, message, this.mMessageThread);
            } else {
                e = new LogEvent(this.mSource, this.mType, message, this.mMessageThread, this.mTimestamp);
                this.mTimestamp = null;
            }
            Vector vector = this.mListeners;
            synchronized (vector) {
                Enumeration en = this.mListeners.elements();
                while (en.hasMoreElements()) {
                    ((LogListener)en.nextElement()).logMessage(e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(char[] array, int off, int len) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (!this.isEnabled()) {
                if (this.mMessageBuffer.size() > 0) {
                    this.flushLogEvent();
                }
                return;
            }
            Thread current = Thread.currentThread();
            if (current != this.mMessageThread) {
                if (this.mMessageBuffer.size() > 0) {
                    this.flushLogEvent();
                }
                this.mMessageThread = current;
            }
            int writtenLength = 0;
            int i = 0;
            for (i = 0; i < len; ++i) {
                char c = array[i + off];
                if (c == '\r') {
                    this.mTrackLF = true;
                    this.writeToBuffer(array, writtenLength + off, i - writtenLength);
                    writtenLength = i + 1;
                    this.flushLogEvent();
                    continue;
                }
                if (c == '\n') {
                    if (this.mTrackLF) {
                        this.mTrackLF = false;
                        ++writtenLength;
                        continue;
                    }
                    this.writeToBuffer(array, writtenLength + off, i - writtenLength);
                    writtenLength = i + 1;
                    this.flushLogEvent();
                    continue;
                }
                this.mTrackLF = false;
            }
            this.writeToBuffer(array, writtenLength + off, i - writtenLength);
        }
    }

    @Override
    public void flush() throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.mMessageBuffer.close();
        }
    }

    public boolean isEnabled() {
        return true;
    }

    private void writeToBuffer(char[] array, int off, int len) {
        if (this.mMessageBuffer.size() == 0) {
            this.mTimestamp = new Date();
        }
        this.mMessageBuffer.write(array, off, len);
    }
}

