/*
 * Decompiled with CFR 0.152.
 */
package org.teatrove.trove.log;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.ref.WeakReference;
import java.util.Date;
import java.util.EventObject;
import org.teatrove.trove.log.Log;

public class LogEvent
extends EventObject {
    public static final int DEBUG_TYPE = 1;
    public static final int INFO_TYPE = 2;
    public static final int WARN_TYPE = 3;
    public static final int ERROR_TYPE = 4;
    private int mType;
    private Date mTimestamp;
    private String mMessage;
    private Throwable mThrowable;
    private String mThreadName;
    private transient WeakReference mThread;

    public LogEvent(Log log, int type, String message, Throwable throwable, Thread thread, Date timestamp) {
        super(log);
        if (type < 1 || type > 4) {
            throw new IllegalArgumentException("Type out of range: " + type);
        }
        this.mType = type;
        if (message == null) {
            if (throwable != null) {
                this.mMessage = throwable.getMessage();
            }
        } else {
            this.mMessage = message;
        }
        this.mThrowable = throwable;
        this.mThread = thread == null ? new WeakReference<Thread>(Thread.currentThread()) : new WeakReference<Thread>(thread);
        this.mTimestamp = timestamp == null ? new Date() : timestamp;
    }

    public LogEvent(Log log, int type, String message, Thread thread, Date timestamp) {
        this(log, type, message, null, thread, timestamp);
    }

    public LogEvent(Log log, int type, Throwable throwable, Thread thread, Date timestamp) {
        this(log, type, null, throwable, thread, timestamp);
    }

    public LogEvent(Log log, int type, String message, Thread thread) {
        this(log, type, message, null, thread, null);
    }

    public LogEvent(Log log, int type, Throwable throwable, Thread thread) {
        this(log, type, null, throwable, thread, null);
    }

    public LogEvent(Log log, int type, String message, Throwable throwable) {
        this(log, type, message, throwable, null, null);
    }

    public LogEvent(Log log, int type, String message) {
        this(log, type, message, null, null, null);
    }

    public LogEvent(Log log, int type, Throwable throwable) {
        this(log, type, null, throwable, null, null);
    }

    public Log getLogSource() {
        return (Log)this.getSource();
    }

    public int getType() {
        return this.mType;
    }

    public Date getTimestamp() {
        return this.mTimestamp;
    }

    public String getMessage() {
        return this.mMessage;
    }

    public void setMessage(String message) {
        this.mMessage = message;
    }

    public Throwable getException() {
        return this.mThrowable;
    }

    public String getExceptionStackTrace() {
        Throwable t = this.getException();
        if (t == null) {
            return null;
        }
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        t.printStackTrace(pw);
        return sw.toString();
    }

    public String getThreadName() {
        Thread t;
        if (this.mThreadName == null && (t = this.getThread()) != null) {
            this.mThreadName = t.getName();
        }
        return this.mThreadName;
    }

    public Thread getThread() {
        return (Thread)this.mThread.get();
    }

    @Override
    public String toString() {
        String msg = this.getMessage() == null ? "null" : '\"' + this.getMessage() + '\"';
        return this.getClass().getName() + "[" + this.getTimestamp() + ',' + this.getThreadName() + ',' + msg + "] from " + this.getSource();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        this.getThreadName();
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
    }
}

