/*
 * Decompiled with CFR 0.152.
 */
package org.teatrove.trove.log;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.ref.WeakReference;
import java.util.Calendar;
import java.util.Date;

public abstract class IntervalLogStream
extends OutputStream {
    private static int cCounter;
    private Factory mFactory;
    private OutputStream mOut;
    private boolean mIsClosed;
    private Calendar mIntervalStart;
    private Calendar mNextIntervalStart;
    private Thread mRolloverThread;

    private static synchronized String nextName() {
        return "IntervalLogStream Auto Rollover " + cCounter++;
    }

    public IntervalLogStream(Factory factory) {
        this.mFactory = factory;
    }

    public synchronized void startAutoRollover() {
        if (this.mRolloverThread == null) {
            this.mRolloverThread = new Thread((Runnable)new AutoRollover(this), IntervalLogStream.nextName());
            this.mRolloverThread.setDaemon(true);
            this.mRolloverThread.start();
        }
    }

    public synchronized void stopAutoRollover() {
        if (this.mRolloverThread != null) {
            this.mRolloverThread.interrupt();
            this.mRolloverThread = null;
        }
    }

    protected abstract void moveToIntervalStart(Calendar var1);

    protected abstract void moveToNextIntervalStart(Calendar var1);

    @Override
    public synchronized void write(int b) throws IOException {
        this.getOutputStream().write(b);
    }

    @Override
    public synchronized void write(byte[] array) throws IOException {
        this.getOutputStream().write(array, 0, array.length);
    }

    @Override
    public synchronized void write(byte[] array, int off, int len) throws IOException {
        this.getOutputStream().write(array, off, len);
    }

    @Override
    public synchronized void flush() throws IOException {
        this.getOutputStream().flush();
    }

    @Override
    public synchronized void close() throws IOException {
        this.mIsClosed = true;
        this.stopAutoRollover();
        if (this.mOut != null) {
            this.mOut.close();
        }
    }

    protected synchronized void finalize() throws IOException {
        this.close();
    }

    private synchronized OutputStream getOutputStream() throws IOException {
        if (this.mIsClosed) {
            throw new IOException("LogStream is closed");
        }
        Calendar cal = Calendar.getInstance();
        if (this.mOut == null || cal.before(this.mIntervalStart) || !cal.before(this.mNextIntervalStart)) {
            if (this.mOut != null) {
                this.mOut.close();
            }
            this.mOut = new BufferedOutputStream(this.mFactory.openOutputStream(cal.getTime()));
            this.setIntervalEndpoints(cal);
        }
        return this.mOut;
    }

    private void setIntervalEndpoints(Calendar cal) {
        this.mIntervalStart = (Calendar)cal.clone();
        this.moveToIntervalStart(this.mIntervalStart);
        this.mNextIntervalStart = cal;
        this.moveToNextIntervalStart(this.mNextIntervalStart);
    }

    private static class AutoRollover
    implements Runnable {
        private WeakReference mLogStream;

        public AutoRollover(IntervalLogStream stream) {
            this.mLogStream = new WeakReference<IntervalLogStream>(stream);
        }

        @Override
        public void run() {
            try {
                IntervalLogStream stream;
                while (!Thread.interrupted() && (stream = (IntervalLogStream)this.mLogStream.get()) != null && !stream.mIsClosed) {
                    try {
                        stream.getOutputStream();
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                    Calendar cal = Calendar.getInstance();
                    stream.moveToNextIntervalStart(cal);
                    stream = null;
                    long calTime = cal.getTime().getTime();
                    long timeLeft = calTime - System.currentTimeMillis();
                    while (timeLeft > 0L) {
                        Thread.sleep(timeLeft);
                        timeLeft = calTime - System.currentTimeMillis();
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public static interface Factory {
        public OutputStream openOutputStream(Date var1) throws IOException;
    }
}

