/*
 * Decompiled with CFR 0.152.
 */
package org.teatrove.trove.log;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.DateFormat;
import java.util.Date;
import org.teatrove.trove.log.IntervalLogStream;

public class FileLogStreamFactory
implements IntervalLogStream.Factory {
    private File mDirectory;
    private DateFormat mDateFormat;
    private String mExtension;

    public FileLogStreamFactory(File directory, DateFormat format, String extension) {
        if (directory == null) {
            throw new NullPointerException("FileLogStreamFactory directory not specified");
        }
        try {
            this.mDirectory = new File(directory.getCanonicalPath());
        }
        catch (IOException e) {
            this.mDirectory = directory;
        }
        if (format == null) {
            throw new NullPointerException("FileLogStreamFactory date format not specified");
        }
        this.mDateFormat = format;
        this.mExtension = extension == null ? "" : extension;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OutputStream openOutputStream(Date date) throws IOException {
        if (!this.mDirectory.exists() && !this.mDirectory.mkdirs()) {
            throw new IOException("Unable to create directory: \"" + this.mDirectory + '\"');
        }
        String fileName = this.mDirectory.getName() + '-';
        DateFormat dateFormat = this.mDateFormat;
        synchronized (dateFormat) {
            fileName = fileName + this.mDateFormat.format(date);
        }
        File file = new File(this.mDirectory, fileName + this.mExtension);
        return new FileOutputStream(file.getPath(), true);
    }
}

