/*
 * Decompiled with CFR 0.152.
 */
package org.teatrove.trove.io;

import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.teatrove.trove.io.PushbackPositionReader;
import org.teatrove.trove.io.TagReader;
import org.teatrove.trove.io.UnicodeReader;

public class SourceReader
extends PushbackPositionReader {
    public static final int ENTER_CODE = -2;
    public static final int ENTER_TEXT = -3;
    private UnicodeReader mUnicodeReader = (UnicodeReader)this.in;
    private TagReader mTagReader = (TagReader)this.mUnicodeReader.getOriginalSource();
    private boolean mClosed = false;
    private int mLine = 1;
    private int mFirst;
    private String mBeginTag;
    private String mEndTag;

    private static Reader createReader(Reader source, String beginTag, String endTag) {
        String[] tags = new String[4];
        int[] codes = new int[4];
        int i = 0;
        tags[i] = "\r\n";
        codes[i++] = 10;
        tags[i] = "\r";
        codes[i++] = 10;
        if (beginTag != null && beginTag.length() > 0) {
            tags[i] = beginTag;
            codes[i++] = -2;
        }
        if (endTag != null && endTag.length() > 0) {
            tags[i] = endTag;
            codes[i++] = -3;
        }
        if (i < 4) {
            String[] newTags = new String[i];
            System.arraycopy(tags, 0, newTags, 0, i);
            tags = newTags;
            int[] newCodes = new int[i];
            System.arraycopy(codes, 0, newCodes, 0, i);
            codes = newCodes;
        }
        return new UnicodeReader(new TagReader(source, tags, codes));
    }

    public SourceReader(Reader source, String beginTag, String endTag) {
        this(source, beginTag, endTag, false);
    }

    public SourceReader(Reader source, String beginTag, String endTag, boolean inCode) {
        super(SourceReader.createReader(source, beginTag, endTag), 2);
        boolean codeMode = beginTag == null || beginTag.length() == 0 || inCode;
        this.mFirst = codeMode ? -2 : -3;
        this.mBeginTag = beginTag;
        this.mEndTag = endTag;
    }

    public String getBeginTag() {
        return this.mBeginTag;
    }

    public String getEndTag() {
        return this.mEndTag;
    }

    @Override
    public int read() throws IOException {
        int c;
        if (this.mFirst != 0) {
            c = this.mFirst;
            this.mFirst = 0;
        } else {
            c = super.read();
        }
        if (c == 10) {
            ++this.mLine;
        } else if (c == -2) {
            this.mUnicodeReader.setEscapesEnabled(true);
        } else if (c == -3) {
            this.mUnicodeReader.setEscapesEnabled(false);
        }
        return c;
    }

    public int getLineNumber() {
        return this.mLine;
    }

    public int getEndPosition() {
        int e = this.getNextPosition() - 1;
        return e < this.getStartPosition() ? this.getStartPosition() : e;
    }

    public void ignoreTags(boolean ignore) {
        this.mTagReader.setEscapesEnabled(!ignore);
    }

    public boolean isClosed() {
        return this.mClosed;
    }

    @Override
    public void close() throws IOException {
        this.mClosed = true;
        super.close();
    }

    @Override
    protected void unreadHook(int c) {
        if (c == 10) {
            --this.mLine;
        } else if (c == -2) {
            this.mUnicodeReader.setEscapesEnabled(false);
        } else if (c == -3) {
            this.mUnicodeReader.setEscapesEnabled(true);
        }
    }

    public static void main(String[] arg) throws Exception {
        Tester.test(arg);
    }

    private static class Tester {
        private Tester() {
        }

        public static void test(String[] arg) throws Exception {
            int c;
            Reader reader;
            String str = "This is \\u0061 test.\nThis is \\u00612 test.\nThis is \\u0061\\u0061 test.\nThis is \\u061 test.\nThis is \\\\u0061 test.\nThis is \\a test.\nPlain text <%put code here%> plain text.\nPlain text <\\u0025put code here%> plain text.\nPlain text <%put code here\\u0025> plain text.\n";
            if (arg.length > 0) {
                reader = new FileReader(arg[0]);
            } else {
                int c2;
                System.out.println("\nOriginal:\n");
                reader = new StringReader(str);
                while ((c2 = reader.read()) != -1) {
                    System.out.print((char)c2);
                }
            }
            System.out.println("\nTest 1:\n");
            reader = arg.length > 0 ? new FileReader(arg[0]) : new StringReader(str);
            SourceReader sr = new SourceReader(reader, "<%", "%>");
            while ((c = sr.read()) != -1) {
                System.out.print((char)c);
                System.out.print("\t" + c);
                System.out.print("\t" + sr.getLineNumber());
                System.out.print("\t" + sr.getStartPosition());
                System.out.println("\t" + sr.getEndPosition());
            }
            System.out.println("\nTest 2:\n");
            reader = arg.length > 0 ? new FileReader(arg[0]) : new StringReader(str);
            sr = new SourceReader(reader, null, null);
            while ((c = sr.read()) != -1) {
                System.out.print((char)c);
                System.out.print("\t" + c);
                System.out.print("\t" + sr.getLineNumber());
                System.out.print("\t" + sr.getStartPosition());
                System.out.println("\t" + sr.getEndPosition());
            }
        }
    }
}

