/*
 * Decompiled with CFR 0.152.
 */
package org.teatrove.trove.io;

import java.io.FilterReader;
import java.io.IOException;
import java.io.Reader;

public class PositionReader
extends FilterReader {
    protected PositionReader mPosReader;
    protected int mPosition = 0;
    private boolean mClosed = false;

    public PositionReader(Reader reader) {
        super(reader);
        if (reader instanceof PositionReader) {
            this.mPosReader = (PositionReader)reader;
        }
    }

    public int getNextPosition() {
        return this.mPosition;
    }

    @Override
    public int read() throws IOException {
        try {
            int c = this.in.read();
            if (c != -1) {
                this.mPosition = this.mPosReader == null ? ++this.mPosition : this.mPosReader.getNextPosition();
            } else {
                this.close();
            }
            return c;
        }
        catch (IOException e) {
            if (this.mClosed) {
                return -1;
            }
            throw e;
        }
    }

    @Override
    public int read(char[] buf, int off, int length) throws IOException {
        int i = 0;
        while (i < length) {
            int c = this.read();
            if (c == -1) {
                return i == 0 ? -1 : i;
            }
            buf[i++ + off] = (char)c;
        }
        return i;
    }

    @Override
    public void close() throws IOException {
        this.mClosed = true;
        super.close();
    }
}

