/*
 * Decompiled with CFR 0.152.
 */
package org.teatrove.trove.io;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import org.teatrove.trove.io.ByteBuffer;
import org.teatrove.trove.io.ByteData;
import org.teatrove.trove.io.CharToByteBuffer;
import org.teatrove.trove.util.IdentityMap;

public class InternedCharToByteBuffer
implements CharToByteBuffer,
Serializable {
    private static final int MIN_LENGTH = 40;
    private static final Object MARKER = new Object();
    private static Map cEncodings = new HashMap(7);
    private static Random cLastRandom = new Random();
    private CharToByteBuffer mBuffer;
    private Random mRandom;
    private transient Map mConvertedCache;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map getConvertedCache(String encoding) {
        Map map = cEncodings;
        synchronized (map) {
            Map cache = (Map)cEncodings.get(encoding);
            if (cache == null) {
                cache = Collections.synchronizedMap(new IdentityMap());
                cEncodings.put(encoding, cache);
            }
            return cache;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Random getRandom() {
        Random random = cLastRandom;
        synchronized (random) {
            cLastRandom = new Random(cLastRandom.nextLong());
            return cLastRandom;
        }
    }

    public InternedCharToByteBuffer(CharToByteBuffer buffer) throws IOException {
        this.mBuffer = buffer;
        this.mConvertedCache = InternedCharToByteBuffer.getConvertedCache(buffer.getEncoding());
    }

    @Override
    public void setEncoding(String enc) throws IOException {
        this.mBuffer.setEncoding(enc);
        this.mConvertedCache = InternedCharToByteBuffer.getConvertedCache(this.mBuffer.getEncoding());
    }

    @Override
    public String getEncoding() throws IOException {
        return this.mBuffer.getEncoding();
    }

    @Override
    public long getBaseByteCount() throws IOException {
        return this.mBuffer.getBaseByteCount();
    }

    @Override
    public long getByteCount() throws IOException {
        return this.mBuffer.getByteCount();
    }

    @Override
    public void writeTo(OutputStream out) throws IOException {
        this.mBuffer.writeTo(out);
    }

    @Override
    public void append(byte b) throws IOException {
        this.mBuffer.append(b);
    }

    @Override
    public void append(byte[] bytes) throws IOException {
        this.mBuffer.append(bytes);
    }

    @Override
    public void append(byte[] bytes, int offset, int length) throws IOException {
        this.mBuffer.append(bytes, offset, length);
    }

    @Override
    public void appendSurrogate(ByteData s) throws IOException {
        this.mBuffer.appendSurrogate(s);
    }

    @Override
    public void addCaptureBuffer(ByteBuffer buffer) throws IOException {
        this.mBuffer.addCaptureBuffer(buffer);
    }

    @Override
    public void removeCaptureBuffer(ByteBuffer buffer) throws IOException {
        this.mBuffer.removeCaptureBuffer(buffer);
    }

    @Override
    public void append(char c) throws IOException {
        this.mBuffer.append(c);
    }

    @Override
    public void append(char[] chars) throws IOException {
        this.mBuffer.append(chars);
    }

    @Override
    public void append(char[] chars, int offset, int length) throws IOException {
        this.mBuffer.append(chars, offset, length);
    }

    @Override
    public void append(String str) throws IOException {
        if (str.length() < 40) {
            this.mBuffer.append(str);
            return;
        }
        this.mBuffer.append(str);
    }

    @Override
    public void append(String str, int offset, int length) throws IOException {
        this.mBuffer.append(str, offset, length);
    }

    @Override
    public void reset() throws IOException {
        this.mBuffer.reset();
    }

    @Override
    public void drain() throws IOException {
        this.mBuffer.drain();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.mConvertedCache = InternedCharToByteBuffer.getConvertedCache(this.mBuffer.getEncoding());
    }
}

