/*
 * Decompiled with CFR 0.152.
 */
package org.teatrove.trove.io;

import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.List;
import org.teatrove.trove.io.ByteBuffer;
import org.teatrove.trove.io.ByteData;

public class FileByteBuffer
implements ByteBuffer {
    private RandomAccessFile mFile;
    private List mSurrogates;
    private List mCaptureBuffers;

    public FileByteBuffer(RandomAccessFile file) throws IOException {
        this.mFile = file;
        file.seek(0L);
    }

    @Override
    public long getBaseByteCount() throws IOException {
        return this.mFile.length();
    }

    @Override
    public long getByteCount() throws IOException {
        long count = this.getBaseByteCount();
        if (this.mSurrogates == null) {
            return count;
        }
        int size = this.mSurrogates.size();
        for (int i = 0; i < size; ++i) {
            count += ((Surrogate)this.mSurrogates.get((int)i)).mByteData.getByteCount();
        }
        return count;
    }

    @Override
    public void writeTo(OutputStream out) throws IOException {
        int readAmount;
        long length = this.mFile.length();
        int bufSize = length > 4000L ? 4000 : (int)length;
        byte[] inputBuffer = new byte[bufSize];
        this.mFile.seek(0L);
        if (this.mSurrogates != null) {
            long currentPos = 0L;
            int size = this.mSurrogates.size();
            for (int i = 0; i < size; ++i) {
                Surrogate s = (Surrogate)this.mSurrogates.get(i);
                currentPos = this.writeTo(inputBuffer, out, currentPos, s.mPos);
                s.mByteData.writeTo(out);
            }
        }
        while ((readAmount = this.mFile.read(inputBuffer, 0, bufSize)) > 0) {
            out.write(inputBuffer, 0, readAmount);
        }
    }

    private long writeTo(byte[] inputBuffer, OutputStream out, long fromPos, long toPos) throws IOException {
        if (toPos == fromPos) {
            return fromPos;
        }
        int bufSize = inputBuffer.length;
        while (toPos > fromPos) {
            int readAmount;
            int amount = (long)bufSize <= toPos - fromPos ? bufSize : (int)(toPos - fromPos);
            while ((readAmount = this.mFile.read(inputBuffer, 0, amount)) > 0) {
                out.write(inputBuffer, 0, readAmount);
                fromPos += (long)readAmount;
                if ((amount -= readAmount) > 0) continue;
            }
            if (readAmount > 0) continue;
            break;
        }
        return fromPos;
    }

    @Override
    public void append(byte b) throws IOException {
        List captureBuffers = this.mCaptureBuffers;
        if (captureBuffers != null) {
            int size = captureBuffers.size();
            for (int i = 0; i < size; ++i) {
                ((ByteBuffer)captureBuffers.get(i)).append(b);
            }
        }
        this.mFile.write(b);
    }

    @Override
    public void append(byte[] bytes) throws IOException {
        this.mFile.write(bytes);
    }

    @Override
    public void append(byte[] bytes, int offset, int length) throws IOException {
        List captureBuffers = this.mCaptureBuffers;
        if (captureBuffers != null) {
            int size = captureBuffers.size();
            for (int i = 0; i < size; ++i) {
                ((ByteBuffer)captureBuffers.get(i)).append(bytes, offset, length);
            }
        }
        this.mFile.write(bytes, offset, length);
    }

    @Override
    public void appendSurrogate(ByteData s) throws IOException {
        if (s == null) {
            return;
        }
        List captureBuffers = this.mCaptureBuffers;
        if (captureBuffers != null) {
            int size = captureBuffers.size();
            for (int i = 0; i < size; ++i) {
                ((ByteBuffer)captureBuffers.get(i)).appendSurrogate(s);
            }
        }
        if (this.mSurrogates == null) {
            this.mSurrogates = new ArrayList();
        }
        this.mSurrogates.add(new Surrogate(s));
    }

    @Override
    public void addCaptureBuffer(ByteBuffer buffer) {
        ArrayList<ByteBuffer> captureBuffers = this.mCaptureBuffers;
        if (captureBuffers == null) {
            captureBuffers = this.mCaptureBuffers = new ArrayList<ByteBuffer>();
        }
        captureBuffers.add(buffer);
    }

    @Override
    public void removeCaptureBuffer(ByteBuffer buffer) {
        List captureBuffers = this.mCaptureBuffers;
        if (captureBuffers != null) {
            captureBuffers.remove(buffer);
        }
    }

    @Override
    public void reset() throws IOException {
        int i;
        int size;
        List byteDatas = this.mSurrogates;
        if (byteDatas != null) {
            size = byteDatas.size();
            for (i = 0; i < size; ++i) {
                ((ByteData)byteDatas.get(i)).reset();
            }
        }
        if ((byteDatas = this.mCaptureBuffers) != null) {
            size = byteDatas.size();
            for (i = 0; i < size; ++i) {
                ((ByteData)byteDatas.get(i)).reset();
            }
        }
    }

    private class Surrogate {
        public final ByteData mByteData;
        public final long mPos;

        public Surrogate(ByteData data) throws IOException {
            this.mByteData = data;
            this.mPos = FileByteBuffer.this.mFile.getFilePointer();
        }
    }
}

