/*
 * Decompiled with CFR 0.152.
 */
package org.teatrove.trove.io;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class FastBufferedOutputStream
extends FilterOutputStream {
    private byte[] mBuffer;
    private int mCount;

    public FastBufferedOutputStream(OutputStream out) {
        this(out, 512);
    }

    public FastBufferedOutputStream(OutputStream out, int size) {
        super(out);
        if (size <= 0) {
            throw new IllegalArgumentException("Buffer size <= 0");
        }
        this.mBuffer = new byte[size];
    }

    private void flushBuffer() throws IOException {
        if (this.mCount > 0) {
            this.out.write(this.mBuffer, 0, this.mCount);
            this.mCount = 0;
        }
    }

    @Override
    public void write(int b) throws IOException {
        if (this.mCount >= this.mBuffer.length) {
            this.flushBuffer();
        }
        this.mBuffer[this.mCount++] = (byte)b;
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (len >= this.mBuffer.length) {
            this.flushBuffer();
            this.out.write(b, off, len);
            return;
        }
        if (len > this.mBuffer.length - this.mCount) {
            this.flushBuffer();
        }
        System.arraycopy(b, off, this.mBuffer, this.mCount, len);
        this.mCount += len;
    }

    @Override
    public synchronized void flush() throws IOException {
        this.flushBuffer();
        this.out.flush();
    }

    @Override
    public synchronized void close() throws IOException {
        this.flushBuffer();
        this.out.flush();
        this.out.close();
    }
}

