/*
 * Decompiled with CFR 0.152.
 */
package org.teatrove.trove.io;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import org.teatrove.trove.io.ByteBuffer;
import org.teatrove.trove.io.ByteBufferOutputStream;
import org.teatrove.trove.io.ByteData;
import org.teatrove.trove.io.CharToByteBuffer;

public class DefaultCharToByteBuffer
implements CharToByteBuffer,
Serializable {
    private ByteBuffer mBuffer;
    private transient OutputStreamWriter mConvertor;
    private char[] mChars;
    private int mCapacity;
    private int mCursor;
    private String mDefaultEncoding;

    public DefaultCharToByteBuffer(ByteBuffer buffer) {
        this(buffer, null);
    }

    public DefaultCharToByteBuffer(ByteBuffer buffer, String defaultEncoding) {
        this.mBuffer = buffer;
        this.mChars = new char[4000];
        this.mCapacity = this.mChars.length;
        this.mDefaultEncoding = defaultEncoding;
    }

    @Override
    public void setEncoding(String enc) throws IOException {
        this.drain(true);
        this.mConvertor = new OutputStreamWriter((OutputStream)new ByteBufferOutputStream(this.mBuffer), enc);
    }

    @Override
    public String getEncoding() {
        return this.mConvertor == null ? this.mDefaultEncoding : this.mConvertor.getEncoding();
    }

    @Override
    public long getBaseByteCount() throws IOException {
        return this.mBuffer.getBaseByteCount();
    }

    @Override
    public long getByteCount() throws IOException {
        this.drain(true);
        return this.mBuffer.getByteCount();
    }

    @Override
    public void writeTo(OutputStream out) throws IOException {
        this.drain(true);
        this.mBuffer.writeTo(out);
    }

    @Override
    public void append(byte b) throws IOException {
        this.drain(true);
        this.mBuffer.append(b);
    }

    @Override
    public void append(byte[] bytes) throws IOException {
        this.append(bytes, 0, bytes.length);
    }

    @Override
    public void append(byte[] bytes, int offset, int length) throws IOException {
        if (length != 0) {
            this.drain(true);
            this.mBuffer.append(bytes, offset, length);
        }
    }

    @Override
    public void appendSurrogate(ByteData s) throws IOException {
        if (s != null) {
            this.drain(true);
            this.mBuffer.appendSurrogate(s);
        }
    }

    @Override
    public void addCaptureBuffer(ByteBuffer buffer) throws IOException {
        this.drain(true);
        this.mBuffer.addCaptureBuffer(buffer);
    }

    @Override
    public void removeCaptureBuffer(ByteBuffer buffer) throws IOException {
        this.drain(true);
        this.mBuffer.removeCaptureBuffer(buffer);
    }

    @Override
    public void append(char c) throws IOException {
        if (this.mCursor >= this.mCapacity) {
            this.drain(false);
        }
        this.mChars[this.mCursor++] = c;
    }

    @Override
    public void append(char[] chars) throws IOException {
        this.append(chars, 0, chars.length);
    }

    @Override
    public void append(char[] chars, int offset, int length) throws IOException {
        if (length == 0) {
            return;
        }
        int capacity = this.mCapacity;
        if (length < capacity - this.mCursor) {
            System.arraycopy(chars, offset, this.mChars, this.mCursor, length);
            this.mCursor += length;
            return;
        }
        this.drain(false);
        if (length < capacity) {
            System.arraycopy(chars, offset, this.mChars, this.mCursor, length);
            this.mCursor += length;
            return;
        }
        this.getConvertor().write(chars, offset, length);
    }

    @Override
    public void append(String str) throws IOException {
        this.append(str, 0, str.length());
    }

    @Override
    public void append(String str, int offset, int length) throws IOException {
        if (length == 0) {
            return;
        }
        int capacity = this.mCapacity;
        int avail = capacity - this.mCursor;
        if (length <= avail) {
            str.getChars(offset, offset + length, this.mChars, this.mCursor);
            this.mCursor += length;
            return;
        }
        str.getChars(offset, offset + avail, this.mChars, this.mCursor);
        offset += avail;
        length -= avail;
        this.mCursor = capacity;
        this.drain(false);
        while (length >= capacity) {
            str.getChars(offset, offset + capacity, this.mChars, 0);
            offset += capacity;
            length -= capacity;
            this.mCursor = capacity;
            this.drain(false);
        }
        if (length > 0) {
            str.getChars(offset, offset + length, this.mChars, 0);
            this.mCursor = length;
        }
    }

    @Override
    public void reset() throws IOException {
        this.mBuffer.reset();
    }

    @Override
    public void drain() throws IOException {
        this.drain(true);
    }

    private OutputStreamWriter getConvertor() throws UnsupportedEncodingException {
        if (this.mConvertor == null) {
            this.mConvertor = this.mDefaultEncoding == null ? new OutputStreamWriter(new ByteBufferOutputStream(this.mBuffer)) : new OutputStreamWriter((OutputStream)new ByteBufferOutputStream(this.mBuffer), this.mDefaultEncoding);
        }
        return this.mConvertor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drain(boolean flush) throws IOException {
        if (this.mCursor != 0) {
            try {
                this.getConvertor().write(this.mChars, 0, this.mCursor);
            }
            finally {
                this.mCursor = 0;
            }
        }
        if (flush && this.mConvertor != null) {
            this.mConvertor.flush();
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        if (this.mConvertor == null) {
            out.writeObject(null);
        } else {
            out.writeObject(this.mConvertor.getEncoding());
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        String enc = (String)in.readObject();
        if (enc != null) {
            this.mConvertor = new OutputStreamWriter((OutputStream)new ByteBufferOutputStream(this.mBuffer), enc);
        }
    }
}

