/*
 * Decompiled with CFR 0.152.
 */
package org.teatrove.trove.io;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.teatrove.trove.io.ArrayByteData;
import org.teatrove.trove.io.ByteBuffer;
import org.teatrove.trove.io.ByteData;

public class DefaultByteBuffer
implements ByteBuffer,
Serializable {
    private static final int BUFFER_SIZE = 512;
    private List mChunks = new ArrayList(100);
    private byte[] mBuffer;
    private int mCursor;
    private int mBaseCount;
    private List mCaptureBuffers;

    @Override
    public long getBaseByteCount() {
        if (this.mBuffer != null) {
            return this.mBaseCount + this.mCursor;
        }
        return this.mBaseCount;
    }

    @Override
    public long getByteCount() throws IOException {
        long count = this.mBuffer != null ? (long)this.mCursor : 0L;
        int size = this.mChunks.size();
        for (int i = 0; i < size; ++i) {
            count += ((ByteData)this.mChunks.get(i)).getByteCount();
        }
        return count;
    }

    @Override
    public void writeTo(OutputStream out) throws IOException {
        int size = this.mChunks.size();
        for (int i = 0; i < size; ++i) {
            ((ByteData)this.mChunks.get(i)).writeTo(out);
        }
        if (this.mBuffer != null && this.mCursor != 0) {
            out.write(this.mBuffer, 0, this.mCursor);
        }
    }

    @Override
    public void append(byte b) throws IOException {
        List captureBuffers = this.mCaptureBuffers;
        if (captureBuffers != null) {
            int size = captureBuffers.size();
            for (int i = 0; i < size; ++i) {
                ((ByteBuffer)captureBuffers.get(i)).append(b);
            }
        }
        if (this.mBuffer == null) {
            this.mBuffer = new byte[512];
            this.mCursor = 0;
        } else if (this.mCursor >= this.mBuffer.length) {
            this.mChunks.add(new ArrayByteData(this.mBuffer));
            this.mBaseCount += 512;
            this.mBuffer = new byte[512];
            this.mCursor = 0;
        }
        this.mBuffer[this.mCursor++] = b;
    }

    @Override
    public void append(byte[] bytes) throws IOException {
        this.append(bytes, 0, bytes.length);
    }

    @Override
    public void append(byte[] bytes, int offset, int length) throws IOException {
        List captureBuffers = this.mCaptureBuffers;
        if (captureBuffers != null) {
            int size = captureBuffers.size();
            for (int i = 0; i < size; ++i) {
                ((ByteBuffer)captureBuffers.get(i)).append(bytes, offset, length);
            }
        }
        while (length > 0) {
            int available;
            if (this.mBuffer == null) {
                if (length >= 512) {
                    byte[] copy = new byte[length];
                    System.arraycopy(bytes, offset, copy, 0, length);
                    this.mChunks.add(new ArrayByteData(copy));
                    this.mBaseCount += length;
                    return;
                }
                this.mBuffer = new byte[512];
                this.mCursor = 0;
            }
            if (length <= (available = 512 - this.mCursor)) {
                System.arraycopy(bytes, offset, this.mBuffer, this.mCursor, length);
                this.mCursor += length;
                return;
            }
            System.arraycopy(bytes, offset, this.mBuffer, this.mCursor, available);
            this.mChunks.add(new ArrayByteData(this.mBuffer));
            this.mBaseCount += 512;
            this.mBuffer = null;
            offset += available;
            length -= available;
        }
    }

    @Override
    public void appendSurrogate(ByteData s) throws IOException {
        if (s == null) {
            return;
        }
        List captureBuffers = this.mCaptureBuffers;
        if (captureBuffers != null) {
            int size = captureBuffers.size();
            for (int i = 0; i < size; ++i) {
                ((ByteBuffer)captureBuffers.get(i)).appendSurrogate(s);
            }
        }
        if (this.mBuffer != null && this.mCursor > 0) {
            this.mChunks.add(new ArrayByteData(this.mBuffer, 0, this.mCursor));
            this.mBaseCount += this.mCursor;
            this.mBuffer = null;
        }
        this.mChunks.add(s);
    }

    @Override
    public void addCaptureBuffer(ByteBuffer buffer) {
        ArrayList<ByteBuffer> captureBuffers = this.mCaptureBuffers;
        if (captureBuffers == null) {
            captureBuffers = this.mCaptureBuffers = new ArrayList<ByteBuffer>();
        }
        captureBuffers.add(buffer);
    }

    @Override
    public void removeCaptureBuffer(ByteBuffer buffer) {
        List captureBuffers = this.mCaptureBuffers;
        if (captureBuffers != null) {
            captureBuffers.remove(buffer);
        }
    }

    @Override
    public void reset() throws IOException {
        int size = this.mChunks.size();
        for (int i = 0; i < size; ++i) {
            ((ByteData)this.mChunks.get(i)).reset();
        }
        List captureBuffers = this.mCaptureBuffers;
        if (captureBuffers != null) {
            size = captureBuffers.size();
            for (int i = 0; i < size; ++i) {
                ((ByteData)captureBuffers.get(i)).reset();
            }
        }
    }
}

