/*
 * Decompiled with CFR 0.152.
 */
package org.teatrove.trove.io;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UTFDataFormatException;

public class DataIO {
    public static final void readFully(InputStream in, byte[] b) throws IOException {
        DataIO.readFully(in, b, 0, b.length);
    }

    public static final void readFully(InputStream in, byte[] b, int offset, int length) throws IOException {
        int amt;
        for (int n = 0; n < length; n += amt) {
            amt = in.read(b, offset + n, length - n);
            if (amt > 0) continue;
            throw new EOFException();
        }
    }

    public static final boolean readBoolean(InputStream in) throws IOException {
        int v = in.read();
        if (v < 0) {
            throw new EOFException();
        }
        return v != 0;
    }

    public static final byte readByte(InputStream in) throws IOException {
        int v = in.read();
        if (v < 0) {
            throw new EOFException();
        }
        return (byte)v;
    }

    public static final int readUnsignedByte(InputStream in) throws IOException {
        int v = in.read();
        if (v < 0) {
            throw new EOFException();
        }
        return v & 0xFF;
    }

    public static final short readShort(InputStream in, byte[] temp) throws IOException {
        DataIO.readFully(in, temp, 0, 2);
        return (short)(temp[0] << 8 | temp[1] & 0xFF);
    }

    public static final short readShort(byte[] b, int offset) {
        return (short)(b[offset] << 8 | b[offset + 1] & 0xFF);
    }

    public static final int readUnsignedShort(InputStream in, byte[] temp) throws IOException {
        DataIO.readFully(in, temp, 0, 2);
        return (temp[0] & 0xFF) << 8 | temp[1] & 0xFF;
    }

    public static final int readUnsignedShort(byte[] b, int offset) {
        return (b[offset] & 0xFF) << 8 | b[offset + 1] & 0xFF;
    }

    public static final char readChar(InputStream in, byte[] temp) throws IOException {
        DataIO.readFully(in, temp, 0, 2);
        return (char)(temp[0] << 8 | temp[1] & 0xFF);
    }

    public static final char readChar(byte[] b, int offset) {
        return (char)(b[offset] << 8 | b[offset + 1] & 0xFF);
    }

    public static final int readInt(InputStream in, byte[] temp) throws IOException {
        DataIO.readFully(in, temp, 0, 4);
        return temp[0] << 24 | (temp[1] & 0xFF) << 16 | (temp[2] & 0xFF) << 8 | temp[3] & 0xFF;
    }

    public static final int readInt(byte[] b, int offset) {
        return b[offset] << 24 | (b[offset + 1] & 0xFF) << 16 | (b[offset + 2] & 0xFF) << 8 | b[offset + 3] & 0xFF;
    }

    public static final long readLong(InputStream in, byte[] temp) throws IOException {
        DataIO.readFully(in, temp, 0, 8);
        return (long)(temp[0] << 24 | (temp[1] & 0xFF) << 16 | (temp[2] & 0xFF) << 8 | temp[3] & 0xFF) << 32 | (long)(temp[4] << 24 | (temp[5] & 0xFF) << 16 | (temp[6] & 0xFF) << 8 | temp[7] & 0xFF) & 0xFFFFFFFFL;
    }

    public static final long readLong(byte[] b, int offset) {
        return (long)(b[offset] << 24 | (b[offset + 1] & 0xFF) << 16 | (b[offset + 2] & 0xFF) << 8 | b[offset + 3] & 0xFF) << 32 | (long)(b[offset + 4] << 24 | (b[offset + 5] & 0xFF) << 16 | (b[offset + 6] & 0xFF) << 8 | b[offset + 7] & 0xFF) & 0xFFFFFFFFL;
    }

    public static final float readFloat(InputStream in, byte[] temp) throws IOException {
        return Float.intBitsToFloat(DataIO.readInt(in, temp));
    }

    public static final float readFloat(byte[] b, int offset) {
        return Float.intBitsToFloat(DataIO.readInt(b, offset));
    }

    public static final double readDouble(InputStream in, byte[] temp) throws IOException {
        return Double.longBitsToDouble(DataIO.readLong(in, temp));
    }

    public static final double readDouble(byte[] b, int offset) {
        return Double.longBitsToDouble(DataIO.readLong(b, offset));
    }

    public static final int readUTF(InputStream in, char[] chars, int offset, int length) throws IOException {
        int c;
        if (length == 0) {
            return 0;
        }
        int charCount = 0;
        block5: while (charCount < length && (c = in.read()) >= 0) {
            switch ((c &= 0xFF) >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    chars[offset + charCount++] = (char)c;
                    continue block5;
                }
                case 12: 
                case 13: {
                    int c2 = in.read();
                    if (c2 < 0) {
                        throw new EOFException();
                    }
                    if ((c2 & 0xC0) != 128) {
                        throw new UTFDataFormatException();
                    }
                    chars[offset + charCount++] = (char)((c & 0x1F) << 6 | c2 & 0x3F);
                    continue block5;
                }
                case 14: {
                    int c2 = in.read();
                    if (c2 < 0) {
                        throw new EOFException();
                    }
                    int c3 = in.read();
                    if (c3 < 0) {
                        throw new EOFException();
                    }
                    if ((c2 & 0xC0) != 128 || (c3 & 0xC0) != 128) {
                        throw new UTFDataFormatException();
                    }
                    chars[offset + charCount++] = (char)((c & 0xF) << 12 | (c2 & 0x3F) << 6 | c3 & 0x3F);
                    continue block5;
                }
            }
            throw new UTFDataFormatException();
        }
        return charCount == 0 ? -1 : charCount;
    }

    public static final int readUTF(DataInput in, char[] chars, int offset, int length) throws IOException {
        if (length == 0) {
            return 0;
        }
        int charCount = 0;
        block7: while (charCount < length) {
            int c;
            try {
                c = in.readByte() & 0xFF;
            }
            catch (EOFException e) {
                break;
            }
            switch (c >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    chars[offset + charCount++] = (char)c;
                    continue block7;
                }
                case 12: 
                case 13: {
                    byte c2 = in.readByte();
                    if ((c2 & 0xC0) != 128) {
                        throw new UTFDataFormatException();
                    }
                    chars[offset + charCount++] = (char)((c & 0x1F) << 6 | c2 & 0x3F);
                    continue block7;
                }
                case 14: {
                    byte c2 = in.readByte();
                    byte c3 = in.readByte();
                    if ((c2 & 0xC0) != 128 || (c3 & 0xC0) != 128) {
                        throw new UTFDataFormatException();
                    }
                    chars[offset + charCount++] = (char)((c & 0xF) << 12 | (c2 & 0x3F) << 6 | c3 & 0x3F);
                    continue block7;
                }
            }
            throw new UTFDataFormatException();
        }
        return charCount == 0 ? -1 : charCount;
    }

    public static final int readUTF(InputStream in, char[] chars, int offset, int length, int bytesExpected) throws IOException {
        int byteCount = 0;
        int charCount = 0;
        block5: while (byteCount < bytesExpected && charCount < length) {
            int c = in.read();
            if (c < 0) {
                throw new EOFException();
            }
            switch ((c &= 0xFF) >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    ++byteCount;
                    chars[offset + charCount++] = (char)c;
                    continue block5;
                }
                case 12: 
                case 13: {
                    if ((byteCount += 2) > bytesExpected) {
                        throw new UTFDataFormatException();
                    }
                    int c2 = in.read();
                    if (c2 < 0 || (c2 & 0xC0) != 128) {
                        throw new UTFDataFormatException();
                    }
                    chars[offset + charCount++] = (char)((c & 0x1F) << 6 | c2 & 0x3F);
                    continue block5;
                }
                case 14: {
                    if ((byteCount += 3) > bytesExpected) {
                        throw new UTFDataFormatException();
                    }
                    int c2 = in.read();
                    int c3 = in.read();
                    if (c2 < 0 || (c2 & 0xC0) != 128 || c3 < 0 || (c3 & 0xC0) != 128) {
                        throw new UTFDataFormatException();
                    }
                    chars[offset + charCount++] = (char)((c & 0xF) << 12 | (c2 & 0x3F) << 6 | c3 & 0x3F);
                    continue block5;
                }
            }
            throw new UTFDataFormatException();
        }
        return charCount;
    }

    public static final int readUTF(DataInput in, char[] chars, int offset, int length, int bytesExpected) throws IOException {
        int byteCount = 0;
        int charCount = 0;
        block5: while (byteCount < bytesExpected && charCount < length) {
            int c = in.readByte() & 0xFF;
            switch (c >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    ++byteCount;
                    chars[offset + charCount++] = (char)c;
                    continue block5;
                }
                case 12: 
                case 13: {
                    if ((byteCount += 2) > bytesExpected) {
                        throw new UTFDataFormatException();
                    }
                    byte c2 = in.readByte();
                    if ((c2 & 0xC0) != 128) {
                        throw new UTFDataFormatException();
                    }
                    chars[offset + charCount++] = (char)((c & 0x1F) << 6 | c2 & 0x3F);
                    continue block5;
                }
                case 14: {
                    if ((byteCount += 3) > bytesExpected) {
                        throw new UTFDataFormatException();
                    }
                    byte c2 = in.readByte();
                    byte c3 = in.readByte();
                    if ((c2 & 0xC0) != 128 || (c3 & 0xC0) != 128) {
                        throw new UTFDataFormatException();
                    }
                    chars[offset + charCount++] = (char)((c & 0xF) << 12 | (c2 & 0x3F) << 6 | c3 & 0x3F);
                    continue block5;
                }
            }
            throw new UTFDataFormatException();
        }
        return charCount;
    }

    public static final int calculateUTFLength(String str) {
        int length = str.length();
        int utflen = 0;
        for (int i = 0; i < length; ++i) {
            char c = str.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                ++utflen;
                continue;
            }
            if (c > '\u07ff') {
                utflen += 3;
                continue;
            }
            utflen += 2;
        }
        return utflen;
    }

    public static final int calculateUTFLength(char[] chars, int offset, int length) {
        int utflen = 0;
        for (int i = 0; i < length; ++i) {
            char c = chars[i + offset];
            if (c >= '\u0001' && c <= '\u007f') {
                ++utflen;
                continue;
            }
            if (c > '\u07ff') {
                utflen += 3;
                continue;
            }
            utflen += 2;
        }
        return utflen;
    }

    public static final void writeShort(OutputStream out, int v, byte[] temp) throws IOException {
        temp[0] = (byte)(v >> 8);
        temp[1] = (byte)v;
        out.write(temp, 0, 2);
    }

    public static final void writeShort(byte[] b, int offset, int v) {
        b[offset] = (byte)(v >> 8);
        b[offset + 1] = (byte)v;
    }

    public static final void writeChar(OutputStream out, int v, byte[] temp) throws IOException {
        temp[0] = (byte)(v >> 8);
        temp[1] = (byte)v;
        out.write(temp, 0, 2);
    }

    public static final void writeChar(byte[] b, int offset, int v) {
        b[offset] = (byte)(v >> 8);
        b[offset + 1] = (byte)v;
    }

    public static final void writeInt(OutputStream out, int v, byte[] temp) throws IOException {
        temp[0] = (byte)(v >> 24);
        temp[1] = (byte)(v >> 16);
        temp[2] = (byte)(v >> 8);
        temp[3] = (byte)v;
        out.write(temp, 0, 4);
    }

    public static final void writeInt(byte[] b, int offset, int v) {
        b[offset] = (byte)(v >> 24);
        b[offset + 1] = (byte)(v >> 16);
        b[offset + 2] = (byte)(v >> 8);
        b[offset + 3] = (byte)v;
    }

    public static final void writeLong(OutputStream out, long v, byte[] temp) throws IOException {
        int w = (int)(v >> 32);
        temp[0] = (byte)(w >> 24);
        temp[1] = (byte)(w >> 16);
        temp[2] = (byte)(w >> 8);
        temp[3] = (byte)w;
        w = (int)v;
        temp[4] = (byte)(w >> 24);
        temp[5] = (byte)(w >> 16);
        temp[6] = (byte)(w >> 8);
        temp[7] = (byte)w;
        out.write(temp, 0, 8);
    }

    public static final void writeLong(byte[] b, int offset, long v) {
        int w = (int)(v >> 32);
        b[offset] = (byte)(w >> 24);
        b[offset + 1] = (byte)(w >> 16);
        b[offset + 2] = (byte)(w >> 8);
        b[offset + 3] = (byte)w;
        w = (int)v;
        b[offset + 4] = (byte)(w >> 24);
        b[offset + 5] = (byte)(w >> 16);
        b[offset + 6] = (byte)(w >> 8);
        b[offset + 7] = (byte)w;
    }

    public static final void writeFloat(OutputStream out, float v, byte[] temp) throws IOException {
        DataIO.writeInt(out, Float.floatToIntBits(v), temp);
    }

    public static final void writeFloat(byte[] b, int offset, float v) {
        DataIO.writeInt(b, offset, Float.floatToIntBits(v));
    }

    public static final void writeDouble(OutputStream out, double v, byte[] temp) throws IOException {
        DataIO.writeLong(out, Double.doubleToLongBits(v), temp);
    }

    public static final void writeDouble(byte[] b, int offset, double v) {
        DataIO.writeLong(b, offset, Double.doubleToLongBits(v));
    }

    public static final void writeBytes(OutputStream out, String s) throws IOException {
        int strlen = s.length();
        char[] chars = new char[strlen];
        s.getChars(0, strlen, chars, 0);
        byte[] bytes = new byte[strlen];
        int i = 0;
        while (i < strlen) {
            bytes[i++] = (byte)chars[i];
        }
        out.write(bytes);
    }

    public static final void writeChars(OutputStream out, String s) throws IOException {
        int strlen = s.length();
        char[] chars = new char[strlen];
        s.getChars(0, strlen, chars, 0);
        byte[] bytes = new byte[strlen * 2];
        int i = 0;
        int j = 0;
        while (i < strlen) {
            char c = chars[i++];
            bytes[j++] = (byte)(c >> 8);
            bytes[j++] = (byte)c;
        }
        out.write(bytes);
    }

    public static final void writeUTF(OutputStream out, String str, char[] workspace) throws IOException {
        DataIO.writeUTF(out, str, 0, str.length(), workspace);
    }

    public static final void writeUTF(DataOutput out, String str, char[] workspace) throws IOException {
        DataIO.writeUTF(out, str, 0, str.length(), workspace);
    }

    public static final void writeUTF(OutputStream out, String str, int offset, int strlen, char[] workspace) throws IOException {
        int worklen = workspace.length;
        while (true) {
            int amt = strlen <= worklen ? strlen : worklen;
            str.getChars(offset, offset + amt, workspace, 0);
            DataIO.writeUTF(out, workspace, 0, amt);
            if ((strlen -= amt) <= 0) break;
            offset += amt;
        }
    }

    public static final void writeUTF(DataOutput out, String str, int offset, int strlen, char[] workspace) throws IOException {
        int worklen = workspace.length;
        while (true) {
            int amt = strlen <= worklen ? strlen : worklen;
            str.getChars(offset, offset + amt, workspace, 0);
            DataIO.writeUTF(out, workspace, 0, amt);
            if ((strlen -= amt) <= 0) break;
            offset += amt;
        }
    }

    public static final void writeUTF(OutputStream out, char[] chars, int offset, int length) throws IOException {
        for (int i = 0; i < length; ++i) {
            char c = chars[i + offset];
            if (c >= '\u0001' && c <= '\u007f') {
                out.write(c);
                continue;
            }
            if (c > '\u07ff') {
                out.write(0xE0 | c >> 12 & 0xF);
                out.write(0x80 | c >> 6 & 0x3F);
                out.write(0x80 | c & 0x3F);
                continue;
            }
            out.write(0xC0 | c >> 6 & 0x1F);
            out.write(0x80 | c & 0x3F);
        }
    }

    public static final void writeUTF(DataOutput out, char[] chars, int offset, int length) throws IOException {
        for (int i = 0; i < length; ++i) {
            char c = chars[i + offset];
            if (c >= '\u0001' && c <= '\u007f') {
                out.writeByte(c);
                continue;
            }
            if (c > '\u07ff') {
                out.writeByte(0xE0 | c >> 12 & 0xF);
                out.writeByte(0x80 | c >> 6 & 0x3F);
                out.writeByte(0x80 | c & 0x3F);
                continue;
            }
            out.writeByte(0xC0 | c >> 6 & 0x1F);
            out.writeByte(0x80 | c & 0x3F);
        }
    }
}

