/*
 * Decompiled with CFR 0.152.
 */
package org.teatrove.trove.io;

import java.io.IOException;
import java.io.Writer;
import org.teatrove.trove.io.CharToByteBuffer;

public class CharToByteBufferWriter
extends Writer {
    private CharToByteBuffer mBuffer;
    private boolean mClosed;

    public CharToByteBufferWriter(CharToByteBuffer buffer) {
        this.mBuffer = buffer;
    }

    @Override
    public void write(int c) throws IOException {
        this.checkIfClosed();
        this.mBuffer.append((char)c);
    }

    @Override
    public void write(char[] chars) throws IOException {
        this.checkIfClosed();
        this.mBuffer.append(chars);
    }

    @Override
    public void write(char[] chars, int offset, int length) throws IOException {
        this.checkIfClosed();
        this.mBuffer.append(chars, offset, length);
    }

    @Override
    public void write(String str) throws IOException {
        this.checkIfClosed();
        this.mBuffer.append(str);
    }

    @Override
    public void write(String str, int offset, int length) throws IOException {
        this.checkIfClosed();
        this.mBuffer.append(str, offset, length);
    }

    @Override
    public void flush() throws IOException {
        this.checkIfClosed();
    }

    @Override
    public void close() {
        this.mClosed = true;
    }

    private void checkIfClosed() throws IOException {
        if (this.mClosed) {
            throw new IOException("Writer closed");
        }
    }
}

