/*
 * Decompiled with CFR 0.152.
 */
package org.teatrove.trove.io;

import java.io.IOException;
import java.io.OutputStream;
import org.teatrove.trove.io.ByteBuffer;

public class ByteBufferOutputStream
extends OutputStream {
    private ByteBuffer mBuffer;
    private boolean mClosed;

    public ByteBufferOutputStream(ByteBuffer buffer) {
        this.mBuffer = buffer;
    }

    @Override
    public void write(int b) throws IOException {
        this.checkIfClosed();
        this.mBuffer.append((byte)b);
    }

    @Override
    public void write(byte[] bytes) throws IOException {
        this.checkIfClosed();
        this.mBuffer.append(bytes);
    }

    @Override
    public void write(byte[] bytes, int offset, int length) throws IOException {
        this.checkIfClosed();
        this.mBuffer.append(bytes, offset, length);
    }

    @Override
    public void flush() throws IOException {
        this.checkIfClosed();
    }

    @Override
    public void close() {
        this.mClosed = true;
    }

    private void checkIfClosed() throws IOException {
        if (this.mClosed) {
            throw new IOException("OutputStream closed");
        }
    }
}

