/*
 * Decompiled with CFR 0.152.
 */
package org.teatrove.trove.generics;

import java.lang.reflect.Constructor;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.LinkedHashMap;
import java.util.Map;
import org.teatrove.trove.generics.AbstractGenericHandler;
import org.teatrove.trove.generics.GenericType;

public class TypeVariableHandler
extends AbstractGenericHandler<TypeVariable<?>> {
    private GenericType rawType;

    public TypeVariableHandler(GenericType rootType, TypeVariable<?> genericType) {
        super(rootType, genericType);
    }

    @Override
    public GenericType getRawType() {
        if (this.rawType == null) {
            this.rawType = this.getRawType0();
        }
        return this.rawType;
    }

    @Override
    public int getDimensions() {
        return this.getRawType().getDimensions();
    }

    @Override
    public GenericType getComponentType() {
        return this.getRawType().getComponentType();
    }

    @Override
    public GenericType getRootComponentType() {
        return this.getRawType().getRootComponentType();
    }

    @Override
    public GenericType[] getTypeArguments() {
        return this.getRawType().getTypeArguments();
    }

    protected GenericType getRawType0() {
        TypeVariable variable = (TypeVariable)this.getGenericType();
        GenericType rootType = this.getRootType();
        if (rootType == null) {
            Type[] bounds = variable.getBounds();
            if (bounds.length == 1) {
                return new GenericType(bounds[0]);
            }
            return new GenericType(Object.class);
        }
        String name = variable.getName();
        TypeParameter[] parameters = this.getTypeParameters(variable);
        for (int i = 0; i < parameters.length; ++i) {
            Type[] bounds;
            TypeVariable<?> var = parameters[i].getParameter();
            String variableName = parameters[i].getName();
            if (!variableName.equals(name)) continue;
            Object declaration = var.getGenericDeclaration();
            GenericType result = null;
            if (declaration instanceof Class) {
                result = this.resolveType((Class)declaration, this.getRootType(), parameters[i].getIndex());
            }
            if (result == null && (bounds = var.getBounds()).length == 1) {
                result = new GenericType(this.getRootType(), bounds[0]);
            }
            if (result == null) break;
            return result;
        }
        return new GenericType(Object.class);
    }

    protected GenericType resolveType(Class<?> typeClass, GenericType current, int index) {
        if (!typeClass.isAssignableFrom(current.getType())) {
            return null;
        }
        if (typeClass.equals(current.getType())) {
            GenericType[] args = current.getTypeArguments();
            if (args != null && args.length > index) {
                return args[index];
            }
            return null;
        }
        GenericType supertype = current.getSupertype();
        if (supertype != null && typeClass.isAssignableFrom(supertype.getType())) {
            if (supertype.getType().equals(typeClass)) {
                return this.resolveSubtype(supertype, index);
            }
            GenericType result = this.resolveType(typeClass, supertype, index);
            if (result != null) {
                return result;
            }
        }
        GenericType[] ifaces = current.getInterfaces();
        for (int j = 0; j < ifaces.length; ++j) {
            GenericType iface = ifaces[j];
            if (!typeClass.isAssignableFrom(iface.getType())) continue;
            if (iface.getType().equals(typeClass)) {
                return this.resolveSubtype(iface, index);
            }
            GenericType result = this.resolveType(typeClass, iface, index);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    protected GenericType resolveSubtype(GenericType type, int index) {
        GenericType result = null;
        Class<?> actualType = type.getType();
        Type genericType = type.getGenericType();
        if (genericType != null) {
            result = this.resolveSubtype(genericType, index);
        }
        if (result == null && actualType != null) {
            result = this.resolveSubtype(actualType, index);
        }
        return result;
    }

    protected GenericType resolveSubtype(Type genericType, int index) {
        GenericType generic = new GenericType(this.getRootType(), genericType);
        GenericType[] arguments = generic.getTypeArguments();
        if (arguments != null && arguments.length > index) {
            return arguments[index].getRawType();
        }
        return null;
    }

    protected GenericType resolveSubtype(Class<?> type, int index) {
        TypeVariable<Class<?>> variable;
        Type[] bounds;
        TypeVariable<Class<?>>[] variables = type.getTypeParameters();
        if (variables.length > index && (bounds = (variable = variables[index]).getBounds()).length == 1) {
            return new GenericType(this.getRootType(), bounds[0]);
        }
        return null;
    }

    protected TypeParameter[] getTypeParameters(TypeVariable<?> variable) {
        LinkedHashMap<String, TypeParameter> parameters = new LinkedHashMap<String, TypeParameter>();
        Object declaration = variable.getGenericDeclaration();
        if (declaration instanceof Method) {
            Method method = (Method)declaration;
            this.addTypeParameters(parameters, method);
            Class<?> declaringClass = method.getDeclaringClass();
            this.addTypeParameters(parameters, declaringClass);
        } else if (declaration instanceof Constructor) {
            Constructor ctor = (Constructor)declaration;
            this.addTypeParameters(parameters, ctor);
            Class declaringClass = ctor.getDeclaringClass();
            this.addTypeParameters(parameters, declaringClass);
        } else if (declaration instanceof Class) {
            Class declaringClass = (Class)declaration;
            this.addTypeParameters(parameters, declaringClass);
        } else {
            this.addTypeParameters((Map<String, TypeParameter>)parameters, (GenericDeclaration)declaration);
        }
        int size = parameters.size();
        return parameters.values().toArray(new TypeParameter[size]);
    }

    protected void addTypeParameters(Map<String, TypeParameter> parameters, GenericDeclaration declaration) {
        TypeVariable<?>[] types = declaration.getTypeParameters();
        for (int i = 0; i < types.length; ++i) {
            TypeVariable<?> type = types[i];
            String name = type.getName();
            if (parameters.containsKey(name)) continue;
            parameters.put(name, new TypeParameter(type, i));
        }
    }

    protected static class TypeParameter {
        private final TypeVariable<?> parameter;
        private final int index;

        public TypeParameter(TypeVariable<?> parameter, int index) {
            this.parameter = parameter;
            this.index = index;
        }

        public String getName() {
            return this.parameter.getName();
        }

        public TypeVariable<?> getParameter() {
            return this.parameter;
        }

        public int getIndex() {
            return this.index;
        }
    }
}

