/*
 * Decompiled with CFR 0.152.
 */
package org.teatrove.trove.generics;

import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import org.teatrove.trove.generics.ClassHandler;
import org.teatrove.trove.generics.GenericArrayTypeHandler;
import org.teatrove.trove.generics.GenericHandler;
import org.teatrove.trove.generics.ParameterizedTypeHandler;
import org.teatrove.trove.generics.TypeVariableHandler;
import org.teatrove.trove.generics.WildcardTypeHandler;

public class GenericType {
    private GenericType rootType;
    private Class<?> type;
    private Type genericType;
    private boolean _supertype;
    private GenericType supertype;
    private GenericType[] interfaces;
    private GenericHandler<?> handler;

    public GenericType(Class<?> type) {
        this((GenericType)null, type);
    }

    public GenericType(Type genericType) {
        this((GenericType)null, genericType);
    }

    public GenericType(Class<?> type, Type genericType) {
        this(null, type, genericType);
    }

    public GenericType(GenericType rootType, Class<?> type) {
        this.rootType = rootType;
        this.type = type;
        this.genericType = type;
    }

    public GenericType(GenericType rootType, Type genericType) {
        this.rootType = rootType;
        this.genericType = genericType;
        if (genericType instanceof Class) {
            this.type = (Class)genericType;
        } else {
            GenericType rawType = this.getHandler(null, genericType).getRawType();
            this.type = rawType.getType();
        }
    }

    public GenericType(GenericType rootType, Class<?> type, Type genericType) {
        this.rootType = rootType;
        this.type = type;
        this.genericType = genericType == null ? type : genericType;
    }

    public GenericType getRootType() {
        return this.rootType;
    }

    public Class<?> getType() {
        return this.type;
    }

    public Type getGenericType() {
        return this.genericType;
    }

    public GenericType getSupertype() {
        if (!this._supertype) {
            this._supertype = true;
            if (this.type.getSuperclass() != null) {
                this.supertype = new GenericType(this.rootType, this.type.getSuperclass(), this.type.getGenericSuperclass());
            }
        }
        return this.supertype;
    }

    public GenericType[] getInterfaces() {
        if (this.interfaces == null) {
            Class<?>[] ifaces = this.type.getInterfaces();
            Type[] genericIfaces = this.type.getGenericInterfaces();
            this.interfaces = new GenericType[ifaces.length];
            for (int i = 0; i < ifaces.length; ++i) {
                this.interfaces[i] = new GenericType(this.rootType, ifaces[i], genericIfaces[i]);
            }
        }
        return this.interfaces;
    }

    public GenericType getRawType() {
        return this.getHandler().getRawType();
    }

    public boolean isArray() {
        return this.getDimensions() > 0;
    }

    public int getDimensions() {
        return this.getHandler().getDimensions();
    }

    public GenericType getComponentType() {
        return this.getHandler().getComponentType();
    }

    public GenericType getRootComponentType() {
        return this.getHandler().getRootComponentType();
    }

    public GenericType getTypeArgument(int index) {
        GenericType[] args = this.getTypeArguments();
        if (args != null && args.length > index) {
            return args[index];
        }
        return null;
    }

    public GenericType[] getTypeArguments() {
        return this.getHandler().getTypeArguments();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof GenericType)) {
            return false;
        }
        GenericType other = (GenericType)object;
        Class<?> thisType = this.getType();
        Class<?> otherType = other.getType();
        if (thisType != null && otherType == null || thisType == null && otherType != null || thisType != null && !thisType.equals(otherType)) {
            return false;
        }
        GenericType[] thisArgs = this.getTypeArguments();
        GenericType[] otherArgs = other.getTypeArguments();
        if (thisArgs == null || thisArgs.length == 0 || otherArgs == null || otherArgs.length == 0) {
            return true;
        }
        int len = thisArgs.length;
        for (int i = 0; i < len; ++i) {
            if (thisArgs[i].equals(otherArgs[i])) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hashCode = 0;
        return hashCode += this.type == null ? 11 : 11 * this.type.hashCode();
    }

    public String toString() {
        if (this.type != null) {
            return this.type.getName();
        }
        if (this.genericType != null) {
            return this.genericType.toString();
        }
        return "null";
    }

    protected GenericHandler<?> getHandler() {
        if (this.handler == null) {
            this.handler = this.getHandler(this.getRootType(), this.getGenericType());
        }
        return this.handler;
    }

    protected GenericHandler<?> getHandler(GenericType rootType, Type genericType) {
        if (genericType instanceof Class) {
            return new ClassHandler(rootType, (Class)genericType);
        }
        if (genericType instanceof ParameterizedType) {
            return new ParameterizedTypeHandler(rootType, (ParameterizedType)genericType);
        }
        if (genericType instanceof TypeVariable) {
            return new TypeVariableHandler(rootType, (TypeVariable)genericType);
        }
        if (genericType instanceof WildcardType) {
            return new WildcardTypeHandler(rootType, (WildcardType)genericType);
        }
        if (genericType instanceof GenericArrayType) {
            return new GenericArrayTypeHandler(rootType, (GenericArrayType)genericType);
        }
        throw new IllegalStateException("generic type not supported: " + genericType.getClass());
    }
}

