/*
 * Decompiled with CFR 0.152.
 */
package org.teatrove.trove.file;

import java.io.File;
import java.io.IOException;
import java.io.InterruptedIOException;
import org.teatrove.trove.file.FileBuffer;
import org.teatrove.trove.file.MappedFileBuffer;
import org.teatrove.trove.util.ReadWriteLock;
import org.teatrove.trove.util.SecureReadWriteLock;

public final class SystemFileBuffer
implements FileBuffer {
    public static final int MAP_RO = 1;
    public static final int MAP_RW = 2;
    public static final int MAP_COW = 3;
    private volatile long mHandle;
    private final boolean mReadOnly;
    private final SecureReadWriteLock mLock;

    public SystemFileBuffer(File file, boolean readOnly) throws IOException {
        this(file.getCanonicalPath(), readOnly, new SecureReadWriteLock());
    }

    public SystemFileBuffer(String path, boolean readOnly) throws IOException {
        this(path, readOnly, new SecureReadWriteLock());
    }

    public SystemFileBuffer(File file, boolean readOnly, SecureReadWriteLock lock) throws IOException {
        this(file.getCanonicalPath(), readOnly, lock);
    }

    public SystemFileBuffer(String path, boolean readOnly, SecureReadWriteLock lock) throws IOException {
        SecurityManager sc = System.getSecurityManager();
        if (sc != null) {
            sc.checkRead(path);
            if (!readOnly) {
                sc.checkWrite(path);
            }
        }
        this.mHandle = SystemFileBuffer.open(path, readOnly);
        this.mReadOnly = readOnly;
        this.mLock = lock;
    }

    public FileBuffer map(int mode, long position, int size) throws IOException {
        if (mode != 1 && mode != 2 && mode != 3) {
            throw new IllegalArgumentException("Unknown mode");
        }
        if (position < 0L) {
            throw new IllegalArgumentException("position < 0: " + position);
        }
        if (size < 0) {
            throw new IllegalArgumentException("size < 0: " + size);
        }
        long fileSize = position + (long)size;
        return new MappedFileBuffer(SystemFileBuffer.openMapping(this.mHandle, mode, fileSize), mode, position, size, this.mLock);
    }

    @Override
    public int read(long position, byte[] dst, int offset, int length) throws IOException {
        this.checkArgs(position, dst, offset, length);
        if (length == 0) {
            return 0;
        }
        try {
            this.mLock.acquireReadLock();
            int n = this.read(this.mHandle, position, dst, offset, length);
            return n;
        }
        catch (InterruptedException e) {
            throw new InterruptedIOException();
        }
        finally {
            this.mLock.releaseLock();
        }
    }

    @Override
    public int write(long position, byte[] src, int offset, int length) throws IOException {
        this.checkArgs(position, src, offset, length);
        if (length == 0) {
            return 0;
        }
        try {
            this.mLock.acquireWriteLock();
            int n = this.write(this.mHandle, position, src, offset, length);
            return n;
        }
        catch (InterruptedException e) {
            throw new InterruptedIOException();
        }
        finally {
            this.mLock.releaseLock();
        }
    }

    @Override
    public int read(long position) throws IOException {
        if (position < 0L) {
            throw new IllegalArgumentException("position < 0: " + position);
        }
        try {
            this.mLock.acquireReadLock();
            int n = this.read(this.mHandle, position);
            return n;
        }
        catch (InterruptedException e) {
            throw new InterruptedIOException();
        }
        finally {
            this.mLock.releaseLock();
        }
    }

    @Override
    public void write(long position, int value) throws IOException {
        if (position < 0L) {
            throw new IllegalArgumentException("position < 0: " + position);
        }
        try {
            this.mLock.acquireWriteLock();
            this.write(this.mHandle, position, value);
        }
        catch (InterruptedException e) {
            throw new InterruptedIOException();
        }
        finally {
            this.mLock.releaseLock();
        }
    }

    @Override
    public long size() throws IOException {
        try {
            this.mLock.acquireReadLock();
            long l = this.size(this.mHandle);
            return l;
        }
        catch (InterruptedException e) {
            throw new InterruptedIOException();
        }
        finally {
            this.mLock.releaseLock();
        }
    }

    @Override
    public void truncate(long size) throws IOException {
        if (size < 0L) {
            throw new IllegalArgumentException("size < 0: " + size);
        }
        try {
            this.mLock.acquireWriteLock();
            this.truncate(this.mHandle, size);
        }
        catch (InterruptedException e) {
            throw new InterruptedIOException();
        }
        finally {
            this.mLock.releaseLock();
        }
    }

    @Override
    public ReadWriteLock lock() {
        return this.mLock;
    }

    @Override
    public boolean force() throws IOException {
        try {
            this.mLock.acquireWriteLock();
            this.force(this.mHandle, true);
        }
        catch (InterruptedException e) {
            throw new InterruptedIOException();
        }
        finally {
            this.mLock.releaseLock();
        }
        return true;
    }

    @Override
    public boolean isReadOnly() throws IOException {
        if (!this.isOpen()) {
            throw new IOException("FileBuffer closed");
        }
        return this.mReadOnly;
    }

    @Override
    public boolean isOpen() {
        return this.mHandle != 0L;
    }

    @Override
    public void close() throws IOException {
        try {
            this.mLock.acquireWriteLock();
            if (this.mHandle != 0L) {
                this.close(this.mHandle);
                this.mHandle = 0L;
            }
        }
        catch (InterruptedException e) {
            throw new InterruptedIOException();
        }
        finally {
            this.mLock.releaseLock();
        }
    }

    protected void finalize() throws IOException {
        if (this.mHandle != 0L) {
            this.close(this.mHandle);
            this.mHandle = 0L;
        }
    }

    private void checkArgs(long position, byte[] array, int offset, int length) {
        if (position < 0L) {
            throw new IllegalArgumentException("position < 0: " + position);
        }
        if (offset < 0) {
            throw new ArrayIndexOutOfBoundsException("offset < 0: " + offset);
        }
        if (length < 0) {
            throw new IndexOutOfBoundsException("length < 0: " + length);
        }
        if (offset + length > array.length) {
            throw new ArrayIndexOutOfBoundsException("offset + length > array length: " + (offset + length) + " > " + array.length);
        }
    }

    private static native long open(String var0, boolean var1) throws IOException;

    private static native long openMapping(long var0, int var2, long var3);

    private native int read(long var1, long var3, byte[] var5, int var6, int var7) throws IOException;

    private native int write(long var1, long var3, byte[] var5, int var6, int var7) throws IOException;

    private native int read(long var1, long var3) throws IOException;

    private native void write(long var1, long var3, int var5) throws IOException;

    private native long size(long var1) throws IOException;

    private native void truncate(long var1, long var3) throws IOException;

    private native void force(long var1, boolean var3) throws IOException;

    private native void close(long var1) throws IOException;

    static {
        System.loadLibrary("org.teatrove_trove_file_SystemFileBuffer");
    }
}

