/*
 * Decompiled with CFR 0.152.
 */
package org.teatrove.trove.file;

import java.io.File;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.RandomAccessFile;
import org.teatrove.trove.file.FileBuffer;
import org.teatrove.trove.util.ReadWriteLock;
import org.teatrove.trove.util.SecureReadWriteLock;

public class RandomAccessFileBuffer
implements FileBuffer {
    private RandomAccessFile mRAF;
    private long mPosition;
    private volatile int mFlags;
    private final SecureReadWriteLock mLock;

    public RandomAccessFileBuffer(File file, boolean readOnly) throws IOException {
        this(new RandomAccessFile(file, readOnly ? "r" : "rw"), readOnly, new SecureReadWriteLock());
    }

    public RandomAccessFileBuffer(RandomAccessFile raf, boolean readOnly) throws IOException {
        this(raf, readOnly, new SecureReadWriteLock());
    }

    public RandomAccessFileBuffer(File file, boolean readOnly, SecureReadWriteLock lock) throws IOException {
        this(new RandomAccessFile(file, readOnly ? "r" : "rw"), readOnly, lock);
    }

    public RandomAccessFileBuffer(RandomAccessFile raf, boolean readOnly, SecureReadWriteLock lock) throws IOException {
        this.mRAF = raf;
        this.mPosition = raf.getFilePointer();
        this.mFlags = readOnly ? 1 : 0;
        this.mLock = lock;
    }

    @Override
    public int read(long position, byte[] dst, int offset, int length) throws IOException {
        try {
            int amt;
            this.mLock.acquireWriteLock();
            if (position != this.mPosition) {
                this.mRAF.seek(position);
                this.mPosition = position;
            }
            if ((amt = this.mRAF.read(dst, offset, length)) > 0) {
                this.mPosition += (long)amt;
            }
            int n = amt;
            return n;
        }
        catch (InterruptedException e) {
            throw new InterruptedIOException();
        }
        finally {
            this.mLock.releaseLock();
        }
    }

    @Override
    public int write(long position, byte[] src, int offset, int length) throws IOException {
        try {
            this.mLock.acquireWriteLock();
            if (position != this.mPosition) {
                this.mRAF.seek(position);
                this.mPosition = position;
            }
            this.mRAF.write(src, offset, length);
            this.mPosition += (long)length;
            int n = length;
            return n;
        }
        catch (InterruptedException e) {
            throw new InterruptedIOException();
        }
        finally {
            this.mLock.releaseLock();
        }
    }

    @Override
    public int read(long position) throws IOException {
        try {
            int value;
            this.mLock.acquireWriteLock();
            if (position != this.mPosition) {
                this.mRAF.seek(position);
                this.mPosition = position;
            }
            if ((value = this.mRAF.read()) >= 0) {
                ++this.mPosition;
            }
            int n = value;
            return n;
        }
        catch (InterruptedException e) {
            throw new InterruptedIOException();
        }
        finally {
            this.mLock.releaseLock();
        }
    }

    @Override
    public void write(long position, int value) throws IOException {
        try {
            this.mLock.acquireWriteLock();
            if (position != this.mPosition) {
                this.mRAF.seek(position);
                this.mPosition = position;
            }
            this.mRAF.write(value);
            ++this.mPosition;
        }
        catch (InterruptedException e) {
            throw new InterruptedIOException();
        }
        finally {
            this.mLock.releaseLock();
        }
    }

    @Override
    public long size() throws IOException {
        try {
            this.mLock.acquireReadLock();
            long l = this.mRAF.length();
            return l;
        }
        catch (InterruptedException e) {
            throw new InterruptedIOException();
        }
        finally {
            this.mLock.releaseLock();
        }
    }

    @Override
    public void truncate(long size) throws IOException {
        try {
            this.mLock.acquireWriteLock();
            if (size < this.size()) {
                this.mRAF.setLength(size);
                this.mPosition = this.mRAF.getFilePointer();
            }
        }
        catch (InterruptedException e) {
            throw new InterruptedIOException();
        }
        finally {
            this.mLock.releaseLock();
        }
    }

    @Override
    public ReadWriteLock lock() {
        return this.mLock;
    }

    @Override
    public boolean force() throws IOException {
        try {
            this.mLock.acquireWriteLock();
            this.mRAF.getFD().sync();
        }
        catch (InterruptedException e) {
            throw new InterruptedIOException();
        }
        finally {
            this.mLock.releaseLock();
        }
        return true;
    }

    @Override
    public boolean isReadOnly() throws IOException {
        return (this.mFlags & 1) != 0;
    }

    @Override
    public boolean isOpen() {
        return (this.mFlags & 2) == 0;
    }

    @Override
    public void close() throws IOException {
        try {
            this.mLock.acquireWriteLock();
            if (this.isOpen()) {
                this.mRAF.close();
                this.mFlags |= 2;
            }
        }
        catch (InterruptedException e) {
            throw new InterruptedIOException();
        }
        finally {
            this.mLock.releaseLock();
        }
    }
}

