/*
 * Decompiled with CFR 0.152.
 */
package org.teatrove.trove.file;

import java.io.IOException;
import org.teatrove.trove.file.FileBuffer;
import org.teatrove.trove.file.TxFileBuffer;
import org.teatrove.trove.util.ReadWriteLock;

public class NonTxFileBuffer
implements TxFileBuffer {
    protected final FileBuffer mFile;

    public NonTxFileBuffer(FileBuffer file) {
        this.mFile = file;
    }

    @Override
    public int read(long position, byte[] dst, int offset, int length) throws IOException {
        return this.mFile.read(position, dst, offset, length);
    }

    @Override
    public int write(long position, byte[] src, int offset, int length) throws IOException {
        this.begin();
        int amt = this.mFile.write(position, src, offset, length);
        this.commit();
        return amt;
    }

    @Override
    public int read(long position) throws IOException {
        return this.mFile.read(position);
    }

    @Override
    public void write(long position, int value) throws IOException {
        this.begin();
        this.mFile.write(position, value);
        this.commit();
    }

    @Override
    public long size() throws IOException {
        return this.mFile.size();
    }

    @Override
    public void truncate(long size) throws IOException {
        this.begin();
        this.mFile.truncate(size);
        this.commit();
    }

    @Override
    public ReadWriteLock lock() {
        return this.mFile.lock();
    }

    @Override
    public boolean force() throws IOException {
        return this.mFile.force();
    }

    @Override
    public boolean isReadOnly() throws IOException {
        return this.mFile.isReadOnly();
    }

    @Override
    public boolean isOpen() {
        return this.mFile.isOpen();
    }

    @Override
    public void close() throws IOException {
        this.mFile.close();
    }

    @Override
    public void close(long timeout) throws IOException {
        this.mFile.close();
    }

    @Override
    public boolean isRollbackSupported() {
        return false;
    }

    @Override
    public boolean isClean() throws IOException {
        return true;
    }

    @Override
    public void begin() throws IOException {
    }

    @Override
    public boolean commit() throws IOException {
        return false;
    }

    @Override
    public boolean rollback() {
        throw new UnsupportedOperationException();
    }
}

