/*
 * Decompiled with CFR 0.152.
 */
package org.teatrove.trove.file;

import java.io.DataOutput;
import java.io.IOException;
import org.teatrove.trove.file.FileBuffer;
import org.teatrove.trove.io.AbstractDataOutputStream;

public class FileBufferOutputStream
extends AbstractDataOutputStream
implements DataOutput {
    private FileBuffer mFileBuffer;
    private long mPosition;
    private final boolean mCloseBuffer;

    public FileBufferOutputStream(FileBuffer fb) {
        this(fb, 0L, true);
    }

    public FileBufferOutputStream(FileBuffer fb, long position, boolean closeBuffer) {
        this.mFileBuffer = fb;
        this.mPosition = position;
        this.mCloseBuffer = closeBuffer;
    }

    @Override
    public void write(int b) throws IOException {
        this.checkClosed();
        this.mFileBuffer.write(this.mPosition, b);
        ++this.mPosition;
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int offset, int length) throws IOException {
        int amt;
        this.checkClosed();
        if (length == 0) {
            return;
        }
        while ((amt = this.mFileBuffer.write(this.mPosition, b, offset, length)) > 0) {
            this.mPosition += (long)amt;
            offset += amt;
            if ((length -= amt) > 0) continue;
        }
    }

    @Override
    public void close() throws IOException {
        if (this.mFileBuffer != null) {
            if (this.mCloseBuffer) {
                this.mFileBuffer.close();
            }
            this.mFileBuffer = null;
        }
    }

    public boolean isOpen() {
        return this.mFileBuffer != null;
    }

    public long position() throws IOException {
        this.checkClosed();
        return this.mPosition;
    }

    public void position(long position) throws IOException {
        this.checkClosed();
        if (position < 0L) {
            throw new IllegalArgumentException("Position < 0: " + position);
        }
        this.mPosition = position;
    }

    protected void finalize() throws IOException {
        this.close();
    }

    private void checkClosed() throws IOException {
        if (this.mFileBuffer == null) {
            throw new IOException("Stream closed");
        }
    }
}

