/*
 * Decompiled with CFR 0.152.
 */
package org.teatrove.trove.file;

import java.io.IOException;
import java.io.InterruptedIOException;
import org.teatrove.trove.file.FileBuffer;
import org.teatrove.trove.util.ReadWriteLock;

public class Bitlist {
    private final FileBuffer mFile;

    private static int findSubIndex(byte v) {
        return v < 0 ? 0 : (v < 16 ? (v < 4 ? (v < 2 ? 7 : 6) : (v < 8 ? 5 : 4)) : (v < 64 ? (v < 32 ? 3 : 2) : 1));
    }

    public Bitlist(FileBuffer file) {
        this.mFile = file;
    }

    public void set(long index) throws IOException {
        long pos = index >> 3;
        try {
            this.lock().acquireUpgradableLock();
            int value = this.mFile.read(pos);
            int newValue = value <= 0 ? 128 >> (int)(index & 7L) : value | 128 >> (int)(index & 7L);
            if (newValue != value) {
                this.mFile.write(pos, newValue);
            }
        }
        catch (InterruptedException e) {
            throw new InterruptedIOException();
        }
        finally {
            this.lock().releaseLock();
        }
    }

    public void clear(long index) throws IOException {
        long pos = index >> 3;
        try {
            this.lock().acquireUpgradableLock();
            int value = this.mFile.read(pos);
            int newValue = value <= 0 ? 0 : value & -129 >> (int)(index & 7L);
            if (newValue != value) {
                this.mFile.write(pos, newValue);
            }
        }
        catch (InterruptedException e) {
            throw new InterruptedIOException();
        }
        finally {
            this.lock().releaseLock();
        }
    }

    public boolean get(long index) throws IOException {
        try {
            this.lock().acquireReadLock();
            int value = this.mFile.read(index >> 3);
            boolean bl = value > 0 && (value << (int)(index & 7L) & 0x80) != 0;
            return bl;
        }
        catch (InterruptedException e) {
            throw new InterruptedIOException();
        }
        finally {
            this.lock().releaseLock();
        }
    }

    public long findFirstSet(long start) throws IOException {
        return this.findFirstSet(start, new byte[128]);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long findFirstSet(long start, byte[] temp) throws IOException {
        long pos = start >> 3;
        try {
            this.lock().acquireReadLock();
            block7: while (true) {
                int amt;
                if ((amt = this.mFile.read(pos, temp, 0, temp.length)) <= 0) {
                    long l = -1L;
                    return l;
                }
                int i = 0;
                while (true) {
                    long index;
                    if (i >= amt) continue block7;
                    byte val = temp[i];
                    if (val != 0 && ((index = pos << 3) >= start || (val = (byte)(val & 255 >>> (int)(start - index))) != 0)) {
                        long l = index + (long)Bitlist.findSubIndex(val);
                        return l;
                    }
                    ++i;
                    ++pos;
                    continue;
                    break;
                }
                break;
            }
        }
        catch (InterruptedException e) {
            throw new InterruptedIOException();
        }
        finally {
            this.lock().releaseLock();
        }
    }

    public long findFirstClear(long start) throws IOException {
        return this.findFirstClear(start, new byte[128]);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long findFirstClear(long start, byte[] temp) throws IOException {
        long pos = start >> 3;
        try {
            this.lock().acquireReadLock();
            block7: while (true) {
                int amt;
                if ((amt = this.mFile.read(pos, temp, 0, temp.length)) <= 0) {
                    long l = -1L;
                    return l;
                }
                int i = 0;
                while (true) {
                    long index;
                    if (i >= amt) continue block7;
                    byte val = temp[i];
                    if (val != -1 && ((index = pos << 3) >= start || (val = (byte)(val | -256 >> (int)(start - index))) != -1)) {
                        long l = index + (long)Bitlist.findSubIndex((byte)(val ^ 0xFF));
                        return l;
                    }
                    ++i;
                    ++pos;
                    continue;
                    break;
                }
                break;
            }
        }
        catch (InterruptedException e) {
            throw new InterruptedIOException();
        }
        finally {
            this.lock().releaseLock();
        }
    }

    public long countSetBits() throws IOException {
        long size = this.mFile.size();
        byte[] temp = size > 1024L ? new byte[1024] : new byte[(int)size];
        long pos = 0L;
        long count = 0L;
        try {
            int amt;
            this.lock().acquireReadLock();
            while ((amt = this.mFile.read(pos, temp, 0, temp.length)) > 0) {
                block18: for (int i = 0; i < amt; ++i) {
                    byte val = temp[i];
                    switch (val & 0xF) {
                        default: {
                            break;
                        }
                        case 1: 
                        case 2: 
                        case 4: 
                        case 8: {
                            ++count;
                            break;
                        }
                        case 3: 
                        case 5: 
                        case 6: 
                        case 9: 
                        case 10: 
                        case 12: {
                            count += 2L;
                            break;
                        }
                        case 7: 
                        case 11: 
                        case 13: 
                        case 14: {
                            count += 3L;
                            break;
                        }
                        case 15: {
                            count += 4L;
                        }
                    }
                    switch (val >> 4 & 0xF) {
                        default: {
                            continue block18;
                        }
                        case 1: 
                        case 2: 
                        case 4: 
                        case 8: {
                            ++count;
                            continue block18;
                        }
                        case 3: 
                        case 5: 
                        case 6: 
                        case 9: 
                        case 10: 
                        case 12: {
                            count += 2L;
                            continue block18;
                        }
                        case 7: 
                        case 11: 
                        case 13: 
                        case 14: {
                            count += 3L;
                            continue block18;
                        }
                        case 15: {
                            count += 4L;
                        }
                    }
                }
                pos += (long)amt;
            }
        }
        catch (InterruptedException e) {
            throw new InterruptedIOException();
        }
        finally {
            this.lock().releaseLock();
        }
        return count;
    }

    public long countClearBits() throws IOException {
        long size = this.mFile.size();
        byte[] temp = size > 1024L ? new byte[1024] : new byte[(int)size];
        long pos = 0L;
        long count = 0L;
        try {
            int amt;
            this.lock().acquireReadLock();
            while ((amt = this.mFile.read(pos, temp, 0, temp.length)) > 0) {
                block18: for (int i = 0; i < amt; ++i) {
                    byte val = temp[i];
                    switch (val & 0xF) {
                        case 0: {
                            count += 4L;
                            break;
                        }
                        case 1: 
                        case 2: 
                        case 4: 
                        case 8: {
                            count += 3L;
                            break;
                        }
                        case 3: 
                        case 5: 
                        case 6: 
                        case 9: 
                        case 10: 
                        case 12: {
                            count += 2L;
                            break;
                        }
                        case 7: 
                        case 11: 
                        case 13: 
                        case 14: {
                            ++count;
                            break;
                        }
                    }
                    switch (val >> 4 & 0xF) {
                        case 0: {
                            count += 4L;
                            continue block18;
                        }
                        case 1: 
                        case 2: 
                        case 4: 
                        case 8: {
                            count += 3L;
                            continue block18;
                        }
                        case 3: 
                        case 5: 
                        case 6: 
                        case 9: 
                        case 10: 
                        case 12: {
                            count += 2L;
                            continue block18;
                        }
                        case 7: 
                        case 11: 
                        case 13: 
                        case 14: {
                            ++count;
                            continue block18;
                        }
                    }
                }
                pos += (long)amt;
            }
        }
        catch (InterruptedException e) {
            throw new InterruptedIOException();
        }
        finally {
            this.lock().releaseLock();
        }
        return count;
    }

    public long size() throws IOException {
        return this.mFile.size() * 8L;
    }

    public ReadWriteLock lock() {
        return this.mFile.lock();
    }

    public boolean force() throws IOException {
        return this.mFile.force();
    }
}

