/*
 * Decompiled with CFR 0.152.
 */
package org.teatrove.trove.classfile.generics;

import org.teatrove.trove.classfile.generics.AbstractGenericTypeDesc;
import org.teatrove.trove.classfile.generics.InternFactory;

public class ClassTypeDesc
extends AbstractGenericTypeDesc<Class<?>> {
    private final String className;
    private boolean isInterface;

    public static ClassTypeDesc forType(Class<?> type) {
        return InternFactory.intern(new ClassTypeDesc(type));
    }

    public static ClassTypeDesc forType(String className) {
        return InternFactory.intern(new ClassTypeDesc(className));
    }

    public static ClassTypeDesc forType(String className, boolean isInterface) {
        return InternFactory.intern(new ClassTypeDesc(className, isInterface));
    }

    protected ClassTypeDesc(String className) {
        this.className = className;
        try {
            this.isInterface = Class.forName(className).isInterface();
        }
        catch (Exception e) {
            this.isInterface = false;
        }
    }

    protected ClassTypeDesc(Class<?> type) {
        this(type.getName(), type.isInterface());
    }

    protected ClassTypeDesc(String className, boolean isInterface) {
        this.className = className;
        this.isInterface = isInterface;
    }

    public String getClassName() {
        return this.className;
    }

    public boolean isInterface() {
        return this.isInterface;
    }

    @Override
    public String getSignature() {
        return this.getSignature(true);
    }

    protected String getSignature(boolean terminate) {
        String name = this.getClassName();
        if ("byte".equals(name) || "B".equals(name)) {
            return "B";
        }
        if ("char".equals(name) || "C".equals(name)) {
            return "C";
        }
        if ("double".equals(name) || "D".equals(name)) {
            return "D";
        }
        if ("float".equals(name) || "F".equals(name)) {
            return "F";
        }
        if ("int".equals(name) || "I".equals(name)) {
            return "I";
        }
        if ("long".equals(name) || "J".equals(name)) {
            return "J";
        }
        if ("short".equals(name) || "S".equals(name)) {
            return "S";
        }
        if ("boolean".equals(name) || "Z".equals(name)) {
            return "Z";
        }
        if ("void".equals(name) || "V".equals(name)) {
            return "V";
        }
        StringBuilder buffer = new StringBuilder(128);
        buffer.append('L').append(this.getClassName().replace('.', '/'));
        if (terminate) {
            buffer.append(';');
        }
        return buffer.toString();
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof ClassTypeDesc)) {
            return false;
        }
        ClassTypeDesc type = (ClassTypeDesc)other;
        return this.className.equals(type.className);
    }

    @Override
    public int hashCode() {
        return this.className.hashCode();
    }

    public String toString() {
        return (this.isInterface() ? "interface " : "class ").concat(this.getClassName());
    }
}

