/*
 * Decompiled with CFR 0.152.
 */
package org.teatrove.trove.classfile;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.teatrove.trove.classfile.Attribute;
import org.teatrove.trove.classfile.ConstantPool;
import org.teatrove.trove.classfile.ConstantUTFInfo;

class SourceFileAttr
extends Attribute {
    private String mFileName;
    private ConstantUTFInfo mSourcefile;

    public SourceFileAttr(ConstantPool cp, String fileName) {
        super(cp, "SourceFile");
        this.mFileName = fileName;
        this.mSourcefile = ConstantUTFInfo.make(cp, fileName);
    }

    public String getFileName() {
        return this.mFileName;
    }

    public ConstantUTFInfo getFileNameConstant() {
        return this.mSourcefile;
    }

    @Override
    public int getLength() {
        return 2;
    }

    @Override
    public void writeDataTo(DataOutput dout) throws IOException {
        dout.writeShort(this.mSourcefile.getIndex());
    }

    static Attribute define(ConstantPool cp, String name, int length, DataInput din) throws IOException {
        int index = din.readUnsignedShort();
        if ((length -= 2) > 0) {
            din.skipBytes(length);
        }
        String filename = ((ConstantUTFInfo)cp.getConstant(index)).getValue();
        return new SourceFileAttr(cp, filename);
    }
}

