/*
 * Decompiled with CFR 0.152.
 */
package org.teatrove.trove.classfile;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;
import org.teatrove.trove.classfile.TypeDesc;
import org.teatrove.trove.classfile.generics.AbstractGenericTypeDesc;
import org.teatrove.trove.classfile.generics.ClassTypeDesc;
import org.teatrove.trove.classfile.generics.GenericTypeDesc;
import org.teatrove.trove.classfile.generics.ParameterizedTypeDesc;
import org.teatrove.trove.classfile.generics.TypeVariableDesc;
import org.teatrove.trove.util.FlyweightSet;

public class SignatureDesc {
    private static final FlyweightSet mInstances = TypeDesc.cInstances;
    private final transient String mDescriptor;

    static SignatureDesc intern(SignatureDesc desc) {
        return (SignatureDesc)mInstances.put(desc);
    }

    public static SignatureDesc forClass(TypeVariableDesc[] typeArguments, GenericTypeDesc superClass, GenericTypeDesc ... interfaces) {
        return SignatureDesc.intern(new SignatureDesc(SignatureDesc.generateClassDescriptor(typeArguments, superClass, interfaces)));
    }

    public static SignatureDesc forMethod(GenericTypeDesc returnType, GenericTypeDesc ... paramTypes) {
        return SignatureDesc.forMethod(null, returnType, paramTypes);
    }

    public static SignatureDesc forMethod(TypeVariableDesc[] typeArguments, GenericTypeDesc returnType, GenericTypeDesc ... paramTypes) {
        return SignatureDesc.intern(new SignatureDesc(SignatureDesc.generateMethodDescriptor(typeArguments, returnType, paramTypes)));
    }

    public static SignatureDesc forMethod(TypeDesc returnType, TypeDesc ... paramTypes) {
        return SignatureDesc.forMethod(null, returnType, paramTypes);
    }

    public static SignatureDesc forMethod(TypeVariableDesc[] typeArguments, TypeDesc returnType, TypeDesc ... paramTypes) {
        return SignatureDesc.intern(new SignatureDesc(SignatureDesc.generateMethodDescriptor(typeArguments, returnType, paramTypes)));
    }

    private SignatureDesc(String desc) {
        this.mDescriptor = desc;
    }

    public String toString() {
        return this.mDescriptor;
    }

    public int hashCode() {
        return this.mDescriptor.hashCode();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof SignatureDesc) {
            return ((SignatureDesc)other).mDescriptor.equals(this.mDescriptor);
        }
        return false;
    }

    Object writeReplace() throws ObjectStreamException {
        return new External(this.mDescriptor);
    }

    public static String generateMethodDescriptor(TypeVariableDesc[] typeArguments, TypeDesc returnType, TypeDesc[] paramTypes) {
        StringBuilder buffer = new StringBuilder(256);
        SignatureDesc.appendTypeArguments(buffer, typeArguments);
        buffer.append('(');
        SignatureDesc.appendTypes(buffer, paramTypes);
        buffer.append(')');
        SignatureDesc.appendType(buffer, returnType);
        return buffer.toString();
    }

    public static String generateMethodDescriptor(TypeVariableDesc[] typeArguments, GenericTypeDesc returnType, GenericTypeDesc[] paramTypes) {
        StringBuilder buffer = new StringBuilder(256);
        SignatureDesc.appendTypeArguments(buffer, typeArguments);
        buffer.append('(');
        SignatureDesc.appendTypes(buffer, paramTypes);
        buffer.append(')');
        SignatureDesc.appendType(buffer, returnType);
        return buffer.toString();
    }

    public static String generateClassDescriptor(TypeVariableDesc[] typeArguments, GenericTypeDesc superClass, GenericTypeDesc[] interfaces) {
        StringBuilder buffer = new StringBuilder(256);
        SignatureDesc.appendTypeArguments(buffer, typeArguments);
        SignatureDesc.appendType(buffer, superClass);
        SignatureDesc.appendTypes(buffer, interfaces);
        return buffer.toString();
    }

    protected static void appendTypeArguments(StringBuilder buffer, TypeVariableDesc[] typeArguments) {
        if (typeArguments != null && typeArguments.length > 0) {
            buffer.append('<');
            for (TypeVariableDesc typeArgument : typeArguments) {
                AbstractGenericTypeDesc desc;
                buffer.append(typeArgument.getName()).append(':');
                GenericTypeDesc bounds = typeArgument.getBounds();
                if (bounds == null) {
                    bounds = ClassTypeDesc.forType(Object.class);
                }
                if (bounds instanceof ClassTypeDesc) {
                    desc = (ClassTypeDesc)bounds;
                    if (((ClassTypeDesc)desc).isInterface()) {
                        buffer.append(':');
                    }
                } else if (bounds instanceof ParameterizedTypeDesc && ((ParameterizedTypeDesc)(desc = (ParameterizedTypeDesc)bounds)).getRawType().isInterface()) {
                    buffer.append(':');
                }
                SignatureDesc.appendType(buffer, bounds);
            }
            buffer.append('>');
        }
    }

    protected static void appendTypes(StringBuilder buffer, TypeDesc[] types) {
        if (types != null && types.length > 0) {
            for (TypeDesc type : types) {
                SignatureDesc.appendType(buffer, type);
            }
        }
    }

    protected static void appendTypes(StringBuilder buffer, GenericTypeDesc[] types) {
        if (types != null && types.length > 0) {
            for (GenericTypeDesc type : types) {
                SignatureDesc.appendType(buffer, type);
            }
        }
    }

    protected static void appendType(StringBuilder buffer, TypeDesc type) {
        buffer.append((type == null ? TypeDesc.VOID : type).getSignature());
    }

    protected static void appendType(StringBuilder buffer, GenericTypeDesc type) {
        buffer.append(type.getSignature());
    }

    private static class External
    implements Externalizable {
        private String mDescriptor;

        public External(String desc) {
            this.mDescriptor = desc;
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeUTF(this.mDescriptor);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException {
            this.mDescriptor = in.readUTF();
        }

        public Object readResolve() throws ObjectStreamException {
            throw new UnsupportedOperationException("SignatureDesc.readResolve");
        }
    }
}

