/*
 * Decompiled with CFR 0.152.
 */
package org.teatrove.trove.classfile;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.teatrove.trove.classfile.Attribute;
import org.teatrove.trove.classfile.ConstantClassInfo;
import org.teatrove.trove.classfile.ConstantPool;
import org.teatrove.trove.classfile.ConstantUTFInfo;
import org.teatrove.trove.classfile.Modifiers;

class InnerClassesAttr
extends Attribute {
    private List mInnerClasses = new ArrayList();

    public InnerClassesAttr(ConstantPool cp) {
        super(cp, "InnerClasses");
    }

    public void addInnerClass(String inner, String outer, String name, Modifiers modifiers) {
        ConstantClassInfo innerInfo = ConstantClassInfo.make(this.mCp, inner);
        ConstantClassInfo outerInfo = outer == null ? null : ConstantClassInfo.make(this.mCp, outer);
        ConstantUTFInfo nameInfo = name == null ? null : ConstantUTFInfo.make(this.mCp, name);
        this.mInnerClasses.add(new Info(innerInfo, outerInfo, nameInfo, modifiers.getModifier()));
    }

    public Info[] getInnerClassesInfo() {
        Info[] infos = new Info[this.mInnerClasses.size()];
        return this.mInnerClasses.toArray(infos);
    }

    @Override
    public int getLength() {
        return 2 + 8 * this.mInnerClasses.size();
    }

    @Override
    public void writeDataTo(DataOutput dout) throws IOException {
        int size = this.mInnerClasses.size();
        dout.writeShort(size);
        for (int i = 0; i < size; ++i) {
            ((Info)this.mInnerClasses.get(i)).writeTo(dout);
        }
    }

    static Attribute define(ConstantPool cp, String name, int length, DataInput din) throws IOException {
        InnerClassesAttr innerClasses = new InnerClassesAttr(cp);
        int size = din.readUnsignedShort();
        for (int i = 0; i < size; ++i) {
            int inner_index = din.readUnsignedShort();
            int outer_index = din.readUnsignedShort();
            int name_index = din.readUnsignedShort();
            int af = din.readUnsignedShort();
            ConstantClassInfo inner = inner_index == 0 ? null : (ConstantClassInfo)cp.getConstant(inner_index);
            ConstantClassInfo outer = outer_index == 0 ? null : (ConstantClassInfo)cp.getConstant(outer_index);
            ConstantUTFInfo innerName = name_index == 0 ? null : (ConstantUTFInfo)cp.getConstant(name_index);
            Info info = new Info(inner, outer, innerName, af);
            innerClasses.mInnerClasses.add(info);
        }
        return innerClasses;
    }

    public static class Info {
        private ConstantClassInfo mInner;
        private ConstantClassInfo mOuter;
        private ConstantUTFInfo mName;
        private int mModifier;

        Info(ConstantClassInfo inner, ConstantClassInfo outer, ConstantUTFInfo name, int modifier) {
            this.mInner = inner;
            this.mOuter = outer;
            this.mName = name;
            this.mModifier = modifier;
        }

        public ConstantClassInfo getInnerClass() {
            return this.mInner;
        }

        public ConstantClassInfo getOuterClass() {
            return this.mOuter;
        }

        public String getInnerClassName() {
            if (this.mName == null) {
                return null;
            }
            return this.mName.getValue();
        }

        public Modifiers getModifiers() {
            return new Modifiers(this.mModifier);
        }

        public void writeTo(DataOutput dout) throws IOException {
            if (this.mInner == null) {
                dout.writeShort(0);
            } else {
                dout.writeShort(this.mInner.getIndex());
            }
            if (this.mOuter == null) {
                dout.writeShort(0);
            } else {
                dout.writeShort(this.mOuter.getIndex());
            }
            if (this.mName == null) {
                dout.writeShort(0);
            } else {
                dout.writeShort(this.mName.getIndex());
            }
            dout.writeShort(this.mModifier);
        }
    }
}

