/*
 * Decompiled with CFR 0.152.
 */
package org.teatrove.trove.classfile;

public class GenericDescriptor {
    private String prefix;
    private String signature;
    private StringBuilder types = new StringBuilder(128);

    public GenericDescriptor() {
    }

    public GenericDescriptor(String signature) {
        this("", signature);
    }

    public GenericDescriptor(String prefix, String signature) {
        this.prefix = prefix;
        this.signature = signature;
    }

    public String getPrefix() {
        if (this.prefix == null) {
            this.prefix = '<' + this.types.toString() + '>';
        }
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getSignature() {
        return this.signature;
    }

    public void setSignature(String signature) {
        this.signature = signature;
    }

    public String getTypes() {
        return this.types.toString();
    }

    public void addType(String name, String signature) {
        this.types.append(name).append(':').append(signature);
    }

    public int hashCode() {
        return 17 * this.signature.hashCode() ^ 11 * this.types.hashCode();
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof GenericDescriptor) {
            GenericDescriptor desc = (GenericDescriptor)other;
            return this.getSignature().equals(desc.getSignature()) && this.getTypes().equals(desc.getTypes());
        }
        return false;
    }
}

