/*
 * Decompiled with CFR 0.152.
 */
package org.teatrove.trove.classfile;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.teatrove.trove.classfile.Attribute;
import org.teatrove.trove.classfile.ConstantClassInfo;
import org.teatrove.trove.classfile.ConstantPool;

class ExceptionsAttr
extends Attribute {
    private List mExceptions = new ArrayList(2);

    public ExceptionsAttr(ConstantPool cp) {
        super(cp, "Exceptions");
    }

    public String[] getExceptions() {
        int size = this.mExceptions.size();
        String[] names = new String[size];
        for (int i = 0; i < size; ++i) {
            names[i] = ((ConstantClassInfo)this.mExceptions.get(i)).getType().getRootName();
        }
        return names;
    }

    public void addException(ConstantClassInfo type) {
        this.mExceptions.add(type);
    }

    @Override
    public int getLength() {
        return 2 + 2 * this.mExceptions.size();
    }

    @Override
    public void writeDataTo(DataOutput dout) throws IOException {
        int size = this.mExceptions.size();
        dout.writeShort(size);
        for (int i = 0; i < size; ++i) {
            ConstantClassInfo info = (ConstantClassInfo)this.mExceptions.get(i);
            dout.writeShort(info.getIndex());
        }
    }

    static Attribute define(ConstantPool cp, String name, int length, DataInput din) throws IOException {
        ExceptionsAttr attr = new ExceptionsAttr(cp);
        int size = din.readUnsignedShort();
        length -= 2;
        for (int i = 0; i < size; ++i) {
            int index = din.readUnsignedShort();
            length -= 2;
            ConstantClassInfo info = (ConstantClassInfo)cp.getConstant(index);
            attr.addException(info);
        }
        if (length > 0) {
            din.skipBytes(length);
        }
        return attr;
    }
}

