/*
 * Decompiled with CFR 0.152.
 */
package org.teatrove.trove.classfile;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.teatrove.trove.classfile.ConstantClassInfo;
import org.teatrove.trove.classfile.ConstantPool;
import org.teatrove.trove.classfile.FixedLocation;
import org.teatrove.trove.classfile.Location;
import org.teatrove.trove.classfile.LocationRange;

public class ExceptionHandler
implements LocationRange {
    private Location mStart;
    private Location mEnd;
    private Location mCatch;
    private ConstantClassInfo mCatchType;

    public ExceptionHandler(Location startLocation, Location endLocation, Location catchLocation, ConstantClassInfo catchType) {
        this.mStart = startLocation;
        this.mEnd = endLocation;
        this.mCatch = catchLocation;
        this.mCatchType = catchType;
    }

    @Override
    public Location getStartLocation() {
        return this.mStart;
    }

    @Override
    public Location getEndLocation() {
        return this.mEnd;
    }

    public Location getCatchLocation() {
        return this.mCatch;
    }

    public ConstantClassInfo getCatchType() {
        return this.mCatchType;
    }

    public int compareTo(Object obj) {
        if (this == obj) {
            return 0;
        }
        LocationRange other = (LocationRange)obj;
        int result = this.getStartLocation().compareTo(other.getStartLocation());
        if (result == 0) {
            result = this.getEndLocation().compareTo(other.getEndLocation());
        }
        if (result == 0 && obj instanceof ExceptionHandler) {
            result = this.getCatchLocation().compareTo(((ExceptionHandler)other).getCatchLocation());
        }
        return result;
    }

    public void writeTo(DataOutput dout) throws IOException {
        int start_pc = this.getStartLocation().getLocation();
        int end_pc = this.getEndLocation().getLocation();
        int handler_pc = this.getCatchLocation().getLocation();
        ConstantClassInfo catchType = this.getCatchType();
        int catch_type = catchType == null ? 0 : catchType.getIndex();
        this.check("exception start PC", start_pc);
        this.check("exception end PC", end_pc);
        this.check("exception handler PC", handler_pc);
        dout.writeShort(start_pc);
        dout.writeShort(end_pc);
        dout.writeShort(handler_pc);
        dout.writeShort(catch_type);
    }

    private void check(String type, int addr) throws RuntimeException {
        if (addr < 0 || addr > 65535) {
            throw new RuntimeException("Value for " + type + " out of " + "valid range: " + addr);
        }
    }

    static ExceptionHandler readFrom(ConstantPool cp, DataInput din) throws IOException {
        int start_pc = din.readUnsignedShort();
        int end_pc = din.readUnsignedShort();
        int handler_pc = din.readUnsignedShort();
        int catch_type = din.readUnsignedShort();
        ConstantClassInfo catchTypeConstant = catch_type == 0 ? null : (ConstantClassInfo)cp.getConstant(catch_type);
        return new ExceptionHandler(new FixedLocation(start_pc), new FixedLocation(end_pc), new FixedLocation(handler_pc), catchTypeConstant);
    }
}

