/*
 * Decompiled with CFR 0.152.
 */
package org.teatrove.trove.classfile;

import java.io.DataOutput;
import java.io.IOException;
import org.teatrove.trove.classfile.ConstantInfo;
import org.teatrove.trove.classfile.ConstantPool;
import org.teatrove.trove.classfile.ConstantUTFInfo;

public class ConstantStringInfo
extends ConstantInfo {
    private String mStr;
    private ConstantUTFInfo mStringConstant;

    static ConstantStringInfo make(ConstantPool cp, String str) {
        ConstantStringInfo ci = new ConstantStringInfo(cp, str);
        return (ConstantStringInfo)cp.addConstant(ci);
    }

    ConstantStringInfo(ConstantUTFInfo constant) {
        super(8);
        this.mStr = constant.getValue();
        this.mStringConstant = constant;
    }

    private ConstantStringInfo(ConstantPool cp, String str) {
        super(8);
        this.mStr = str;
        this.mStringConstant = ConstantUTFInfo.make(cp, str);
    }

    public String getValue() {
        return this.mStr;
    }

    public int hashCode() {
        return this.mStr.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof ConstantStringInfo) {
            ConstantStringInfo other = (ConstantStringInfo)obj;
            return this.mStr.equals(other.mStr);
        }
        return false;
    }

    @Override
    boolean hasPriority() {
        return true;
    }

    @Override
    public void writeTo(DataOutput dout) throws IOException {
        super.writeTo(dout);
        dout.writeShort(this.mStringConstant.getIndex());
    }

    public String toString() {
        return "CONSTANT_String_info: " + this.getValue();
    }
}

