/*
 * Decompiled with CFR 0.152.
 */
package org.teatrove.trove.classfile;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.teatrove.trove.classfile.ConstantClassInfo;
import org.teatrove.trove.classfile.ConstantDoubleInfo;
import org.teatrove.trove.classfile.ConstantFieldInfo;
import org.teatrove.trove.classfile.ConstantFloatInfo;
import org.teatrove.trove.classfile.ConstantInfo;
import org.teatrove.trove.classfile.ConstantIntegerInfo;
import org.teatrove.trove.classfile.ConstantInterfaceMethodInfo;
import org.teatrove.trove.classfile.ConstantLongInfo;
import org.teatrove.trove.classfile.ConstantMethodInfo;
import org.teatrove.trove.classfile.ConstantNameAndTypeInfo;
import org.teatrove.trove.classfile.ConstantStringInfo;
import org.teatrove.trove.classfile.ConstantUTFInfo;
import org.teatrove.trove.classfile.Descriptor;
import org.teatrove.trove.classfile.MethodDesc;
import org.teatrove.trove.classfile.TypeDesc;

public class ConstantPool {
    private Map mConstants = new HashMap();
    private Vector mIndexedConstants;
    private int mEntries;
    private boolean mPreserveOrder;

    ConstantPool() {
    }

    private ConstantPool(Vector indexedConstants) {
        this.mIndexedConstants = indexedConstants;
        int size = indexedConstants.size();
        for (int i = 1; i < size; ++i) {
            ConstantInfo ci = (ConstantInfo)indexedConstants.get(i);
            if (ci == null) continue;
            this.mConstants.put(ci, ci);
            this.mEntries += ci.getEntryCount();
        }
        this.mPreserveOrder = true;
    }

    public ConstantInfo getConstant(int index) {
        if (this.mIndexedConstants == null) {
            throw new ArrayIndexOutOfBoundsException("Constant pool indexes have not been assigned");
        }
        return (ConstantInfo)this.mIndexedConstants.get(index);
    }

    public Set getAllConstants() {
        return Collections.unmodifiableSet(this.mConstants.keySet());
    }

    public int getSize() {
        return this.mEntries;
    }

    public ConstantClassInfo addConstantClass(String className) {
        return ConstantClassInfo.make(this, className);
    }

    public ConstantClassInfo addConstantClass(String className, int dim) {
        return ConstantClassInfo.make(this, className, dim);
    }

    public ConstantClassInfo addConstantClass(TypeDesc type) {
        return ConstantClassInfo.make(this, type);
    }

    public ConstantFieldInfo addConstantField(String className, String fieldName, TypeDesc type) {
        return ConstantFieldInfo.make(this, ConstantClassInfo.make(this, className), ConstantNameAndTypeInfo.make(this, fieldName, type));
    }

    public ConstantMethodInfo addConstantMethod(String className, String methodName, TypeDesc ret, TypeDesc[] params) {
        MethodDesc md = MethodDesc.forArguments(ret, params);
        return ConstantMethodInfo.make(this, ConstantClassInfo.make(this, className), ConstantNameAndTypeInfo.make(this, methodName, md));
    }

    public ConstantInterfaceMethodInfo addConstantInterfaceMethod(String className, String methodName, TypeDesc ret, TypeDesc[] params) {
        MethodDesc md = MethodDesc.forArguments(ret, params);
        return ConstantInterfaceMethodInfo.make(this, ConstantClassInfo.make(this, className), ConstantNameAndTypeInfo.make(this, methodName, md));
    }

    public ConstantMethodInfo addConstantConstructor(String className, TypeDesc[] params) {
        return this.addConstantMethod(className, "<init>", null, params);
    }

    public ConstantIntegerInfo addConstantInteger(int value) {
        return ConstantIntegerInfo.make(this, value);
    }

    public ConstantLongInfo addConstantLong(long value) {
        return ConstantLongInfo.make(this, value);
    }

    public ConstantFloatInfo addConstantFloat(float value) {
        return ConstantFloatInfo.make(this, value);
    }

    public ConstantDoubleInfo addConstantDouble(double value) {
        return ConstantDoubleInfo.make(this, value);
    }

    public ConstantStringInfo addConstantString(String str) {
        return ConstantStringInfo.make(this, str);
    }

    public ConstantUTFInfo addConstantUTF(String str) {
        return ConstantUTFInfo.make(this, str);
    }

    public ConstantNameAndTypeInfo addConstantNameAndType(String name, Descriptor type) {
        return ConstantNameAndTypeInfo.make(this, name, type);
    }

    public ConstantInfo addConstant(ConstantInfo constant) {
        ConstantInfo info = (ConstantInfo)this.mConstants.get(constant);
        if (info != null) {
            return info;
        }
        int entryCount = constant.getEntryCount();
        if (this.mIndexedConstants != null && this.mPreserveOrder) {
            int size = this.mIndexedConstants.size();
            this.mIndexedConstants.setSize(size + entryCount);
            this.mIndexedConstants.set(size, constant);
        }
        this.mConstants.put(constant, constant);
        this.mEntries += entryCount;
        return constant;
    }

    public void writeTo(DataOutput dout) throws IOException {
        int size = this.getSize() + 1;
        if (size >= 65535) {
            throw new RuntimeException("Constant pool entry count cannot exceed 65535: " + size);
        }
        dout.writeShort(size);
        if (this.mIndexedConstants == null || !this.mPreserveOrder) {
            this.mIndexedConstants = new Vector(size);
            this.mIndexedConstants.setSize(size);
            int index = 1;
            for (ConstantInfo constant : this.mConstants.keySet()) {
                if (!constant.hasPriority()) continue;
                constant.mIndex = index;
                this.mIndexedConstants.set(index, constant);
                index += constant.getEntryCount();
            }
            for (ConstantInfo constant : this.mConstants.keySet()) {
                if (constant.hasPriority()) continue;
                constant.mIndex = index;
                this.mIndexedConstants.set(index, constant);
                index += constant.getEntryCount();
            }
        }
        for (int i = 1; i < size; ++i) {
            Object obj = this.mIndexedConstants.get(i);
            if (obj == null) continue;
            ((ConstantInfo)obj).writeTo(dout);
        }
    }

    public static ConstantPool readFrom(DataInput din) throws IOException {
        int index;
        int entryCount;
        int size = din.readUnsignedShort();
        Vector<Object> constants = new Vector<Object>(size);
        constants.setSize(size);
        for (index = 1; index < size; index += entryCount) {
            Object constant;
            byte tag = din.readByte();
            entryCount = 1;
            switch (tag) {
                case 1: {
                    constant = new ConstantUTFInfo(din.readUTF());
                    break;
                }
                case 3: {
                    constant = new ConstantIntegerInfo(din.readInt());
                    break;
                }
                case 4: {
                    constant = new ConstantFloatInfo(din.readFloat());
                    break;
                }
                case 5: {
                    constant = new ConstantLongInfo(din.readLong());
                    ++entryCount;
                    break;
                }
                case 6: {
                    constant = new ConstantDoubleInfo(din.readDouble());
                    ++entryCount;
                    break;
                }
                case 7: 
                case 8: {
                    constant = new TempEntry(tag, din.readUnsignedShort());
                    break;
                }
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    constant = new TempEntry(tag, din.readShort() << 16 | din.readUnsignedShort());
                    break;
                }
                default: {
                    throw new IOException("Invalid constant pool tag: " + tag);
                }
            }
            if (constant instanceof ConstantInfo) {
                ((ConstantInfo)constant).mIndex = index;
            }
            constants.set(index, constant);
        }
        for (index = 1; index < size; ++index) {
            ConstantPool.resolve(constants, index);
        }
        return new ConstantPool(constants);
    }

    private static ConstantInfo resolve(List constants, int index) {
        Object constant = constants.get(index);
        if (constant == null) {
            return null;
        }
        if (constant instanceof ConstantInfo) {
            return (ConstantInfo)constant;
        }
        TempEntry entry = (TempEntry)constant;
        int data = entry.mData;
        int index1 = data & 0xFFFF;
        Object constant1 = constants.get(index1);
        ConstantInfo ci1 = constant1 instanceof ConstantInfo ? (ConstantInfo)constant1 : ConstantPool.resolve(constants, index1);
        ConstantInfo ci = null;
        block0 : switch (entry.mTag) {
            case 7: {
                ci = new ConstantClassInfo((ConstantUTFInfo)ci1);
                break;
            }
            case 8: {
                ci = new ConstantStringInfo((ConstantUTFInfo)ci1);
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                int index2 = data >> 16;
                Object constant2 = constants.get(index2);
                ConstantInfo ci2 = constant2 instanceof ConstantInfo ? (ConstantInfo)constant2 : ConstantPool.resolve(constants, index2);
                switch (entry.mTag) {
                    case 9: {
                        ci = new ConstantFieldInfo((ConstantClassInfo)ci2, (ConstantNameAndTypeInfo)ci1);
                        break block0;
                    }
                    case 10: {
                        ci = new ConstantMethodInfo((ConstantClassInfo)ci2, (ConstantNameAndTypeInfo)ci1);
                        break block0;
                    }
                    case 11: {
                        ci = new ConstantInterfaceMethodInfo((ConstantClassInfo)ci2, (ConstantNameAndTypeInfo)ci1);
                        break block0;
                    }
                    case 12: {
                        ci = new ConstantNameAndTypeInfo((ConstantUTFInfo)ci2, (ConstantUTFInfo)ci1);
                    }
                }
            }
        }
        ci.mIndex = index;
        constants.set(index, ci);
        return ci;
    }

    private static class TempEntry {
        public int mTag;
        public int mData;

        public TempEntry(int tag, int data) {
            this.mTag = tag;
            this.mData = data;
        }
    }
}

