/*
 * Decompiled with CFR 0.152.
 */
package org.teatrove.trove.classfile;

import java.io.DataOutput;
import java.io.IOException;
import org.teatrove.trove.classfile.ConstantInfo;
import org.teatrove.trove.classfile.ConstantPool;
import org.teatrove.trove.classfile.ConstantUTFInfo;
import org.teatrove.trove.classfile.Descriptor;

public class ConstantNameAndTypeInfo
extends ConstantInfo {
    private String mName;
    private Descriptor mType;
    private ConstantUTFInfo mNameConstant;
    private ConstantUTFInfo mDescriptorConstant;

    static ConstantNameAndTypeInfo make(ConstantPool cp, String name, Descriptor type) {
        ConstantNameAndTypeInfo ci = new ConstantNameAndTypeInfo(cp, name, type);
        return (ConstantNameAndTypeInfo)cp.addConstant(ci);
    }

    ConstantNameAndTypeInfo(ConstantUTFInfo nameConstant, ConstantUTFInfo descConstant) {
        super(12);
        this.mNameConstant = nameConstant;
        this.mDescriptorConstant = descConstant;
        this.mName = nameConstant.getValue();
        this.mType = Descriptor.parse(descConstant.getValue());
    }

    private ConstantNameAndTypeInfo(ConstantPool cp, String name, Descriptor type) {
        super(12);
        this.mName = name;
        this.mType = type;
        this.mNameConstant = ConstantUTFInfo.make(cp, name);
        this.mDescriptorConstant = ConstantUTFInfo.make(cp, this.mType.toString());
    }

    public String getName() {
        return this.mName;
    }

    public Descriptor getType() {
        return this.mType;
    }

    public int hashCode() {
        return this.mName.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof ConstantNameAndTypeInfo) {
            ConstantNameAndTypeInfo other = (ConstantNameAndTypeInfo)obj;
            return this.mName.equals(other.mName) && this.mType.toString().equals(other.mType.toString());
        }
        return false;
    }

    @Override
    public void writeTo(DataOutput dout) throws IOException {
        super.writeTo(dout);
        dout.writeShort(this.mNameConstant.getIndex());
        dout.writeShort(this.mDescriptorConstant.getIndex());
    }

    public String toString() {
        return "CONSTANT_NameAndType_info: " + this.getName() + ", " + this.getType();
    }
}

