/*
 * Decompiled with CFR 0.152.
 */
package org.teatrove.trove.classfile;

import java.io.DataOutput;
import java.io.IOException;
import org.teatrove.trove.classfile.ConstantInfo;
import org.teatrove.trove.classfile.ConstantPool;

public class ConstantFloatInfo
extends ConstantInfo {
    private Float mValue;

    static ConstantFloatInfo make(ConstantPool cp, float value) {
        ConstantFloatInfo ci = new ConstantFloatInfo(value);
        return (ConstantFloatInfo)cp.addConstant(ci);
    }

    ConstantFloatInfo(float value) {
        super(4);
        this.mValue = new Float(value);
    }

    ConstantFloatInfo(Float value) {
        super(4);
        this.mValue = value;
    }

    public Float getValue() {
        return this.mValue;
    }

    public int hashCode() {
        return this.mValue.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof ConstantFloatInfo) {
            ConstantFloatInfo other = (ConstantFloatInfo)obj;
            return this.mValue.equals(other.mValue);
        }
        return false;
    }

    @Override
    boolean hasPriority() {
        return true;
    }

    @Override
    public void writeTo(DataOutput dout) throws IOException {
        super.writeTo(dout);
        dout.writeFloat(this.mValue.floatValue());
    }

    public String toString() {
        return "CONSTANT_Float_info: " + this.getValue();
    }
}

